# coding:utf-8
"""
删除不需要的虚拟节点
"""
import json
import os

from easysuite import settings
from plugins.ROC.py_scripts.common.utils.loadjson.load_node_nics import LoadNodeNics
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson
from plugins.ROC.py_scripts.common.utils.loadjson.load_json_from_file import LoadJsonFromFile


def filter_vm_res(kvs, custom_conditions, src_dir_path):
    """
    功能：删除不需要的虚拟节点
    """
    nodes_resource_dict = ParseCustomJson.get_lld_param_dict(src_dir_path,
                                                             "nodes_resource.json")
    node_vm_res = nodes_resource_dict.get("node_vm_res")
    old_node_list = add_org_res(node_vm_res, kvs)
    node_vm_res = filter_no_used_node(custom_conditions, kvs, node_vm_res)
    return node_vm_res, old_node_list


def filter_no_used_node(custom_conditions, kvs, node_vm_res):
    """
    查找no_used_node
    :param custom_conditions:
    :param kvs:
    :param node_vm_res:
    :return:
    """
    rm_node_vm_res_list = list()
    # 非IP收敛场景下删除不需要的节点
    if kvs.get("is_support_lvs", "") != "yes":
        for node_vm in node_vm_res:
            node_name = node_vm.get("nodeName")
            if node_name in custom_conditions.get("no_addition_ms_gw_nodes",
                                                  []):
                rm_node_vm_res_list.append(node_vm)
    remove_opt_nodes = get_remove_opt_nodes(kvs, custom_conditions)
    # 没有选中的可选组件，删除对应的节点
    for node_vm in node_vm_res:
        node_name = node_vm.get("nodeName")
        for node_type in remove_opt_nodes:
            if node_name.startswith(node_type):
                rm_node_vm_res_list.append(node_vm)
                break
    for node_vm in rm_node_vm_res_list:
        if node_vm.get("nodeName") in \
                [node_vm_item.get("nodeName") for node_vm_item in node_vm_res]:
            node_vm_res.remove(node_vm)
    node_vm_res.sort(
        key=lambda x: x.get("nodeName", "") if not x.get("nodeName", "").startswith("NE_Mgr")
        else "NE_Mgr" + x.get("nodeName", "").replace("NE_Mgr", "").zfill(5))
    return node_vm_res


def filter_blade_node_relationships(kvs, custom_conditions, src_dir_path):
    """
    功能：删除规划部署中不需要的虚拟节点
    """
    nodes_resource_dict = ParseCustomJson.get_lld_param_dict(src_dir_path,
                                                             "nodes_resource.json")
    blade_node_relationships = nodes_resource_dict.get("blade_node_relationships")
    remove_opt_nodes = get_remove_opt_nodes(kvs, custom_conditions)
    for blade in blade_node_relationships:
        rm_node_list = list()
        nodes_list = blade.get("nodes", [])
        for node in blade.get("nodes", []):
            node_name = node.get("nodeName")
            # 非IP收敛场景下删除不需要的节点
            if kvs.get("is_support_lvs", "") != "yes" and node_name in custom_conditions.get(
                    "no_addition_ms_gw_nodes", []):
                rm_node_list.append(node)

            for node_type in remove_opt_nodes:
                if node_name.startswith(node_type):
                    rm_node_list.append(node)
        for node in rm_node_list:
            nodes_list.remove(node)
    return blade_node_relationships


def get_remove_opt_nodes(kvs, custom_conditions):
    """
    移除可选的节点
    :param kvs;
    :param custom_conditions;
    :return:remove_opt_nodes
    """

    selected_comps = kvs.get("install_plan", "").split(",")
    optional_comps = custom_conditions.get("optional_comp", "")
    opt_component_exception_path = os.path.join("config_user_define",
                                                "opt_component_exception_define.json")
    opt_component_exception = LoadJsonFromFile.load_json_from_file(opt_component_exception_path)
    not_selected_comps = set(optional_comps).difference(set(selected_comps))
    remove_opt_nodes = list()
    for comp in not_selected_comps:
        remove_opt_nodes += opt_component_exception.get(comp, {}).get("remove_node_type_if_not_sel",
                                                                      [])
    return remove_opt_nodes


def add_org_res(node_vm_res, kvs):
    """
    增加节点设置
    :param node_vm_res;
    :param kvs:
    :return:
    """
    org_res_dict = dict()
    task_id = kvs.get("task_id", "")
    org_res_path = os.path.join(settings.TEMP_DIR, "source_info", str(task_id), "org_product_info",
                                "org_res.json")
    if os.path.exists(org_res_path):
        org_res_dict = json.load(open(org_res_path, 'r', encoding="utf8"))
    org_node_nics_path = os.path.join(settings.TEMP_DIR, "source_info", str(task_id),
                                      "org_product_info",
                                      "org_node_nics_list.json")
    org_nodes_nics_list = list()
    if os.path.exists(org_node_nics_path):
        nic_list = json.load(open(org_node_nics_path, 'r', encoding="utf8"))
        org_nodes_nics_list = LoadNodeNics.generate_node_nics_data(nic_list)
    org_node_nic_names = [node_nic.node_instance for node_nic in org_nodes_nics_list]
    node_name_list = [node.get("nodeName", "") for node in node_vm_res]
    old_node_list = list()
    for node_name in org_node_nic_names:
        node_res = org_res_dict.get(node_name, {})
        old_node_list.append(node_name)
        if node_name not in node_name_list and node_name not in ["vms", "VRM01", "VRM02"]:
            node = {
                "nodeName": node_name,
                "node_vm_define": {
                    "CPU": node_res.get("cpu", "0"),
                    "memory": node_res.get("memory", "0"),
                    "storage": node_res.get("storage", "0"),
                    "IOPS": 1000,
                    "io_block": "8K",
                    "rw_ratio": "6:4"
                }
            }
            node_vm_res.append(node)
            old_node_list.append(node_name)
    return old_node_list
