# coding:utf-8
"""
生成前台网卡表格
"""
from plugins.ROC.py_scripts.common.utils.add_increase_node_depends import AddIncreaseNodeDepends
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.utils.expansion_common_function import get_balde_switch_list


class FulFillCnaTable():
    """
    生成前台网卡表格
    """

    def __init__(self, kvs, pkgs, src_dir_path, custom_conditions):
        self.pkgs = pkgs
        self.kvs = kvs
        self.custom_conditions = custom_conditions
        self.support_ipv6 = kvs.get("support_ipv6", "No")
        self.src_dir_path = src_dir_path

    def exe(self):
        """
        功能：填充CNA
        :return:
        """
        self.modify_target_platform_config(self.pkgs)

    def modify_target_platform_config(self, ctrl_set_item):
        """
        改变设置
        :param ctrl_set_item:
        :return:
        """
        blade_switch = get_balde_switch_list(self.kvs)
        if not blade_switch[2]:
            return

        cna_nic_extra_dict = {
            "optionalIDs": "plat_rh1288_cna_nic_optical,plat_rh1288_cna_nic_electrical",
            "optionalDepValues": "Optical,Electrical",
            "dependsID": "server_nic_type",
            "dependsOp": "in",
            "dependsAction": "optional",
            "dependsValue": "Optical|Electrical",
            "visible": "false"
        }
        server_type = self.kvs.get("server_type", "").lower()
        nic_type = "PCIe|1|1" if "taishan" in server_type else "PCIe|O|1|1"
        ctrl_sets = []
        for i in range(1, blade_switch[2] + 1):
            controls_tmp = []

            cna_id = ConfigControls.get_config("plat_rh1288_cna_id_%s" % str(i), str(i))
            controls_tmp.append(cna_id)
            cna_num = str(i) if i > 9 else "0%s" % str(i)
            cna_hostname = ConfigControls.get_config("plat_rh1288_cna_hostname_%s" % str(i),
                                                     "CNA_%s" % cna_num)
            controls_tmp.append(cna_hostname)

            cna_nic = ConfigControls.get_config("plat_rh1288_cna_nic_%s" % str(i), nic_type,
                                                cfg_type="string",
                                                editable="false", other=cna_nic_extra_dict)
            ctrl_sets.append(cna_nic)

            cna_ip = ConfigControls.get_config("plat_rh1288_cna_ip_%s" % str(i), "",
                                               editable="true", cfg_type="ip")
            controls_tmp.append(cna_ip)
            if self.kvs.get("scene", "") == "C00":
                cna_mask = ConfigControls.get_config("plat_rh1288_cna_mask_%s" % str(i), "",
                                                     editable="true", cfg_type="ip",
                                                     other={"isMask": "true"})
                controls_tmp.append(cna_mask)

                cna_gw = ConfigControls.get_config("plat_rh1288_cna_gw_%s" % str(i), "",
                                                   editable="true", cfg_type="ip")
                controls_tmp.append(cna_gw)

                cna_password = ConfigControls.get_config("plat_rh1288_cna_password_%s" % str(i), "",
                                                         editable="true",
                                                         cfg_type="password",
                                                         other={"pswtype": "vrm",
                                                                "refuser": "plat_cna_user",
                                                                "dependsType": "single",
                                                                "dependsID": "obj_cna_psw",
                                                                "dependsOp": "eq",
                                                                "dependsValue": "obj_cna_psw",
                                                                "dependsAction": "copyfrom"})
                controls_tmp.append(cna_password)
            if i <= blade_switch[0]:
                for config in controls_tmp:
                    config["editable"] = "false"
                    config["required"] = "false"
            ctrl_sets.extend(controls_tmp)
        ctrl_set_item.update({"controls": ctrl_sets})
