# coding:utf-8
"""
生成Ibmc网卡表格
"""
from plugins.ROC.py_scripts.common.utils.add_increase_node_depends import AddIncreaseNodeDepends
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.utils.expansion_common_function import get_balde_switch_list


class FulFillIbmcTable():
    """
    生成前台网卡表格
    """

    def __init__(self, kvs, pkgs, src_dir_path, custom_conditions):
        self.pkgs = pkgs
        self.kvs = kvs
        self.custom_conditions = custom_conditions
        self.support_ipv6 = kvs.get("support_ipv6", "No")
        self.src_dir_path = src_dir_path

    def exe(self):
        """
        功能：填充IBMC
        :return:
        """
        self.modify_target_servers_config(self.pkgs)

    def modify_target_servers_config(self, ctrl_set_item):
        """
        改变服务器设置
        :param ctrl_set_item;
        :return:
        """
        blade_switch = get_balde_switch_list(self.kvs)
        if not blade_switch[2]:
            return

        server_type = self.kvs.get("server_type", "").lower()
        ctrl_sets = []
        for i in range(1, blade_switch[2] + 1):
            pre_fix = (server_type, i)
            controls_tmp = []
            server_slot = ConfigControls.get_config("acc_%s_server_slot_%d" % pre_fix, str(i))
            controls_tmp.append(server_slot)

            server_bmcip = ConfigControls.get_config("server_%s_server_bmcip_%d" % pre_fix, "",
                                                     editable="true",
                                                     cfg_type="ip")
            controls_tmp.append(server_bmcip)

            server_bmcmask = ConfigControls.get_config("server_%s_server_bmcmask_%d" % pre_fix, "",
                                                       editable="true",
                                                       cfg_type="ip", required="false",
                                                       other={"isMask": "true"})
            controls_tmp.append(server_bmcmask)

            server_bmcgw = ConfigControls.get_config("server_%s_server_bmcgw_%d" % pre_fix, "",
                                                     editable="true",
                                                     cfg_type="ip", required="false")
            controls_tmp.append(server_bmcgw)

            server_bmcuser = ConfigControls.get_config("acc_%s_server_bmcuser_%d" % pre_fix,
                                                       "Administrator",
                                                       editable="true",
                                                       cfg_type="string")
            controls_tmp.append(server_bmcuser)

            server_bmcpwd = ConfigControls.get_config("acc_%s_server_bmcpwd_%d" % pre_fix, "",
                                                      required="true",
                                                      editable="true",
                                                      cfg_type="single_password",
                                                      other={"pswtype": "bmc",
                                                             "refuser": "acc_%s_server"
                                                                        "_bmcuser_%d" % pre_fix,
                                                             "dependsType": "single",
                                                             "dependsID": "obj_bmc_psw",
                                                             "dependsOp": "eq",
                                                             "dependsValue": "obj_bmc_psw",
                                                             "dependsAction": "copyfrom"
                                                             })
            controls_tmp.append(server_bmcpwd)

            server_snmppwd = ConfigControls.get_config("acc_%s_server_snmppwd_%d" % pre_fix, "",
                                                       required="true",
                                                       editable="true",
                                                       cfg_type="password",
                                                       other={"pswtype": "bmc",
                                                              "refuser": "acc_%s_server"
                                                                         "_bmcuser_%d" % pre_fix,
                                                              "dependsType": "single",
                                                              "dependsID": "obj_snmp_psw",
                                                              "dependsOp": "eq",
                                                              "dependsValue": "obj_snmp_psw",
                                                              "dependsAction": "copyfrom"
                                                              })
            controls_tmp.append(server_snmppwd)
            if i <= blade_switch[0]:
                for config in controls_tmp:
                    config["editable"] = "false"
                    config["required"] = "false"
            ctrl_sets.extend(controls_tmp)
        ctrl_set_item.update({"controls": ctrl_sets})
