# coding: utf-8
"""
生成前台网卡表格
"""
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.utils.expansion_common_function import get_balde_switch_list


class FulFillRaidTable():
    """
    生成前台网卡表格
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions

    def exe(self):
        """
        功能：填充IBMC
        :return:
        """

        self.modify_target_raid_config()

    def modify_target_raid_config(self):
        """
        函数说明：修改raid表格信息
        :return:
        """
        blade_switch = get_balde_switch_list(self.kvs)
        if not blade_switch[2]:
            return

        ctrl_sets = []
        kvs = self.kvs
        server_type = kvs.get("server_type", "").lower()
        scene = kvs.get("scene", "")
        fi_num_dict = self.custom_conditions.get("fi_num_dict")

        for blade_num_int in range(1, blade_switch[2] + 1):
            if blade_num_int <= blade_switch[0]:
                continue
            ctrl_sets_tmp = []
            blade_num = str(blade_num_int)
            ctrl_sets_tmp.append(
                ConfigControls.get_config("raid_%s_blade_slot_%s" % (server_type, blade_num),
                                          blade_num))
            group_num = "1"
            raid10_num = "12"
            raid0_num = 0
            fi_num = fi_num_dict.get(blade_num, 0)
            if self.kvs.get("support_minimize", "").lower() == "yes":
                fi_num = 0
            if server_type in ["2288x_v5", "taishan2280"] and fi_num >= 1 and scene in ['C00']:
                raid0_num = 2 * fi_num
                group_num = str(raid0_num + 1)
                raid10_num = str(12 - raid0_num)
            raid_group_num = ConfigControls.get_config(
                "raid_%s_group_num_%s" % (server_type, blade_num),
                group_num, cfg_type="text")
            ctrl_sets_tmp.append(raid_group_num)

            raid_blade_harddisk_config = ConfigControls.get_config(
                "raid_blade_harddisk_config_%s" % blade_num,
                "raid_blade_harddisk_config_%s" % blade_num,
                cfg_type="group")
            server_blade_control = list()
            server_blade_group1_harddisk_num = ConfigControls.get_config(
                "server_%s_blade_group1_harddisk_num_%s" % (server_type, blade_num),
                raid10_num, cfg_type="text",
                editable="true")
            server_blade_control.append(server_blade_group1_harddisk_num)

            for groupnum in range(2, 2 + raid0_num):
                server_blade_group2_harddisk_num = ConfigControls.get_config(
                    "server_%s_blade_group%s_harddisk_num_%s" % (server_type, groupnum, blade_num),
                    "1", cfg_type="text")
                server_blade_control.append(server_blade_group2_harddisk_num)
            raid_blade_harddisk_config.update({"controls": server_blade_control})
            ctrl_sets_tmp.append(raid_blade_harddisk_config)

            raid_blade_type_config = ConfigControls.get_config(
                "raid_blade_type_config_%s" % blade_num,
                "raid_blade_type_config_%s" % blade_num,
                cfg_type="group",
                editable="true", required="true")
            raid_blade_type_config_controls = list()
            server_blade_group1_raid_type = ConfigControls.get_config(
                "server_%s_blade_group1_raid_type_%s" % (server_type, blade_num),
                "RAID10", cfg_type="text", editable="true")
            raid_blade_type_config_controls.append(server_blade_group1_raid_type)
            for groupnum in range(2, 2 + raid0_num):
                server_blade_group2_raid_type = ConfigControls.get_config(
                    "server_%s_blade_group%s_raid_type_%s" % (server_type, groupnum, blade_num),
                    "RAID0", cfg_type="text", editable="true")
                raid_blade_type_config_controls.append(server_blade_group2_raid_type)
            raid_blade_type_config.update({"controls": raid_blade_type_config_controls})
            ctrl_sets_tmp.append(raid_blade_type_config)
            ctrl_sets.extend(ctrl_sets_tmp)
        self.ctrl_set.update({"controls": ctrl_sets})
