# coding: utf-8
"""
根据具体条件修改网卡列表
"""
import copy
import json
import os

from plugins.ROC.py_scripts.common.model.usage_nic import UsageNic
from plugins.ROC.py_scripts.common.model.usage_nic_for_float import UsageNicForFloat
from plugins.ROC.py_scripts.common.utils.loadjson.load_json_from_file import LoadJsonFromFile
from .nics_business import NicsBusiness

NORTH_FLOATIP_USAGE_NORTHBASE = "Northbound"
NORTH_FLOATIP_USAGE_APIMLB = "apimlb4"
NORTH_FLOATIP_USAGE_NORTHBASEBOUND = "NorthboundBaseIP"
NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE = "northbound_network"
NORTH_FLOATIP_USAGE_APIMLB_USAGETYPE = "northbound_network"
NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE = "northbound_network"
NORTH_FLOATIP_USAGE_NBIRSIP_USAGETYPE = "nbirsip"
NORTH_FLOATIP_USAGE_ACCESSIP2 = "ACCESSIP2"
LB_DR_L2_ACTIVE_VIP = "LB-DR-L2-ACTIVE-VIP"
LB_DR_L2_STANDBY_VIP = "LB-DR-L2-STANDBY-VIP"

COPY_NETWORK_NIC = {
    "use_single_network": "eth1",
    "use_northbound_network": "eth3",
    "use_southbound_network": "eth5",
}
COPY_NETWORK_USAGE_TYPE = {
    "use_single_network": "NCE_DataSync",
    "use_northbound_network": "northbound_network",
    "use_southbound_network": "southbound_network",
}
ALARM_NETWORK_NIC_DICT = {
    "use_inter_node_network": "eth0",
    "use_hardware_manage_network": "eth4",
    "use_southbound_network": "eth2",
    "use_northbound_network": "eth3",
    "use_protection_copy_network": "eth1"
}
ALARM_NETWORK_USAGE_TYPE_DICT = {
    "use_inter_node_network": "inter_node_network",
    "use_hardware_manage_network": "HDmgmt_network",
    "use_southbound_network": "southbound_network",
    "use_northbound_network": "use_northbound_network",
    "use_protection_copy_network": "NCE_DataSync"
}


class GetConditionsNics():
    """
    根据具体条件修改网卡列表
    """

    def __init__(self, node_instance_nics, kvs, custom_conditions):
        self.node_instance_nics = copy.deepcopy(node_instance_nics)
        self.kvs = kvs
        self.custom_conditions = custom_conditions
        self.drheartbeat_nodes = custom_conditions.get("drheartbeat_nodes", "")
        self.drheartbeat_float_nodes = custom_conditions.get("drheartbeat_float_nodes", "")
        self.node_role_list = custom_conditions.get("node_role_list", "")
        self.lvs_groups = custom_conditions.get("lvs_groups", "")

    def fulfill_mgmtalm_sbi(self, node_nic, nics):
        """
        补充告警上报网络网卡
        :param node_nic:
        :param nics:
        :return:
        """
        kvs = self.kvs
        alarm_report_network = kvs.get("alarm_report_network", "")
        if alarm_report_network and \
                ((kvs.get("scene", "") == "C00" and kvs.get("is_single_scene", "") == "Yes") or
                 (kvs.get("scene", "") == "C00" and node_nic.node_instance.startswith("OMP_"))):
            alarm_usage = "MGMTALM_SBI"
            alarm_description_zh, alarm_description_en = NicsBusiness.get_usage_desc(
                alarm_usage, "HDmgmt_network")
            need_add_alarm_nic = False

            if not alarm_description_zh or not alarm_description_en:
                alarm_description_zh = "用于管理面告警转发南向接收告警"
                alarm_description_en = "MGMTALM_SBI"

            alarm_nic = ALARM_NETWORK_NIC_DICT.get(alarm_report_network, "")
            usage_type = ALARM_NETWORK_USAGE_TYPE_DICT.get(alarm_report_network, "")

            if alarm_report_network == "use_northbound_network":
                node_role = NicsBusiness.get_nicnode_role(
                    self.node_role_list, node_nic.node_instance)
                if node_role and "MGR" in node_role and node_nic.node_instance == "OMP_01" and \
                        (kvs.get("is_single_scene", "") == "Yes" or
                         kvs.get("support_minimize", "") == "Yes"):
                    alarm_usage = "MGMTALM_SBI:ACCESSIP:WEBMGMTIP"
            if alarm_nic not in nics:
                need_add_alarm_nic = True
            if need_add_alarm_nic:
                nics.append(alarm_nic)
                copy_usage_nic = UsageNic(alarm_usage, alarm_nic, usage_type, [], "", "",
                                          usage_description_zh=alarm_description_zh,
                                          usage_description_en=alarm_description_en)
                node_nic.usage_nic_list.append(copy_usage_nic)
                node_nic.usage_nic_list = sorted(
                    node_nic.usage_nic_list, key=lambda x: x.nic)
            else:
                for usage_nic_item in node_nic.usage_nic_list:
                    if usage_nic_item.nic == alarm_nic:
                        usage_nic_item.usage = "%s:%s" % (
                            usage_nic_item.usage, alarm_usage)
                        usage_nic_item.usage_description_zh = "%s:%s" % (
                            usage_nic_item.usage_description_zh, alarm_description_zh)
                        usage_nic_item.usage_description_en = "%s:%s" % (
                            usage_nic_item.usage_description_en, alarm_description_en)
                        # 去重
                        usage_nic_item.usage = ":".join(
                            list(set(usage_nic_item.usage.split(":"))))
                        usage_nic_item.usage_description_zh = ":".join(
                            list(set(usage_nic_item.usage_description_zh.split(":"))))
                        usage_nic_item.usage_description_en = ":".join(
                            list(set(usage_nic_item.usage_description_en.split(":"))))

    def fulfill_drheartbeat_usage_nic(self, copy_nic, nics, node_nic, copy_usage_dict):
        """
        填充异地容灾的固定网卡
        :param copy_nic:
        :param nics:
        :param node_nic:
        :param copy_usage_dict:
        :return:
        """
        copy_usage = copy_usage_dict.get("copy_usage")
        usage_type = copy_usage_dict.get("usage_type")
        copy_description_zh = copy_usage_dict.get("copy_description_zh")
        copy_description_en = copy_usage_dict.get("copy_description_en")
        is_single_scene = self.kvs.get("is_single_scene", "")
        copy_usage_nic = None
        if copy_nic not in nics:
            nics.append(copy_nic)
            copy_usage_nic = UsageNic(copy_usage, copy_nic, usage_type, [], None, None,
                                      usage_description_zh=copy_description_zh,
                                      usage_description_en=copy_description_en)
            node_nic.usage_nic_list.append(copy_usage_nic)
            node_nic.usage_nic_list = sorted(
                node_nic.usage_nic_list, key=lambda x: x.nic)
        else:
            for usage_nic_item in node_nic.usage_nic_list:
                if usage_nic_item.nic == copy_nic:
                    copy_usage_nic = usage_nic_item
                    if usage_type != "inter_node_network" or is_single_scene == "Yes":
                        usage_nic_item.usage = "%s:%s" % (usage_nic_item.usage, copy_usage)
                        usage_nic_item.usage_description_zh = "%s:%s" % (
                            usage_nic_item.usage_description_zh, copy_description_zh)
                        usage_nic_item.usage_description_en = "%s:%s" % (
                            usage_nic_item.usage_description_en, copy_description_en)
                        usage_nic_item.usage = ":".join(
                            list(set(usage_nic_item.usage.split(":"))))
                        usage_nic_item.usage_description_zh = ":".join(
                            list(set(usage_nic_item.usage_description_zh.split(":"))))
                        usage_nic_item.usage_description_en = ":".join(
                            list(set(usage_nic_item.usage_description_en.split(":"))))
        return copy_usage_nic

    def fulfill_drheartbeat(self, node_nic, nics):
        """
        补充异地容灾复制网络网卡
        :param node_nic:
        :param nics:
        :return:
        """
        if self.kvs.get("protection_copy_network", "") and node_nic.node_instance in \
                self.drheartbeat_nodes and self.kvs.get("protection", "") == \
                "id_protection_hot" and self.kvs.get("protection_copy_network", "") != \
                "use_inter_node_network":
            copy_usage = "DRHEARTBEAT"
            copy_usage_nic = UsageNic()
            copy_description_zh, copy_description_en = NicsBusiness.get_usage_desc(
                copy_usage, "NCE_DataSync")
            if not copy_description_en or not copy_description_zh:
                copy_description_zh = "数据复制/心跳IP"
                copy_description_en = "DRHEARTBEAT"

            node_role = NicsBusiness.get_nicnode_role(
                self.node_role_list, node_nic.node_instance)
            if node_role and "MGR" in node_role and \
                    (self.kvs.get("support_minimize", "") == "Yes"
                     or self.kvs.get("is_single_scene", "") == "Yes"):
                copy_usage, copy_description_zh, copy_description_en = \
                    NicsBusiness.merge_dr_float_usage(copy_usage, copy_description_zh,
                                                      copy_description_en)

            copy_nic = COPY_NETWORK_NIC.get(self.kvs.get("protection_copy_network", ""), "")
            usage_type = COPY_NETWORK_USAGE_TYPE.get(
                self.kvs.get("protection_copy_network", ""), "")

            if self.kvs.get("protection_copy_network", "") == "use_northbound_network":
                node_role = NicsBusiness.get_nicnode_role(self.node_role_list,
                                                          node_nic.node_instance)
                if node_role and "MGR" in node_role and \
                        (self.kvs.get("support_minimize", "") == "Yes"
                         or self.kvs.get("is_single_scene", "") == "Yes"):
                    copy_usage = "%s:%s" % (copy_usage, "ACCESSIP:WEBMGMTIP")

            copy_usage_dict = {
                "copy_usage": copy_usage,
                "usage_type": usage_type,
                "copy_description_zh": copy_description_zh,
                "copy_description_en": copy_description_en
            }

            copy_usage_nic = self.fulfill_drheartbeat_usage_nic(copy_nic, nics, node_nic,
                                                                copy_usage_dict)
            if node_nic.node_instance in self.drheartbeat_float_nodes \
                    and node_nic.node_instance.endswith("_01") and \
                    self.kvs.get("support_minimize", "") != "Yes" and \
                    self.kvs.get("is_single_scene", "") != "Yes":
                critical_nodes = ""
                for node_name_tmp in self.drheartbeat_float_nodes:
                    if node_nic.node_instance.replace("_01", "") in node_name_tmp \
                            and node_name_tmp.endswith("_02"):
                        critical_nodes = node_name_tmp
                NicsBusiness.fulfill_drheartbeat_float_nic(critical_nodes, copy_nic,
                                                           copy_usage_nic.float_usage_nic_list)

    def fullfill_north_float_ip(self, node_nic):
        """
        单管场景添加北向浮动网卡
        :param node_nic:
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "")
        node_name = node_nic.node_instance
        protection = kvs.get("protection", "")
        if is_single_scene == "Yes" and protection == "id_protection_hot" and \
                kvs.get("node_float_ip", "") == "id_protect_floatip_yes":

            north_floatip_usage_northbase_zh, north_floatip_usage_northbase_en = \
                NicsBusiness.get_usage_desc(
                    NORTH_FLOATIP_USAGE_NORTHBASE,
                    NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE)
            north_floatip_usage_apimlb_zh, north_floatip_uasge_apimlb_en = \
                NicsBusiness.get_usage_desc(
                    NORTH_FLOATIP_USAGE_APIMLB,
                    NORTH_FLOATIP_USAGE_APIMLB_USAGETYPE)
            if not north_floatip_uasge_apimlb_en or not north_floatip_usage_apimlb_zh or \
                    not north_floatip_usage_northbase_en or not north_floatip_usage_northbase_zh:
                north_floatip_usage_apimlb_zh = "APIGW使用的北向IP"
                north_floatip_uasge_apimlb_en = "the North IP using by APIGW"
                north_floatip_usage_northbase_zh = "北向网络通信IP"
                north_floatip_usage_northbase_en = \
                    "IP address for northbound network communication."

            north_floatip_usage_accessip2_zh, north_floatip_usage_accessip2_en = \
                NicsBusiness.get_usage_desc(
                    NORTH_FLOATIP_USAGE_ACCESSIP2,
                    NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE)
            if not north_floatip_usage_accessip2_zh or not north_floatip_usage_accessip2_en:
                north_floatip_usage_accessip2_zh = "接入IP2"
                north_floatip_usage_accessip2_en = "ACCESSIP2"

            float_usage_nic = UsageNicForFloat(
                critical_node_instance='',
                exclusive='no',
                ip='',
                mask='',
                nic="eth3:1",
                nic_flag="",
                route=None,
                sub_type=None,
                usage=":".join(
                    [NORTH_FLOATIP_USAGE_NORTHBASE, NORTH_FLOATIP_USAGE_APIMLB,
                     NORTH_FLOATIP_USAGE_ACCESSIP2]),
                usage_type=NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE,
                usage_description_zh=":".join(
                    [north_floatip_usage_northbase_zh, north_floatip_usage_apimlb_zh,
                     north_floatip_usage_accessip2_zh]),
                usage_description_en=":".join(
                    [north_floatip_usage_northbase_en, north_floatip_uasge_apimlb_en,
                     north_floatip_usage_accessip2_en]),
            )
            node_role = NicsBusiness.get_nicnode_role(
                self.node_role_list, node_name)
            if node_role and "MGR" in node_role:
                for usage_nic in node_nic.usage_nic_list:
                    if usage_nic and usage_nic.nic == "eth3":
                        usage_nic.float_usage_nic_list.append(float_usage_nic)

    def deal_with_northip_usage_while_dr(self, node_nic):
        """
        单管场景添加北向浮动网卡后调整固定网卡和浮动网卡用途
        :param node_nic:
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "")
        protection = kvs.get("protection", "")
        node_name = node_nic.node_instance
        node_role = NicsBusiness.get_nicnode_role(
            self.node_role_list, node_name)

        if node_role and "MGR" in node_role and is_single_scene == "Yes":
            for usage_nic in node_nic.usage_nic_list:
                if usage_nic and usage_nic.nic == "eth3":
                    usage_list = usage_nic.usage.split(':')
                    usage_zh_list = usage_nic.usage_description_zh.split(':')
                    usage_en_list = usage_nic.usage_description_en.split(':')
                    usage_dict = {
                        "usage_list": usage_list,
                        "usage_zh_list": usage_zh_list,
                        "usage_en_list": usage_en_list,
                    }
                    if protection == "id_protection_hot" and \
                            kvs.get("node_float_ip", "") == "id_protect_floatip_yes":
                        if NORTH_FLOATIP_USAGE_NORTHBASE in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_NORTHBASE,
                                NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE, usage_dict,
                                action="remove")
                        if NORTH_FLOATIP_USAGE_APIMLB in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_APIMLB,
                                NORTH_FLOATIP_USAGE_APIMLB_USAGETYPE, usage_dict, action="remove")
                        if NORTH_FLOATIP_USAGE_ACCESSIP2 in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_ACCESSIP2,
                                NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE,
                                usage_dict, action="remove")
                        if NORTH_FLOATIP_USAGE_NORTHBASEBOUND not in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_NORTHBASEBOUND,
                                NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                                action="add")
                    else:
                        if NORTH_FLOATIP_USAGE_NORTHBASE not in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_NORTHBASE,
                                NORTH_FLOATIP_USAGE_NORTHBASE_USAGETYPE, usage_dict, action="add")
                        if NORTH_FLOATIP_USAGE_APIMLB not in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_APIMLB,
                                NORTH_FLOATIP_USAGE_APIMLB_USAGETYPE, usage_dict, action="add")
                        if NORTH_FLOATIP_USAGE_NORTHBASEBOUND in usage_list:
                            NicsBusiness.remove_usage_descript_nic(
                                NORTH_FLOATIP_USAGE_NORTHBASEBOUND,
                                NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                                action="remove")
                    usage_nic.usage = ':'.join(usage_dict.get("usage_list", []))
                    usage_nic.usage_description_zh = ':'.join(usage_dict.get("usage_zh_list", []))
                    usage_nic.usage_description_en = ':'.join(usage_dict.get("usage_en_list", []))

    def deal_float_usage_in_dr(self, node_nic):
        """
        管控析LVS收敛场景调节GW2_01节点的虚拟网卡
        :param node_nic:
        :return:
        """
        kvs = self.kvs
        is_protection = kvs.get("protection", "")
        is_support_lvs = kvs.get("is_support_lvs", "")
        is_support_dr_float = kvs.get("is_support_dr_float", "")
        node_name = node_nic.node_instance
        if is_support_lvs == "yes" and node_name == "GW2_01":
            for usage_nic in node_nic.usage_nic_list:
                self.modify_float_df_float(is_support_dr_float, is_protection, usage_nic)

        if is_support_lvs == "yes" and is_protection == "id_protection_hot"\
                and node_name.startswith("Common_Service"):
            for usage_nic in node_nic.usage_nic_list:
                self.modify_nic_usage_in_dr(is_support_dr_float, usage_nic)

    def modify_nic_usage_in_dr(self, is_support_dr_float, usage_nic):
        """
        :param is_support_dr_float:
        :param usage_nic:
        :return:
        """
        if usage_nic and usage_nic.nic == "eth0":
            float_usage_nic_list = usage_nic.float_usage_nic_list
            if is_support_dr_float == "yes" and len(float_usage_nic_list) > 0:
                for float_usage_nic_item in float_usage_nic_list:
                    usage_list = float_usage_nic_item.usage.split(':')
                    usage_zh_list = float_usage_nic_item.usage_description_zh.split(':')
                    usage_en_list = float_usage_nic_item.usage_description_en.split(':')
                    usage_dict = {
                        "usage_list": usage_list,
                        "usage_zh_list": usage_zh_list,
                        "usage_en_list": usage_en_list,
                    }
                    if NORTH_FLOATIP_USAGE_ACCESSIP2 not in usage_list:
                        NicsBusiness.remove_usage_descript_nic(
                            NORTH_FLOATIP_USAGE_ACCESSIP2,
                            NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                            action="add")
                    float_usage_nic_item.usage = ':'.join(usage_dict.get("usage_list", []))
                    float_usage_nic_item.usage_description_zh = ':'.join(
                        usage_dict.get("usage_zh_list", []))
                    float_usage_nic_item.usage_description_en = ':'.join(
                        usage_dict.get("usage_en_list", []))

    def modify_float_df_float(self, is_support_dr_float, is_protection, usage_nic):
        """
        :param is_protection:
        :param is_support_dr_float:
        :param usage_nic:
        :return:
        """
        if usage_nic and usage_nic.nic == "eth3":
            float_usage_nic_list = usage_nic.float_usage_nic_list

            if is_support_dr_float == "yes" and is_protection == "id_protection_hot":
                self.modify_float_usage_nic_dr_float_1(float_usage_nic_list)
            else:
                delete_item = ""
                delete_item = self.modify_float_nic_df_float_2(delete_item,
                                                               float_usage_nic_list)
                if delete_item and delete_item in float_usage_nic_list:
                    float_usage_nic_list.remove(delete_item)

    @staticmethod
    def modify_float_nic_df_float_2(delete_item, float_usage_nic_list):
        """
        :param delete_item:
        :param float_usage_nic_list:
        :return:
        """
        for float_usage_nic_item in float_usage_nic_list:
            if float_usage_nic_item.nic == "eth3:1":
                usage_list = float_usage_nic_item.usage.split(':')
                usage_zh_list = float_usage_nic_item.usage_description_zh.split(':')
                usage_en_list = float_usage_nic_item.usage_description_en.split(':')
                usage_dict = {
                    "usage_list": usage_list,
                    "usage_zh_list": usage_zh_list,
                    "usage_en_list": usage_en_list,
                }
                if LB_DR_L2_STANDBY_VIP in usage_list:
                    NicsBusiness.remove_usage_descript_nic(
                        LB_DR_L2_STANDBY_VIP,
                        NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                        action="remove")
                float_usage_nic_item.usage = ':'.join(usage_dict.get("usage_list", []))
                float_usage_nic_item.usage_description_zh = ':'.join(
                    usage_dict.get("usage_zh_list", []))
                float_usage_nic_item.usage_description_en = ':'.join(
                    usage_dict.get("usage_en_list", []))

            if float_usage_nic_item.nic == "eth3:2":
                usage_list = float_usage_nic_item.usage.split(':')
                usage_zh_list = float_usage_nic_item.usage_description_zh.split(':')
                usage_en_list = float_usage_nic_item.usage_description_en.split(':')
                usage_dict = {
                    "usage_list": usage_list,
                    "usage_zh_list": usage_zh_list,
                    "usage_en_list": usage_en_list,
                }
                if LB_DR_L2_ACTIVE_VIP in usage_list:
                    NicsBusiness.remove_usage_descript_nic(
                        LB_DR_L2_ACTIVE_VIP,
                        NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                        action="remove")
                float_usage_nic_item.usage = ':'.join(usage_dict.get("usage_list", []))
                float_usage_nic_item.usage_description_zh = ':'.join(
                    usage_dict.get("usage_zh_list", []))
                float_usage_nic_item.usage_description_en = ':'.join(
                    usage_dict.get("usage_en_list", []))

            if float_usage_nic_item.usage == "":
                delete_item = float_usage_nic_item
        return delete_item

    @staticmethod
    def modify_float_usage_nic_dr_float_1(float_usage_nic_list):
        """
        :param float_usage_nic_list:
        :return:
        """
        for float_usage_nic_item in float_usage_nic_list:
            if float_usage_nic_item.nic == "eth3:2":
                usage_list = float_usage_nic_item.usage.split(':')
                usage_zh_list = float_usage_nic_item.usage_description_zh.split(':')
                usage_en_list = float_usage_nic_item.usage_description_en.split(':')
                usage_dict = {
                    "usage_list": usage_list,
                    "usage_zh_list": usage_zh_list,
                    "usage_en_list": usage_en_list,
                }
                if NORTH_FLOATIP_USAGE_NBIRSIP_USAGETYPE not in usage_list:
                    NicsBusiness.remove_usage_descript_nic(
                        NORTH_FLOATIP_USAGE_NBIRSIP_USAGETYPE,
                        NORTH_FLOATIP_USAGE_NORTHBASEBOUND_USAGETYPE, usage_dict,
                        action="add")
                float_usage_nic_item.usage = ':'.join(usage_dict.get("usage_list", []))
                float_usage_nic_item.usage_description_zh = ':'.join(
                    usage_dict.get("usage_zh_list", []))
                float_usage_nic_item.usage_description_en = ':'.join(
                    usage_dict.get("usage_en_list", []))

    def handle_node_instance_nics_single(self, node_nic):
        """
        物理机场景修改网卡
        :param node_nic:
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "")
        if len(self.node_instance_nics) == 1 and is_single_scene == "Yes":
            remove_nic_list = list()
            for usage_nic in node_nic.usage_nic_list:
                nic = usage_nic.nic
                if "eth0" in nic:
                    remove_nic_list.append(usage_nic)
            for rm_usage_nic in remove_nic_list:
                node_nic.usage_nic_list.remove(rm_usage_nic)

        if is_single_scene == "Yes":
            for usage_nic in node_nic.usage_nic_list:
                nic = usage_nic.nic
                single_nic_map = {
                    "eth0": "eth1",
                    "eth3": "eth0",
                    "eth4": "eth3",
                    "eth5": "eth2"
                }

                if "eth1" in nic and len(self.node_instance_nics) > 1:
                    usage_nic.nic = nic.replace("eth1", "eth3")
                    for float_usage_nic_item in usage_nic.float_usage_nic_list:
                        float_nic = float_usage_nic_item.nic
                        float_usage_nic_item.nic = float_nic.replace("eth1", "eth3")
                elif nic in single_nic_map:
                    usage_nic.nic = single_nic_map.get(nic, "")
                    for float_usage_nic_item in usage_nic.float_usage_nic_list:
                        float_nic = float_usage_nic_item.nic
                        float_usage_nic_item.nic = float_nic.replace(nic,
                                                                     single_nic_map.get(nic, ""))

    def filter_hide_node(self, selected_comps):
        """
        IP秒级场景在不勾选Trans组件的时候需要隐藏eth2
        :param selected_comps:
        :return:
        """
        kvs = self.kvs
        nic_hide_nodes_path = os.path.join(
            "config_user_define", "nic_hide_nodes.json")
        nic_hide_nodes = LoadJsonFromFile.load_json_from_file(
            nic_hide_nodes_path)

        for nic_hide_nodes_item in nic_hide_nodes:
            filterd_opt_comps = set(selected_comps).intersection(
                set(nic_hide_nodes_item.get("optional_comp", [])))
            condition_flag = True
            other_condition = nic_hide_nodes_item.get("other_condition")
            if other_condition:
                for condition_key in other_condition.keys():

                    if other_condition.get(condition_key) != self.kvs.get(condition_key, ""):
                        condition_flag = False
            if not nic_hide_nodes_item.get("product_id", []) or \
                    self.custom_conditions.get("id", "") in \
                    nic_hide_nodes_item.get("product_id", dict()):
                hide_node_types = nic_hide_nodes_item.get("hide_node_types", [])
                hide_nics = nic_hide_nodes_item.get("hide_nics", [])
                NicsBusiness.filter_node_nic(self.node_instance_nics,
                                             hide_node_types, hide_nics, filterd_opt_comps,
                                             condition_flag)

    def remove_opt_comps_nodes(self, selected_comps, optional_comps):
        """
         可选组件没有选中时要删除相关的节点
        :param selected_comps:
        :param optional_comps:
        :return:
        """
        opt_component_exception_path = os.path.join("config_user_define",
                                                    "opt_component_exception_define.json")
        opt_component_exception = LoadJsonFromFile.load_json_from_file(opt_component_exception_path)
        not_selected_comps = set(optional_comps).difference(set(selected_comps))
        remove_opt_nodes = list()
        for comp in not_selected_comps:
            remove_opt_nodes += opt_component_exception.get(comp, {}).get(
                "remove_node_type_if_not_sel", [])
        node_instance_nics_remove_list = list()
        # 没有选中的可选组件，删除对应的节点
        for node_nic in self.node_instance_nics:
            node_name = node_nic.node_instance
            for node_type in remove_opt_nodes:
                if node_name.startswith(node_type):
                    node_instance_nics_remove_list.append(node_nic)
                    break

        for node_nic in node_instance_nics_remove_list:
            if node_nic.node_instance in \
                    [node_nix_item.node_instance for node_nix_item in self.node_instance_nics]:
                self.node_instance_nics.remove(node_nic)

    def modify_nics_for_lvs(self):
        """
        IP收敛场景将需要收敛的节点的其他网卡删除全部合并到eth0,非收敛的场景需要将GW节点删除。
        :return:
        """
        node_instance_nics_remove_list = list()
        if self.kvs.get("is_support_lvs", "") == "yes" and self.lvs_groups:
            lvs_groups = json.loads(self.lvs_groups)
            rsnodelist = list()
            for lvs_group in lvs_groups:
                rs_node_name_list = lvs_group.get("rsnodelist")
                rsnodelist = rsnodelist + rs_node_name_list
            NicsBusiness.get_node_instance_nics_for_lvs(self.custom_conditions, self.node_instance_nics,
                                                        rsnodelist)
        else:
            # 非收敛场景，删除lvs节点
            for node_nic in self.node_instance_nics:
                node_name = node_nic.node_instance
                if node_name in self.custom_conditions.get("no_addition_ms_gw_nodes", []):
                    node_instance_nics_remove_list.append(node_nic)
        for node_nic in node_instance_nics_remove_list:
            if node_nic.node_instance in \
                    [node_nix_item.node_instance for node_nix_item in self.node_instance_nics]:
                self.node_instance_nics.remove(node_nic)

    def modify_nics_for_ipv6(self):
        """
        补充ipv6网卡信息
        :return:
        """
        ipv6_node_names = self.custom_conditions.get("ipv6_node_names", "")
        if self.kvs.get("support_ipv6", "No") == "Yes":
            for node_nic in self.node_instance_nics:
                node_name = node_nic.node_instance
                if node_name in ipv6_node_names:
                    NicsBusiness.fulfill_ipv6(node_nic)

    def exe(self):
        """
        修改网卡列表总入口
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "")
        self.modify_nics_for_lvs()
        for node_nic in self.node_instance_nics:
            nics = [usage_nic.nic for usage_nic in node_nic.usage_nic_list]
            # 补充北向网卡
            # 补充告警上报网卡
            self.fulfill_mgmtalm_sbi(node_nic, nics)
            # 补充异地容灾复制网络网卡
            self.fulfill_drheartbeat(node_nic, nics)
            # 单管场景下补充北向浮动网卡
            self.fullfill_north_float_ip(node_nic)
            self.deal_with_northip_usage_while_dr(node_nic)
            # 异地容灾场景下支持GW节点eth3虚拟网卡调整
            self.deal_float_usage_in_dr(node_nic)
            if is_single_scene == "Yes":
                # 单管场景网卡适配
                self.handle_node_instance_nics_single(node_nic)
        selected_comps = (kvs.get("install_plan", "")).split(",")
        optional_comps = self.custom_conditions.get("optional_comp", "")
        # 多网络的情况下，如果不满足ifit的条件就删除相应节点相应的网卡
        if kvs.get("mgr_network", "") == "multi_network":
            self.filter_hide_node(selected_comps)
        # 删除可选组件对应的节点
        self.remove_opt_comps_nodes(selected_comps, optional_comps)
        self.modify_nics_for_ipv6()
        return self.node_instance_nics
