# coding: utf-8
"""
修改网卡的具体方法
"""
import copy
import os
import string

from plugins.ROC.py_scripts.common.utils.loadjson.load_json_from_file import LoadJsonFromFile
from plugins.ROC.py_scripts.common.model.usage_nic_for_float import UsageNicForFloat


class NicsBusiness():
    """
    修改网卡的具体方法
    """

    @staticmethod
    def get_usage_desc(usage, usage_type):
        """
        查询网卡用途的国际化
        :param usage:
        :param usage_type:
        :return:
        """
        nic_usage_define_path = os.path.join(
            "data", "common", "config", "nic_usage_define", "nic_usage_define.json")
        nic_define = LoadJsonFromFile.load_json_from_file(
            nic_usage_define_path)
        us_description_zh = ""
        us_description_en = ""
        for nic_type in nic_define:
            if nic_type.get("usage_type", "") == usage_type:
                usage_define = nic_type.get("usage_define", "")
                for usage_item in usage_define:
                    if usage_item.get("usage", "") == usage:
                        us_description_zh = usage_item.get(
                            "description_zh", "")
                        us_description_en = usage_item.get(
                            "description_en", "")
                        break
                break
        return us_description_zh, us_description_en

    @staticmethod
    def merge_dr_float_usage(copy_usage, copy_description_zh, copy_description_en):
        """
        合并异地容灾复制网络的浮动网卡的用途
        :param copy_usage:
        :param copy_description_zh:
        :param copy_description_en:
        :return:
        """
        dr_float_usage = "globalBackendLBFloatIP"
        dr_float_usage_type = "NCE_DataSync"
        dr_float_usage_zh, dr_float_usage_en = NicsBusiness.get_usage_desc(
            dr_float_usage, dr_float_usage_type)
        if not dr_float_usage_zh or not dr_float_usage_en:
            dr_float_usage_zh = "系统间通信浮动IP"
            dr_float_usage_en = "globalBackendLBFloatIP"
        copy_usage = "%s:%s" % (copy_usage, dr_float_usage)
        copy_description_zh = "%s:%s" % (
            copy_description_zh, dr_float_usage_zh)
        copy_description_en = "%s:%s" % (
            copy_description_en, dr_float_usage_en)
        return copy_usage, copy_description_zh, copy_description_en

    @staticmethod
    def fulfill_drheartbeat_float_nic(critical_nodes, copy_nic, float_usage_nic_list):
        """
        补充异地容灾复制网络浮动网卡
        :param critical_nodes:
        :param copy_nic:
        :param float_usage_nic_list:
        :return:
        """
        dr_float_usage = "globalBackendLBFloatIP"
        dr_float_usage_type = "NCE_DataSync"
        dr_float_usage_zh, dr_float_usage_en = NicsBusiness.get_usage_desc(
            dr_float_usage, dr_float_usage_type)
        if not dr_float_usage_zh or not dr_float_usage_en:
            dr_float_usage_zh = "系统间通信浮动IP"
            dr_float_usage_en = "globalBackendLBFloatIP"

        if float_usage_nic_list:
            for float_usage_nic in float_usage_nic_list:
                if float_usage_nic.nic == "%s:1" % copy_nic:
                    float_usage_nic.usage = "%s:%s" % (
                        float_usage_nic.usage, dr_float_usage)
                    float_usage_nic.usage_description_zh = "%s:%s" % (
                        float_usage_nic.usage_description_zh,
                        dr_float_usage_zh)
                    float_usage_nic.usage_description_en = "%s:%s" % (
                        float_usage_nic.usage_description_en,
                        dr_float_usage_en)
                    # 去重
                    float_usage_nic.usage = ":".join(
                        list(set(float_usage_nic.usage.split(":"))))
                    float_usage_nic.usage_description_zh = ":".join(
                        list(set(float_usage_nic.usage_description_zh.split(":"))))
                    float_usage_nic.usage_description_en = ":".join(
                        list(set(float_usage_nic.usage_description_en.split(":"))))

        else:
            float_usage_nic = UsageNicForFloat(
                critical_node_instance=critical_nodes,
                exclusive='no',
                ip='',
                mask='',
                nic="%s:1" % copy_nic,
                nic_flag="",
                route=None,
                sub_type=None,
                usage=dr_float_usage,
                usage_type=dr_float_usage_type,
                usage_description_zh=dr_float_usage_zh,
                usage_description_en=dr_float_usage_en
            )
            float_usage_nic_list.append(float_usage_nic)

    @staticmethod
    def get_nicnode_role(node_role_list, node_name):
        """
        或者节点的角色
        :param node_role_list:
        :param node_name:
        :return:
        """
        node_role = None
        for node_role_dict in node_role_list:
            if node_role_dict.get("nodeName") == node_name:
                node_role = node_role_dict.get("node_role")
                return node_role
        return node_role

    @staticmethod
    def remove_usage_descript_nic(nic_usage, nic_usage_type, usage_dict, action):
        """
        对网卡用途进行增加或者删除
        :param nic_usage:
        :param nic_usage_type:
        :param usage_list:
        :param usage_list_zh:
        :param usage_list_en:
        :param action:
        :return:
        """
        nic_usage_zh, nic_usage_en = NicsBusiness.get_usage_desc(
            nic_usage, nic_usage_type)
        usage_list = usage_dict.get("usage_list", [])
        usage_list_zh = usage_dict.get("usage_zh_list", [])
        usage_list_en = usage_dict.get("usage_en_list", [])

        if action == "remove" and nic_usage in usage_dict.get("usage_list"):
            usage_list.remove(nic_usage)
            (nic_usage_zh in usage_list_zh) and usage_list_zh.remove(nic_usage_zh)
            (nic_usage_en in usage_list_en) and usage_list_en.remove(nic_usage_en)
        elif action == "add" and nic_usage not in usage_dict.get("usage_list"):
            usage_list.append(nic_usage)
            usage_list_zh.append(nic_usage_zh)
            usage_list_en.append(nic_usage_en)

        usage_dict["usage_list"] = usage_list
        usage_dict["usage_zh_list"] = usage_list_zh
        usage_dict["usage_en_list"] = usage_list_en

    @staticmethod
    def filter_node_nic(node_instance_nics, hide_node_types, hide_nics, filterd_opt_comps,
                        condition_flag):
        """
        如果有可选组件满足条件过滤掉不需要的节点网卡，入参为节点网卡列表,节点类型和网卡，返回值中去掉这种类型节点的指定网卡
        如果没有可选组件满足条件就将网卡设置为非必填
        :param node_instance_nics:
        :param hide_node_types:
        :param hide_nics:
        :param filterd_opt_comps:
        :param condition_flag:
        :return:
        """
        for node_nic in node_instance_nics:
            node_name = node_nic.node_instance
            node_type = node_name.rstrip(string.digits).rstrip("_")
            if node_type in hide_node_types:
                usage_nic_remove_list = list()
                for usage_nic in node_nic.usage_nic_list:
                    if usage_nic.nic in hide_nics:
                        usage_nic_remove_list.append(usage_nic)
                for rm_usage_nic in usage_nic_remove_list:
                    if filterd_opt_comps and condition_flag:
                        rm_usage_nic.required = "true"
                    else:
                        node_nic.usage_nic_list.remove(rm_usage_nic)
        return node_instance_nics

    @staticmethod
    def fulfill_ipv6(node_nic):
        """
        填充ipv6
        :param node_nic:
        :return:
        """
        ipv6_usage_nic_list = list()
        for usage_nic in node_nic.usage_nic_list:
            if "southbound" in usage_nic.usage.lower() or "northbound" in usage_nic.usage.lower():
                ipv6_usage_nic = copy.deepcopy(usage_nic)
                ipv6_usage_nic.is_ipv6 = True
                for float_usage_nic in ipv6_usage_nic.float_usage_nic_list:
                    float_usage_nic.is_ipv6 = True
                    float_usage_nic.nic = float_usage_nic.nic.split(":")[0]
                ipv6_usage_nic_list.append(ipv6_usage_nic)
                # print("ipv6")
        for ipv6_usage_nic in ipv6_usage_nic_list:
            node_nic.usage_nic_list.append(ipv6_usage_nic)

    @staticmethod
    def modify_lvs_float(usage_nic, usage_nic_last):
        """
        IP收敛场景修改浮动网卡
        :param usage_nic:
        :param usage_nic_last:
        :return:
        """
        for float_usage_nic in usage_nic.float_usage_nic_list:
            nic_index = float_usage_nic.nic.split(":")[-1]
            last_nic = "eth0:%s" % nic_index
            same_float_nic = False
            for float_usage_nic_last in usage_nic_last.float_usage_nic_list:
                if last_nic == float_usage_nic_last.nic:
                    same_float_nic = True
                    float_usage_nic_last.usage = "%s:%s" % (
                        float_usage_nic_last.usage, float_usage_nic.usage)
                    float_usage_nic_last.usage_description_en = "%s:%s" % (
                        float_usage_nic_last.usage_description_en,
                        float_usage_nic.usage_description_en)
                    float_usage_nic_last.usage_description_zh = "%s:%s" % (
                        float_usage_nic_last.usage_description_zh,
                        float_usage_nic.usage_description_zh)
                    continue
            if not same_float_nic:
                float_usage_nic.nic = last_nic
                usage_nic_last.float_usage_nic_list.append(
                    float_usage_nic)

    @staticmethod
    def get_node_instance_nics_for_lvs(custom_conditions, node_instance_nics, rsnodelist):
        """
        IP收敛场景网卡合并
        :param node_instance_nics:
        :param rsnodelist:
        :return:
        """
        not_include_fi_node = True
        for node_instance_nic in node_instance_nics:
            if node_instance_nic.node_instance in custom_conditions.get("fi_nodename_list", []):
                not_include_fi_node = False
                break
        for node_instance_nic in node_instance_nics:
            # 包含fi节点时给GW添加浮动网卡
            if not_include_fi_node and node_instance_nic.node_instance.startswith("GW"):
                float_usage_nic_list = node_instance_nic.usage_nic_list[0].float_usage_nic_list
                for float_usage_nic in float_usage_nic_list:
                    if float_usage_nic.usage == "ODAE-AP-IP":
                        float_usage_nic_list.remove(float_usage_nic)
                        break
            if node_instance_nic.node_instance not in rsnodelist:
                continue
            usage_nic_last = None
            remove_usage_nic_list = list()
            for usage_nic in node_instance_nic.usage_nic_list:
                if usage_nic.nic == "eth0":
                    usage_nic_last = usage_nic
                    break

            for usage_nic in node_instance_nic.usage_nic_list:
                if usage_nic.nic != "eth0" and (not usage_nic.is_ipv6):
                    usage_nic_last.usage = "%s:%s" % (
                        usage_nic_last.usage, usage_nic.usage)
                    usage_nic_last.usage_description_en = "%s:%s" % (
                        usage_nic_last.usage_description_en, usage_nic.usage_description_en)
                    usage_nic_last.usage_description_zh = "%s:%s" % (
                        usage_nic_last.usage_description_zh, usage_nic.usage_description_zh)
                    remove_usage_nic_list.append(usage_nic)
                    NicsBusiness.modify_lvs_float(usage_nic, usage_nic_last)
            for usage_nic in remove_usage_nic_list:
                node_instance_nic.usage_nic_list.remove(usage_nic)
        return node_instance_nics

    @staticmethod
    def merge_org_nic_list(nodes_nics_list, org_nodes_nics_list):
        """
        IP收敛场景修改浮动网卡
        :param nodes_nics_list:
        :param org_nodes_nics_list:
        :return:
        """
        def get_org_nodes_nic(node_name):
            for node_nic in org_nodes_nics_list:
                if node_nic.node_instance == node_name:
                    return node_nic
            return None

        def get_org_usage_nic(usage_nic, org_node_nic):
            for org_usage_nic in org_node_nic.usage_nic_list:
                if usage_nic.nic == org_usage_nic.nic:
                    return org_usage_nic
            return None

        def merge_float_usage_nic_list(usage_nic, org_usage_nic):
            float_nics = [float_usage_nic.nic for float_usage_nic in
                          org_usage_nic.float_usage_nic_list]
            for float_nic in usage_nic.float_usage_nic_list:
                if float_nic.nic not in float_nics:
                    org_usage_nic.float_usage_nic_list.append(float_nic)

        node_name_list = [node_nic.node_instance for node_nic in org_nodes_nics_list]
        for node_nic in nodes_nics_list:
            node_name = node_nic.node_instance
            if node_name not in node_name_list:
                org_nodes_nics_list.append(node_nic)
            else:
                org_node_nic = get_org_nodes_nic(node_name)
                nics = [usage_nic.nic for usage_nic in org_node_nic.usage_nic_list]
                for usage_nic in node_nic.usage_nic_list:
                    if usage_nic.nic not in nics:
                        org_node_nic.usage_nic_list.append(usage_nic)
                        org_usage_nic = get_org_usage_nic(usage_nic, org_node_nic)
                        merge_float_usage_nic_list(usage_nic, org_usage_nic)
        org_nodes_nics_list.sort(key=lambda x: x.node_instance)
        return org_nodes_nics_list
