import json
import os

from easysuite import settings


class CustomNodeType(object):
    def __init__(self, kvs):
        self.kvs = kvs
        self.base_path = os.path.join(settings.TEMP_DIR, "source_info",
                                      str(kvs.get("easysuite.task_id")), "org_product_info")

    def get_old_fi_nodes(self):
        """
        获得老FI节点
        :return: []
        """
        nodelists_path = os.path.join(self.base_path, "nodelists.json")
        nodelists = {}
        if os.path.exists(nodelists_path):
            nodelists = json.load(open(nodelists_path, 'r', encoding="utf8"))
        nodelist = nodelists.get("nodeList", {})
        old_fi_nodes = []
        for i in range(len(nodelist)):
            node = nodelist.get(str(i), {})
            if "FI" not in node.get("type", ""):
                continue
            old_fi_nodes.append(node.get("hostname", ""))
        return old_fi_nodes

    def get_node_type_ips(self):
        """
        获得node_type对应节点的格式
        :param kvs:
        :return:{"node_type": {"type_1": [], "type_2": []}}
        """
        node_name_type_to_ip = {"node_type": {}}
        node_name_type_to_ip["node_type"]["OLD_FI"] = []
        node_name_type_to_ip["node_type"]["OLD_FI_first"] = []
        node_name_type_to_ip["node_type"]["OLD_FI_last"] = []
        fan = False
        old_fi_nodes = self.get_old_fi_nodes()
        for node in old_fi_nodes:
            item_dic = {
                "node_name": node,
                "maintenance": "${%s_maintenance_ip}" % node,
                "passwd": "${fi_node_root_pwd}",
                "su_password": "${fi_node_pwd}",
                "username": "${fi_node_root_user}",
                "su_username": "${fi_node_user}"
            }
            node_name_type_to_ip["node_type"]["OLD_FI"].append(item_dic)
            if node == "Analyzer_FI_MgmtCtrl_01":
                fan = True
        if fan:
            for node in old_fi_nodes:
                item_dic = {
                    "node_name": node,
                    "maintenance": "${%s_maintenance_ip}" % node,
                    "passwd": "${fi_node_root_pwd}",
                    "su_password": "${fi_node_pwd}",
                    "username": "${fi_node_root_user}",
                    "su_username": "${fi_node_user}"
                }
                if node in ["Analyzer_FI_MgmtCtrl_01",
                            "Analyzer_FI_MgmtCtrl_02",
                            "Analyzer_FI_MgmtCtrl_03"]:
                    node_name_type_to_ip["node_type"]["OLD_FI_first"].append(item_dic)
                else:
                    node_name_type_to_ip["node_type"]["OLD_FI_last"].append(item_dic)
        else:
            for node in old_fi_nodes:
                item_dic = {
                    "node_name": node,
                    "maintenance": "${%s_maintenance_ip}" % node,
                    "passwd": "${fi_node_root_pwd}",
                    "su_password": "${fi_node_pwd}",
                    "username": "${fi_node_root_user}",
                    "su_username": "${fi_node_user}"
                }
                if node in ["Analyzer_Calc_Storage_01",
                            "Analyzer_Calc_Storage_02",
                            "Analyzer_Calc_Storage_03"]:
                    node_name_type_to_ip["node_type"]["OLD_FI_first"].append(item_dic)
                else:
                    node_name_type_to_ip["node_type"]["OLD_FI_last"].append(item_dic)
        self.kvs["node_name_type_to_ip"] = node_name_type_to_ip

    def exe(self):
        """
        功能：子域定制node_type，存到kvs
        :return:
        """
        self.get_node_type_ips()
