# coding:utf-8
"""
生成FI软件包列表
"""
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls


class PkgFiBusiness:
    """
    修改fi软件包列表具体方法
    """
    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.nodes_nics_list = None
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.old_controls = self.ctrl_set.get("controls", [])
        self.custom_conditions = custom_conditions

    def exe(self):
        """
        功能:填充软件包
        :return:
        """
        self.fullfill_table()

    def fullfill_table(self):
        """
        功能:填充FI软件包列表
        :return:
        """
        num = 1
        controls = []
        scene = self.kvs.get("scene")
        action = self.kvs.get("action")
        cpu_type = self.kvs.get("cpu_type")
        node_os_type = self.kvs.get("node_os_type")
        addition_packages = self.custom_conditions.get("addition_packages", [])
        package_ids = [item.get("package_id") for item in addition_packages]
        package_define = self.custom_conditions.get("package_define", [])
        filterd_pkgs = []
        for pkg in package_define:
            if (pkg.get("package_type") != "OS") and \
                    ((not pkg.get("sub_type")) or node_os_type.lower() in
                     pkg.get("sub_type").lower().replace("sles12", "suse")) and \
                    ((not pkg.get("cpu_type")) or pkg.get("cpu_type") == cpu_type):
                if pkg.get("package_type") == "FI" and pkg.get("package_id") != "pkg_bigdata":
                    if pkg.get("package_id", "") not in [filterd_pkg.get("package_id", "")
                                                         for filterd_pkg in filterd_pkgs]:
                        if action in ["expansion", "roc_expansion"] and \
                                (pkg.get("package_type") != "MGR" or
                                 pkg.get("package_id") == "pkg_icmr"):
                            filterd_pkgs.append(pkg)
                        if action == "install" or \
                                (not action):
                            if pkg.get("package_id") == "servertool_pkg" and scene not in ["C00"]:
                                continue
                            filterd_pkgs.append(pkg)

        for install_package in filterd_pkgs:
            package_id = install_package.get("package_id")
            install_pkg = install_package.get("installPkg").replace("${", "{")
            install_pkg_cfg = ConfigControls.get_config(package_id, install_pkg)
            install_pkg_cfg_mod = {"fileType": "install_resource"}
            install_pkg_cfg.update(install_pkg_cfg_mod)
            install_pkg_cfg.update({"check_type": "sign"})

            description_zh = install_package.get("package_des_zh")
            description_en = install_package.get("package_des_en")
            if action in ["expansion", "roc_expansion"]:
                install_pkg_cfg.update({"package_type": "nce_pkg", "zh_describe": description_zh,
                                        "en_describe": description_en})
                if package_id in package_ids:
                    controls.append(install_pkg_cfg)
            else:
                controls.append(ConfigControls.get_config("servertool_package_3%d" %
                                                          num, str(num)))
                controls.append(install_pkg_cfg)
                controls.append(
                    ConfigControls.get_config("servertool_package_1%d" % num,
                                              description_en, text_zh=description_zh,
                                              text_en=description_en))
                num += 1
        if not controls:
            self.ctrl_set["visible"] = "false"
        self.ctrl_set["controls"] = controls
