# coding:utf-8
"""
生成NCE软件包列表
"""
import json
import os

from easysuite import settings
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls


class PkgNceBusiness:
    """
    生成NCE软件包列表的具体方法
    """
    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.nodes_nics_list = None
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.old_controls = self.ctrl_set.get("controls", [])
        self.custom_conditions = custom_conditions

    def exe(self):
        """
        功能:填充软件包
        :return:
        """
        self.fullfill_table()

    def fullfill_table(self):
        """
        功能:填充FI软件包列表
        :return:
        """
        num = 1
        controls = []
        scene = self.kvs.get("scene")
        cpu_type = self.kvs.get("cpu_type")
        node_os_type = self.kvs.get("node_os_type")
        product_action = self.kvs.get("action")
        task_id = self.kvs.get("task_id")
        org_pkg_path = os.path.join(settings.TEMP_DIR, "source_info", str(task_id),
                                    "org_product_info",
                                    "org_pkg.json")
        org_pkg_name_list = list()
        if os.path.exists(org_pkg_path):
            org_pkg_list = json.load(open(org_pkg_path, 'r', encoding="utf8"))
            org_pkg_name_list = [org_p.get("softwareName") for org_p in org_pkg_list]
        package_define = self.custom_conditions.get("package_define", [])
        opt_packages_dict = self.custom_conditions.get("opt_packages_dict", {})
        filterd_pkgs = []
        for pkg in package_define:
            if (pkg.get("package_type") != "OS") and \
                    ((not pkg.get("sub_type")) or node_os_type.lower() in
                     pkg.get("sub_type").lower().replace("sles12", "suse")) and \
                    ((not pkg.get("cpu_type")) or pkg.get("cpu_type") == cpu_type):
                if pkg.get("package_type") != "FI" or pkg.get("package_id") == "pkg_bigdata":
                    if pkg.get("package_id", "") not in [filterd_pkg.get("package_id", "")
                                                         for filterd_pkg in filterd_pkgs]:
                        if product_action in ["expansion", "roc_expansion"] and \
                                (pkg.get("package_type") != "MGR" or
                                 (pkg.get("package_id") == "pkg_icmr" and scene not in ["C02"])):
                            filterd_pkgs.append(pkg)
                        if product_action == "install" or \
                                (not product_action):
                            if pkg.get("package_id") == "servertool_pkg" and scene not in ["C00"]:
                                continue
                            filterd_pkgs.append(pkg)

        for install_package in filterd_pkgs:
            package_id = install_package.get("package_id")
            install_pkg = install_package.get("installPkg").replace("${", "{")
            package_short_name = install_package.get("package", "")
            if package_short_name in opt_packages_dict:
                opt_remove_flag = False
                for opt_comp in opt_packages_dict.get(package_short_name, []):
                    if opt_comp not in self.kvs.get("install_plan", "").split(","):
                        opt_remove_flag = True
                if opt_remove_flag:
                    continue
            install_pkg_cfg = ConfigControls.get_config(package_id, install_pkg)
            install_pkg_cfg_mod = {"fileType": "install_resource"}
            install_pkg_cfg.update(install_pkg_cfg_mod)
            if not (install_pkg.endswith("DeployTemplate.zip") or
                    install_pkg.endswith("Expansion.zip") or
                    install_pkg.endswith("Migrate.zip")):
                install_pkg_cfg.update({"check_type": "sign"})
            else:
                install_pkg_cfg.update({"visible": "false"})
            description_zh = install_package.get("package_des_zh")
            description_en = install_package.get("package_des_en")
            if product_action in ["expansion", "roc_expansion"]:
                install_pkg_cfg.update({"package_type": "nce_pkg", "zh_describe": description_zh,
                                        "en_describe": description_en})
                if package_short_name not in org_pkg_name_list:
                    controls.append(install_pkg_cfg)
            else:
                if not (install_pkg.endswith("DeployTemplate.zip") or
                        install_pkg.endswith("Expansion.zip") or
                        install_pkg.endswith("Migrate.zip")):
                    controls.append(ConfigControls.get_config("servertool_package_3%d" %
                                                              num, str(num)))
                    controls.append(install_pkg_cfg)
                    controls.append(
                        ConfigControls.get_config("servertool_package_1%d" % num, description_zh,
                                                  text_zh=description_zh,
                                                  text_en=description_en))
                    num += 1
                else:
                    controls.append(
                        ConfigControls.get_config("servertool_package_3%d" % num, str(num),
                                                  other={"visible": "false"}))
                    controls.append(install_pkg_cfg)
                    controls.append(
                        ConfigControls.get_config("servertool_package_1%d" % num,
                                                  description_zh, text_zh=description_zh,
                                                  text_en=description_en,
                                                  other={"visible": "false"}))
        self.ctrl_set["controls"] = controls
