# coding: utf-8
"""
功能：参数修改的基类
版权信息：华为技术有限公司，版本所有(C) 2010-2020
"""
import json
import os

from plugins.ROC.py_scripts.common.utils.condition_2_path_dict import SUPPORT_IPV6, PROTECTION, \
    PROTECTION_COPY_NETWORK, ALARM_REPORT_NETWORK, NODE_FLOAT_IP, ACCESS, IP, TRANS, EAS, \
    SUPPORT_IFIT, SUPPORT_DR_FLOAT_IP
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson
from ...lld.modify_view_scripts.filter_vm_res import filter_no_used_node


def add_network_info_path(network_info_path, temp_path):
    """
    功能：network_info_path路径后面拼上temp_path，路径在shell脚本中实录，所有分隔符设置为“/”
    :param network_info_path:
    :param temp_path:
    :return:
    """
    if temp_path:
        network_info_path = "/".join([network_info_path, temp_path])
    return network_info_path


class ModifyBaseConfig():
    """
    功能：对界面参数进行修改
    """

    def __init__(self, kvs, pkgs, src_dir_path, custom_conditions):
        self.pkgs = pkgs
        self.kvs = kvs
        if kvs.get("action", "") in ["expansion", "roc_expansion"]:
            self.filling_addition_to_pkgs()
        self.src_dir_path = src_dir_path
        self.custom_conditions = custom_conditions
        if kvs.get("action", "") in ["expansion", "roc_expansion"]:
            expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                                 "expansion_param.json")
            self.kvs["changed_node_vm_res"] = expansion_param.get("changed_node_vm_res")
        # 扩容非仅产品场景更新资源变化数据到kvs
        if kvs.get("action", "") in ["expansion", "roc_expansion"] \
                and kvs.get("scene", "").lower() != "c02":
            self.update_kvs_params()
        self.support_ipv6 = kvs.get("support_ipv6", "No")
        if not self.support_ipv6:
            self.support_ipv6 = "No"
        self.ctrl_sets = list()
        self.protection = kvs.get("protection", "id_protection_single")
        if not self.protection:
            self.protection = "id_protection_single"

    def __get_network_info_path(self):
        """
        功能：获取json模板具体条件对应的路径
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "No")
        network_info_path = "/".join([kvs.get("mgr_network", "")])
        protection_copy_network = kvs.get("protection_copy_network", "")
        alarm_report_network = kvs.get("alarm_report_network", "")
        node_float_ip = kvs.get("node_float_ip", "")
        install_plan = kvs.get("install_plan", "").split(",")
        if kvs.get("action") in ["expansion", "roc_expansion"]:
            # 根据源环境软件包添加可选组件
            install_plan = self.add_install_plan()
            self.update_kvs_ifit(kvs)
        if kvs.get("is_support_lvs", "").lower() == "yes":
            network_info_path = "/".join([network_info_path, "LvsY"])

        if is_single_scene == "No" and self.support_ipv6.lower() == "yes":
            network_info_path = add_network_info_path(
                network_info_path, SUPPORT_IPV6.get("value", {}).get(self.support_ipv6))
        network_info_path = add_network_info_path(
            network_info_path, PROTECTION.get("value", {}).get(self.protection))
        if self.protection == "id_protection_hot":
            copy_network_path = \
                PROTECTION_COPY_NETWORK.get("value", {}).get(protection_copy_network)
            network_info_path = add_network_info_path(network_info_path, copy_network_path)
        if kvs.get("scene") == "C00" and alarm_report_network:
            alarm_path = ALARM_REPORT_NETWORK.get("value", {}).get(alarm_report_network, "")
            if self.kvs.get("action", "") not in ["expansion", "roc_expansion"]:
                network_info_path = add_network_info_path(network_info_path, alarm_path)
        if is_single_scene == "Yes" and node_float_ip:
            network_info_path = add_network_info_path(
                network_info_path, NODE_FLOAT_IP.get("value", {}).get(node_float_ip))
        network_info_path = self.add_opt_path(install_plan, is_single_scene, kvs, network_info_path)

        if kvs.get("is_support_dr_float", "") == "yes" and self.protection \
                == "id_protection_hot" and kvs.get("is_support_lvs", "").lower() == "yes":
            network_info_path = add_network_info_path(
                network_info_path, SUPPORT_DR_FLOAT_IP.get("value", {}).get("yes"))
        return network_info_path

    @staticmethod
    def add_opt_path(install_plan, is_single_scene, kvs, network_info_path):
        """
        添加可选节点到json后台路径
        :param install_plan:
        :param is_single_scene:
        :param kvs:
        :param network_info_path:
        :return:
        """
        if "Access" in install_plan:
            network_info_path = add_network_info_path(
                network_info_path, ACCESS.get("value", {}).get("Yes"))
        if "IP" in install_plan:
            network_info_path = add_network_info_path(
                network_info_path, IP.get("value", {}).get("Yes"))
        if "Trans" in install_plan:
            network_info_path = add_network_info_path(
                network_info_path, TRANS.get("value", {}).get("Yes"))
            if is_single_scene == "No":
                support_ifit = kvs.get("support_ifit", "")
                network_info_path = add_network_info_path(
                    network_info_path, SUPPORT_IFIT.get("value", {}).get(support_ifit))
        if "EAS" in install_plan:
            network_info_path = add_network_info_path(
                network_info_path, EAS.get("value", {}).get("Yes"))

        return network_info_path

    def get_protect_blades(self):
        """
        获取保护刀片
        :param kvs:
        :return:
        """
        protect_blades = set()
        protect_blade_num = self.kvs.get('protect_blade_num', None)
        if protect_blade_num is None:
            blade_index = self.kvs.get('plat_vcsa_protect_blade', None)
            if str(blade_index).isdigit():
                protect_blades.add(blade_index)
        elif str(protect_blade_num).isdigit():
            for index in range(int(protect_blade_num)):
                blade_index = self.kvs.get('plat_vcsa_protect_blade_{0}'.format(index+1))
                if str(blade_index).isdigit():
                    protect_blades.add(blade_index)
        return protect_blades

    def get_current_server(self):
        """
        获取当前可用的服务器编号
        :return:
        """
        if not self.kvs.get('blade_switch'):
            return set()
        current_server = [server_id for server_id in
                          self.kvs.get('blade_switch').split(',') if server_id]
        current_server_num = set(current_server)
        protect_blades = self.get_protect_blades()
        # 去除保护刀片
        current_server_num = current_server_num - protect_blades

        return current_server_num

    def modify_ctrl_data(self, ctrl_set):
        """
        功能：修改页面参数
        :param ctrl_set:
        :return:
        """
        # 修改network_plane_config的参数值
        kvs = self.kvs
        custom_conditions = self.custom_conditions
        self.modify_network_plane_config(ctrl_set)
        self.modify_nfvi_platform(ctrl_set)
        self.modify_opt_webswingmode(ctrl_set, custom_conditions)
        current_server = self.get_current_server()
        # 修改base.xml中的controls中login_used_netcard,
        for ctrl in ctrl_set.get("controls"):
            self.modify_roc_addtion(ctrl)
            self.modify_login_used_netcard(ctrl)
            self.modify_install_nic(ctrl)
            self.modify_anti_affinity_rule_common(ctrl)
            if ctrl.get("id", "") == "install_plan" \
                    and kvs.get("selcet_install_plan", "") == "No":
                ctrl["default"] = ""
                kvs["install_plan"] = ""
            elif ctrl.get("id", "") == "plat_vrm_install_mode" \
                    and kvs.get("support_minimize", "") == "Yes" and \
                    kvs.get("scene", "") in ['C00']:
                ctrl["default"] = "single_mode"

            elif ctrl.get("id", "") == "plat_vrm_server_num" and \
                    (custom_conditions.get("vrm_01_blade") in current_server):
                ctrl["default"] = custom_conditions.get("vrm_01_blade")
                self.kvs['plat_vrm_server_num'] = ctrl["default"]
            elif ctrl.get("id", "") == "plat_vrm_master_server_num" and \
                    (custom_conditions.get("vrm_01_blade") in current_server):
                ctrl["default"] = custom_conditions.get("vrm_01_blade")
                self.kvs['plat_vrm_master_server_num'] = ctrl["default"]
            elif ctrl.get("id", "") == "plat_vrm_standby_server_num" and \
                    (custom_conditions.get("vrm_02_blade") in current_server):
                ctrl["default"] = custom_conditions.get("vrm_02_blade")
                self.kvs['plat_vrm_standby_server_num'] = ctrl["default"]
            elif ctrl.get("dependsID", "") == "node_os_type" \
                    and ctrl.get("dependsAction", "") == "autofill":
                ctrl["default"] = kvs.get("node_os_type", "")

    def modify_network_plane_config(self, ctrl_set):
        """
        功能：修改安装通道网络
        :param ctrl_set:
        :return:
        """
        # 修改network_plane_config的参数值
        kvs = self.kvs
        controls = ctrl_set.get("controls")
        if ctrl_set.get("id") == "network_plane_config":
            for ctrl in controls:
                if ctrl.get("id", "") == "netcard_copy":
                    copy_network_nic_dict = {
                        "use_single_network": "bond1",
                        "use_northbound_network": "bond0"
                    }
                    protection_copy_network = kvs.get(
                        "protection_copy_network")
                    copy_network_nic = copy_network_nic_dict.get(
                        protection_copy_network, "bond1")
                    ctrl["default"] = copy_network_nic
                    kvs.update({"netcard_copy": copy_network_nic})

                elif ctrl.get("id", "") == "netcard_alarm":
                    alarm_network_nic_dict = {
                        "use_protection_copy_network": kvs.get("netcard_copy", "bond1"),
                        "use_hardware_manage_network": "bond3",
                        "use_northbound_network": "bond0",
                        "use_southbound_network": "bond2"
                    }
                    alarm_report_network = kvs.get("alarm_report_network")
                    alarm_report_nic = alarm_network_nic_dict.get(
                        alarm_report_network, "bond1")
                    ctrl["default"] = alarm_report_nic

                elif ctrl.get("id", "") == "netcard_south":
                    ctrl["default"] = "bond2"
                    if kvs.get("mgr_network") == "single_and_cloud":
                        ctrl["default"] = "bond0"

    def modify_anti_affinity_rule_common(self, ctrl):
        """
        修改anti_affinity_rule_common
        :param ctrl:
        :return:
        """
        if ctrl.get("id", "") != "anti_affinity_rule_common":
            return
        anti_affinity_nodes_str = self.custom_conditions.get(
            "anti_affinity")
        if anti_affinity_nodes_str:
            ctrl["default"] = anti_affinity_nodes_str

    def modify_install_nic(self, ctrl):
        """
        修改install_nic
        :param ctrl:
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "No")
        scene = kvs.get("scene", "")
        scale = kvs.get("scale", "")

        if ctrl.get("id", "") != "install_nic":
            return
        ctrl["default"] = "eth0"
        kvs["install_nic"] = "eth0"
        if kvs.get("install_network", "") == "use_northbound_network":
            ctrl["default"] = "eth3"
            kvs["install_nic"] = "eth3"
        if is_single_scene == "Yes":
            ctrl["default"] = kvs.get(
                "node_os_pxe_netcard", "eth0")
            kvs["install_nic"] = kvs.get(
                "node_os_pxe_netcard", "eth0")
            if scene == "C02" and scale == "K01":
                ctrl["default"] = "eth0"
                kvs["install_nic"] = "eth0"

    def modify_login_used_netcard(self, ctrl):
        """
        修改login_used_netcard
        :param ctrl:
        :return:
        """
        kvs = self.kvs
        is_single_scene = kvs.get("is_single_scene", "No")
        if ctrl.get("id", "") != "login_used_netcard":
            return
        ctrl["default"] = "eth0"
        kvs["login_used_netcard"] = "eth0"
        if kvs.get("scene") in ["C01", "C02"] and is_single_scene == "Yes":
            ctrl["default"] = "eth1"
            kvs["login_used_netcard"] = "eth1"
        if kvs.get("install_network", "") == "use_northbound_network":
            ctrl["default"] = "eth3"
            kvs["login_used_netcard"] = "eth3"
            if kvs.get("scene") in ["C01", "C02"] and is_single_scene == "Yes":
                ctrl["default"] = "eth0"
                kvs["login_used_netcard"] = "eth0"

    def modify_roc_addtion(self, ctrl):
        """
        功能：修改base.xml中已_roc_addtion等结尾的config的值
        :param ctrl:
        :return:
        """
        if not ctrl.get("id", "").endswith("_roc_addtion"):
            return
        kvs = self.kvs
        tai_shan2280_server_ctrls = ctrl.get("controls", [])
        for sub_ctrl in tai_shan2280_server_ctrls:
            if sub_ctrl.get("id").endswith("_roc_addtion"):
                depends_ids = sub_ctrl.get("dependsID", "").split(",")
                depends_values = sub_ctrl.get("dependsValue", "").split(",")
                depends_ops = sub_ctrl.get("dependsOp", "").split(",")
                idx = 0
                add_visible = "true"
                for key in depends_ids:
                    if depends_ops[idx] == "eq":
                        if kvs.get(key) != depends_values[idx]:
                            add_visible = "false"
                    if depends_ops[idx] == "exclude":
                        if kvs.get(key) == depends_values[idx]:
                            add_visible = "false"
                    idx = idx + 1
                sub_ctrl["visible"] = add_visible
                for sub_ctrl_basic in tai_shan2280_server_ctrls:
                    if sub_ctrl_basic.get("id") == \
                            sub_ctrl.get("id", "").replace("_roc_addtion", "") \
                            and add_visible == "true":
                        sub_ctrl_basic["visible"] = "false"

    def exe(self):
        """
        功能：根据product_define.json修改base.xml
        :return:
        """
        network_info_path = self.__get_network_info_path()
        # 获取源服务器数量 原数量 新增数量 目标数量
        blade_switch_num_list = [0, 0, 0]
        for pkg in self.pkgs:
            for page in pkg.get("pages", []):
                for ctrl_set_item in page.get("control_sets", []):
                    # 修改页面参数
                    self.modify_ctrl_data(ctrl_set_item)

                    if self.kvs.get("action") in ["roc_expansion", "expansion"]:
                        # 修改目标服务器
                        self.modify_target_servers_num(ctrl_set_item, blade_switch_num_list)
                        # 将可选组件及是否支持ifit保存至模板中
                        self.save_ifit_opt(ctrl_set_item)

                    if ctrl_set_item.get("id") not in ["groupbox_basic_config",
                                                       "groupbox_src_expansion_config"]:
                        continue
                    for ctrl in ctrl_set_item.get("controls", []):
                        if ctrl.get("id", "") in ["network_info_path",
                                                  "groupbox_src_expansion_config"]:
                            ctrl["default"] = network_info_path

    def modify_target_servers_num(self, ctrl_set_item, blade_switch):
        """
        函数说明：修改服务器数量
        :param ctrl_set_item:
        :param blade_switch:
        :return:
        """
        if ctrl_set_item.get("id") not in ["groupbox_dst_expansion_plan",
                                           "groupbox_src_expansion_config"]:
            return

        if ctrl_set_item.get("id") == "groupbox_src_expansion_config":
            for ctrl in ctrl_set_item.get("controls", []):
                if ctrl.get("id", "") == "source_blade_switch":
                    default = ctrl.get("default", "0").strip(",").split(",")
                    if len(default) > 1:
                        value = len(default)
                    else:
                        value = int(default[0])
                    blade_switch[0] = value
                    return

        if ctrl_set_item.get("id") == "groupbox_dst_expansion_plan":
            for ctrl in ctrl_set_item.get("controls", []):
                if ctrl.get("id", "") == "target_add_blade_switch":
                    blade_switch[1] = int(ctrl.get("default", "0"))
                    continue

                # 更新目标服务器数量
                if ctrl.get("id", "") == "target_blade_switch":
                    blade_switch[2] = blade_switch[0] + blade_switch[1]
                    ctrl.update({"default": str(blade_switch[2])})
                    self.kvs.update({"target_blade_switch": str(blade_switch[2])})
                    return

    def modify_nfvi_platform(self, ctrl_set):
        """
        函数说明：FS场景适配
        :param ctrl_set:
        :return:
        """
        if self.kvs.get("is_NFVI", "").lower() != "yes" \
                or ctrl_set.get("id", "") not in ["groupbox_calc_res_config",
                                                  "groupbox_network_res_planning"]:
            return

        product_end = self.kvs.get("product", "").split("-")[-1]
        for control in ctrl_set.get("controls", []):
            if control.get("id", "") in ["nce_vpc_default", "nce_vpc",
                                         "node_vm_eth0_logical_network_name_NCE",
                                         "node_vm_eth3_logical_network_name_NCE",
                                         "node_vm_eth2_logical_network_name_NCE",
                                         "node_vm_eth5_logical_network_name_NCE",
                                         "node_vm_eth25_logical_network_name_NCE",
                                         "node_vm_eth1_logical_network_name_NCE",
                                         "node_vm_eth0_logical_network_name_NCE"]:
                control["default"] = control.get("default", "").replace(
                    "{}", product_end).replace("88", product_end)

    def modify_opt_webswingmode(self, ctrl_set, custom_conditions):
        """
        功能：添加WebswingMode变量
        :param ctrl_set:xml表格信息
        :param custom_conditions:产品参数
        :return:
        """
        ctrl_set_id = ctrl_set.get("id", "")
        if ctrl_set_id != "groupbox_basic_config":
            return
        controls = ctrl_set.get("controls")
        opt_nodes = custom_conditions.get("opt_nodes", [])
        filter_opt_nodes = [opt_node for opt_node in opt_nodes if
                            "nmswebserver" in opt_node.lower()]
        controls_id = [control.get("id", "") for control in controls]
        if filter_opt_nodes and "WebswingMode" not in controls_id:
            node_idx_ctrl = ConfigControls.get_config("WebswingMode", "",
                                                      other={"visible": "false"})
            controls.append(node_idx_ctrl)

    def update_kvs_params(self):
        """
        功能：更新kvs参数
        :return:
        """
        expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "expansion_param.json")
        changed_node_vm_res = expansion_param.get("changed_node_vm_res")
        org_res_dict = self.get_org_file("org_res.json")
        # 更新节点资源的状态,和源环境比较取资源比较大的
        self.filter_res_status(changed_node_vm_res, org_res_dict)
        changed_node_vm_res = filter_no_used_node(
            self.custom_conditions, self.kvs, changed_node_vm_res)
        self.kvs["expansion_param"] = expansion_param
        self.kvs["org_res_dict"] = org_res_dict
        self.kvs["changed_node_vm_res"] = changed_node_vm_res

    def filter_res_status(self, changed_node_vm_res, org_res_dict):
        """
        比较规划数据和源环境数据,取资源比较大的为最终状态
        将更新过后的节点资源更新到kvs中
        :param changed_node_vm_res:
        :param org_res_dict:
        :return:
        """
        if not org_res_dict:
            return
        for changed_node_vm in changed_node_vm_res:
            # 查询源环境节点资源,源环境不存在该节点资源则报错
            node_name = changed_node_vm.get("nodeName", "")

            # 判断老节点
            if node_name not in org_res_dict:
                changed_node_vm["node_status"] = "new"
                continue

            custom_conditions = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                                   "custom_conditions.json")
            customer_param = custom_conditions.get("customer_param", {})
            node_expand_first_fi_name = customer_param.get("node_expand_first_fi_name", "")
            if not org_res_dict.get(node_name, {}):
                raise Exception("Get source resource for %s failed!" % node_name)
            # 比较源环境及规划资源,二者取较大的值
            node_vm_define = changed_node_vm.get("node_vm_define", {})
            plan_cpu = int(node_vm_define.get("CPU", "0"))
            plan_memory = int(node_vm_define.get("memory", "0"))
            plan_storage = int(node_vm_define.get("storage", "0"))
            if self.kvs.get("install_scene") == "C00" and node_name in node_expand_first_fi_name:
                plan_storage = int(customer_param.get("expand_first_fi_storage", "0")) + 250
            elif self.kvs.get("install_scene") == "C00" and \
                    customer_param.get("node_expand_fi", "") and \
                    customer_param.get("node_expand_fi", "") in node_name:
                changed_node_vm["node_status"] = "old"
                continue
            source_cpu = int(org_res_dict.get(node_name, {}).get("cpu", "0"))
            source_memory = int(org_res_dict.get(node_name, {}).get("memory", "0"))
            source_storage = int(org_res_dict.get(node_name, {}).get("storage", "0"))
            # 规划资源等于源环境节点资源,则是老节点不修改
            if (plan_cpu <= source_cpu and plan_memory <= source_memory and
                    plan_storage <= source_storage):
                changed_node_vm["node_status"] = "old"
                continue
            node_vm_define["CPU"] = max(plan_cpu, source_cpu)
            node_vm_define["memory"] = max(plan_memory, source_memory)
            node_vm_define["storage"] = max(plan_storage, source_storage)
            changed_node_vm["node_status"] = "resource_changed"
        self.add_org_res(org_res_dict, changed_node_vm_res)

    @staticmethod
    def add_org_res(org_res_dict, changed_node_vm_res):
        """
        将源节点资源添加到资源表中
        :param org_res_dict:
        :param changed_node_vm_res:
        :return:
        """
        changed_node_name = [node.get("nodeName", "") for node in changed_node_vm_res]
        for node_name, node_res in org_res_dict.items():
            if node_name in changed_node_name:
                continue
            node = {
                "nodeName": node_name,
                "node_vm_define": {
                    "CPU": node_res.get("cpu", "0"),
                    "memory": node_res.get("memory", "0"),
                    "storage": node_res.get("storage", "0"),
                    "IOPS": 1000,
                    "io_block": "8K",
                    "rw_ratio": "6:4"
                },
                "node_status": "old"
            }
            changed_node_vm_res.append(node)

    def add_install_plan(self):
        """
        扩容场景下反推出可选组件,拼接到安装脚本的寻址路径
        :return:
        """
        optional_comp = self.custom_conditions.get("optional_comp", "")
        expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "expansion_param.json")
        if not optional_comp:
            return []
        package_define = self.custom_conditions.get("package_define", [])
        target_package = [package.get("package", "") for package in package_define
                          if isinstance(package, dict)]
        org_pkg_list = self.get_org_file("org_pkg.json")
        org_pkg_name = [org_pkg.get("softwareName", "") for org_pkg in org_pkg_list
                        if isinstance(org_pkg, dict)]
        if expansion_param.get("expansion_type") in ["custom", "increment"] \
                and not optional_comp:
            pkg_name = list(set(org_pkg_name + target_package))
        else:
            pkg_name = list(set(org_pkg_name))
        opt_pkg_relative = {
            "Nmstrans": "Trans",
            "Nmsaccess": "Access",
            "Nmsip": "IP",
            "ExtAdvancedSEC": "EAS"
        }
        install_plan = []
        for opt_pkg, opt_comp in opt_pkg_relative.items():
            if opt_comp not in optional_comp:
                continue
            if opt_pkg in pkg_name:
                install_plan.append(opt_comp)
        self.kvs["install_plan"] = ",".join(install_plan)
        return install_plan

    def get_org_file(self, org_file):
        """
        从var/temp/source_info/{task_id}/org_product_info目录下获取指定文件
        :param org_file: 文件名称
        :return:
        """
        task_id = self.kvs.get("task_id", "")
        from easysuite import settings
        org_file_path = os.path.join(settings.TEMP_DIR, "source_info", str(task_id),
                                     "org_product_info", org_file)
        org_file_dict = {}
        if os.path.exists(org_file_path):
            org_file_dict = json.load(open(org_file_path, 'r', encoding="utf8"))
        return org_file_dict

    def update_kvs_ifit(self, kvs):
        """
        跟新kvs是否支持ifit
        :param kvs:
        :return:
        """
        kvs["support_ifit"] = self.is_support_ifit(kvs)

    def is_support_ifit(self, kvs):
        """
        判断是否支持ifit
        :return:
        """
        if kvs.get("mgr_network", "") == "double_network":
            return "No"
        if kvs.get("mgr_network", "") == "multi_network":
            org_node_nics_list = self.get_org_file("org_node_nics_list.json")
            for org_node in org_node_nics_list:
                if org_node.get("node_instance", "") == "Analyzer_Collector_Agent_01":
                    usage_nics = [usage_nic.get("nic", "")
                                  for usage_nic in org_node.get("usage_nic_list", "")]
                    if "eth2" in usage_nics:
                        return "Yes"
        return "No"

    def save_ifit_opt(self, ctrl_set_item):
        """
        将可选组件及是否支持ifit保存至模板中
        :return:
        """
        if ctrl_set_item.get("id") != "groupbox_src_expansion_config":
            return
        install_plan = self.kvs.get("install_plan", "")
        support_ifit = self.kvs.get("support_ifit", "")
        controls = ctrl_set_item.get("controls", [])
        ids = [control.get("id", "") for control in controls]
        self.update_controls(controls, ids, install_plan, "install_plan")
        self.update_controls(controls, ids, support_ifit, "support_ifit")

    @staticmethod
    def update_controls(controls, ids, control_default, control_id):
        """
        更新controls
        :param controls:
        :param ids:
        :param control_default:
        :param control_id:
        :return:
        """
        if control_id not in ids:
            controls.append(ConfigControls.get_config(control_id,
                                                      control_default, other={"visible": "false"}))
        else:
            for control in controls:
                if control.get("id") == control_id:
                    control["default"] = control_default

    def filling_addition_to_pkgs(self):
        """
        将子域定制信息保存至kvs中
        :return:
        """
        if self.pkgs:
            expansion_source_dict = self.get_source_from_addition()

            if isinstance(self.pkgs, dict) and \
                    self.pkgs.get("id", "") == "groupbox_src_expansion_config":
                addition_control_set = self.pkgs.get("controls", [])
                control_ids = [control.get("id", "") for control in addition_control_set]
                all_params = expansion_source_dict.get("all_params", "")
                self.save_param_to_pkgs(addition_control_set, all_params, control_ids,
                                        expansion_source_dict)
                self.kvs.update(expansion_source_dict)

    def save_param_to_pkgs(self, addition_control_set, all_params, control_ids,
                           expansion_source_dict):
        """
        保存参数到pkgs
        :param addition_control_set:
        :param all_params:
        :param control_ids:
        :param expansion_source_dict:
        :return:
        """
        for e_key, e_value in expansion_source_dict.items():
            if not isinstance(e_value, str) or e_key == "all_params":
                continue
            if e_key in control_ids:
                for control in addition_control_set:
                    if control.get("id", "") == e_key and e_value:
                        control["default"] = e_value
            elif e_key not in self.kvs and e_key in all_params:
                addition_control_set.append(
                    ConfigControls.get_config(e_key, e_value, other={"visible": "false"}))

    def get_source_from_addition(self):
        """
        从ExpansionAutoSourceDao加载addition字段
        :return:
        """
        from expansion.plan_config.dao.expansion_auto_source_dao import ExpansionAutoSourceDao
        task_id = self.kvs.get("task_id", "")
        expansion_auto_source = ExpansionAutoSourceDao.query_by_task_id(task_id)
        addition = expansion_auto_source.addition
        sourc_addition = json.loads(addition)
        return sourc_addition
