# coding:utf-8
"""
功能：AdddiskTableBusiness，该类主要涉及节添加填充节点table
版权信息：华为技术有限公司，版本所有(C) 2010-2020
"""
from plugins.ROC.py_scripts.common.utils.add_increase_node_depends import AddIncreaseNodeDepends
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.model.depends_model import Depends
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson


class AdddiskTableBusiness():
    """
    功能：添加diskTable
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions

    def fulfill_table(self):
        """
        功能：填充表格
        :return:
        """
        prefix = "node"
        controls = []
        fi_nodename_dict = self.custom_conditions.get("fi_nodename_dict")
        fi_nodename_list = self.custom_conditions.get("fi_nodename_list")
        if not fi_nodename_list:
            self.ctrl_set["visible"] = "false"
            return

        additions_nodes = self.custom_conditions.get("additions_nodes", [])
        if not set(additions_nodes).intersection(set(fi_nodename_list)):
            depends_show_all = Depends()
            depends_show_all.update_depends("is_show_all", "yes")
            ConfigControls.update_config_depends(self.ctrl_set, depends_show_all)
        server_type = self.kvs.get("server_type", "").lower()
        if not (server_type in ["2288x_v5", "taishan2280"] and
                len(fi_nodename_list) >= 3
                and self.kvs.get("scene") in ['C00']):
            self.ctrl_set["visible"] = "false"
            return

        changed_node_vm_res = self.kvs.get("changed_node_vm_res", [])
        changed_node_status = {node_vm.get("nodeName", ""): node_vm.get("node_status", "old")
                               for node_vm in changed_node_vm_res}

        for blade_id in sorted(fi_nodename_dict.keys(), key=lambda x: int(x)):
            node_names = fi_nodename_dict.get(blade_id)
            raid_num = 2
            for node_name in node_names:
                controls_tmp = self.get_controls_tmp(node_name, prefix, raid_num,
                                                     node_res=changed_node_status)
                controls.extend(controls_tmp)
                raid_num += 2
        self.ctrl_set["controls"] = controls

    def get_fi_add_disk_config(self):
        """
        功能：获取fi_add_disk_config
        :return:
        """
        fi_add_disk_config = {}
        scale = self.kvs.get("scale")
        node_resource_param_dict = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                                      "nodes_resource.json")
        fi_add_disk_define = node_resource_param_dict.get("fi_add_disk_define", "")
        code = self.custom_conditions.get("id", "")
        if code in fi_add_disk_define:
            fi_add_disk_list = fi_add_disk_define.get(code, [])
        else:
            fi_add_disk_list = fi_add_disk_define.get("default", [])

        for fi_add_disk in fi_add_disk_list:
            if scale in fi_add_disk.get("scale", []):
                fi_add_disk_config = fi_add_disk
        return fi_add_disk_config

    def get_controls_tmp(self, node_name, prefix, raid_num, node_res=None):
        """
        功能：获取controls, controls_tmp
        :param node_name:
        :param prefix:
        :param controls:
        :param raid_num:
        :param node_res:
        :return:
        """
        controls = []
        fi_add_disk_config = self.get_fi_add_disk_config()
        first_disk_size = fi_add_disk_config.get("first_disk_size")
        last_disk_size = fi_add_disk_config.get("last_disk_size")
        fmt_para = (prefix, self.kvs.get(node_name))
        custom_conditions = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                               "custom_conditions.json")
        node_expand_first_fi_name = custom_conditions.get(
            "customer_param", {}).get("node_expand_first_fi_name", "")
        if self.kvs.get("install_scene") == "C00" and node_name in node_expand_first_fi_name and \
                self.kvs.get("action") in ["expansion", "roc_expansion"]:
            last_disk_size = int(custom_conditions.get("customer_param", {}).get(
                "expand_first_fi_storage", "0"))
        controls.append(ConfigControls.get_config("%s_vm_addDisk_%s" % fmt_para, node_name))
        if int(node_name.split("_")[-1]) <= fi_add_disk_config.get("first_node_number"):
            controls.append(ConfigControls.get_config("%s_vm_addDisk_size_%s" % fmt_para,
                                                      "%d,datastore%d,datastore%d" %
                                                      (first_disk_size, raid_num, raid_num + 1),
                                                      cfg_type="string",
                                                      editable="true"))
        else:
            if "MgmtCtrl" in node_name:
                resource_info_cfg = ConfigControls.get_config("%s_vm_addDisk_size_%s" % fmt_para,
                                                              "%d" % last_disk_size,
                                                              cfg_type="string",
                                                              editable="true")
            else:
                resource_info_cfg = ConfigControls.get_config("%s_vm_addDisk_size_%s" % fmt_para,
                                                              "%d,datastore%d,datastore%d" %
                                                              (last_disk_size, raid_num,
                                                               raid_num + 1),
                                                              cfg_type="string",
                                                              editable="true")
            controls.append(resource_info_cfg)
        if node_res:
            node_status = node_res.get(node_name, "old")
            if node_status == "old":
                AddIncreaseNodeDepends.add_depends_to_configs(controls)
        return controls

    def exe(self):
        """
        填充前台资源表表格入口
        :return:
        """

        # 填充前台资源表表格入口
        self.fulfill_table()
