# coding: utf-8
"""
生成前台网卡表格
"""
import json
import logging
import os
import re

from easysuite import settings
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.utils.add_increase_node_depends import AddIncreaseNodeDepends
from .filter_vm_res import filter_vm_res
from utils.i18n import i18nDict
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson

local_logger = logging.getLogger(__name__)


class FulFillNodesResourceTable():
    """
    生成前台网卡表格
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions

    @staticmethod
    def to_anti_affinity_dict(anti_affinity):
        """
        亲和性字典
        :param anti_affinity;
        :return;
        """
        if not anti_affinity:
            return dict()
        anti_affinity_object = json.loads(anti_affinity)
        anti_affinity_dict = {}
        try:
            for name, anti_affinity_group in anti_affinity_object.items():
                menbers = anti_affinity_group.get("member", [])
                coefficient = anti_affinity_group.get("coefficient")
                anti_affinity_stra = "anti-affinity" if coefficient == "1" else "soft-anti-affinity"
                for menber in menbers:
                    anti_affinity_dict[menber] = (name, anti_affinity_stra)
        except Exception as e:
            local_logger.warning("Get anti affinity dict failed: %s" % e)
        return anti_affinity_dict

    def fulfill_vm_res(self):
        """
        完成表格
        :return:
        """
        ctrl_set = self.ctrl_set
        control_id = ctrl_set.get("id")
        is_nfvi = self.kvs.get("is_NFVI", "")
        if (is_nfvi.lower() == "yes" and control_id == "virtual_node_vm_res") \
                or (is_nfvi.lower() == "no" and control_id == "virtual_node_vm_res_nfvi"):
            ctrl_set.update({"visible": "false"})
            return
        taskmgr_lang_zh = i18nDict(os.path.join(settings.TASKMGR_PATH), lang="zh_CN")
        taskmgr_lang_en = i18nDict(os.path.join(settings.TASKMGR_PATH), lang="en_US")
        ctrl_set.update({"visible": "true"})
        opt_nodes = self.custom_conditions.get("opt_nodes")
        nfvi_param_dict = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "nodes_resource.json")

        self.node_to_server_process(nfvi_param_dict.get('node_to_blade'))

        node_vm_res, old_node_list = filter_vm_res(self.kvs,
                                                   self.custom_conditions,
                                                   self.src_dir_path)

        kvs = self.kvs
        kvs.update({"node_vm_res": node_vm_res})
        kvs.update({"old_node_list": old_node_list})
        fi_nodename_list = nfvi_param_dict.get("fi_nodename_list")
        node_to_blade = nfvi_param_dict.get("node_to_blade")
        storage_define = nfvi_param_dict.get("storage_define")
        enclosure_num = nfvi_param_dict.get("enclosure_num")
        exclude = "plat_vcsa_protect_blade_1,plat_vcsa_protect_blade_2"
        is_expansion = True if kvs.get("action") in ["expansion", "roc_expansion"] else False
        additions_nodes = []
        expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "expansion_param.json")
        changed_node_status = dict()
        if is_expansion:
            additions_nodes = expansion_param.get("additions_nodes", [])
            changed_node_vm_res = self.kvs.get("changed_node_vm_res", [])
            # 往新增节点中添加资源变化的节点
            node_res_changed = [res_node.get("nodeName", "") for res_node in changed_node_vm_res
                                if res_node.get("node_status") != "old"]
            additions_nodes.extend(node_res_changed)
            for node_name in set(additions_nodes).difference(set(old_node_list)):
                changed_node_status[node_name] = "new"
            for node_vm in changed_node_vm_res:
                if node_vm.get("nodeName", "") in old_node_list and \
                        node_vm.get("node_status") == "new":
                    node_vm["node_status"] = "old"
                changed_node_status[node_vm.get("nodeName", "")] = node_vm.get("node_status", "old")
            if self.kvs.get("scene", "") != "C02":
                node_vm_res = self.kvs.get("changed_node_vm_res", [])

        is_single_scene = self.custom_conditions.get("is_single_scene", "")
        scene = kvs.get("scene", "")
        new_controls = []
        ctrl_set["controls"] = new_controls
        num = 1
        is_editable = "true"
        if scene == "C02":
            is_editable = "false"

        auto_fill_store1 = {
            "dependsID": "storage1",
            "dependsOp": "eq",
            "dependsValue": "storage1",
            "dependsAction": "copyfrom",
            "validation_from": "storage1,storage2"
        }
        auto_fill_store2 = {
            "dependsID": "storage2",
            "dependsOp": "eq",
            "dependsValue": "storage2",
            "dependsAction": "copyfrom",
            "validation_from": "storage1,storage2"
        }
        prefix = "node"

        anti_affinity_dict = {}
        if is_single_scene.lower() == "no":
            # 获取反亲和性
            anti_affinity = self.custom_conditions.get("anti_affinity")
            anti_affinity_dict = self.to_anti_affinity_dict(anti_affinity)

        if ctrl_set.get("id").endswith("old"):
            prefix = "node_old"
        for node_vm in node_vm_res:
            cpu_min = "4"
            mem_min = "8"
            node_name = node_vm.get("nodeName", "")
            # 单管仅产品过滤
            if is_single_scene.lower() == "yes" and node_name not in old_node_list:
                continue
            # 扩容场景仅产品修改资源表资源类型为string
            config_type = "string" if is_expansion and scene == "C02" else "spinner"
            if node_name.startswith("GW"):
                cpu_min = "2"
                mem_min = "4"

            if node_name in ["VCSA", "VIM_01", "VIM_02", "VRM_01", "VRM_02"] or \
                    (not node_to_blade.get(node_name, "") and
                             node_name not in
                             old_node_list):
                continue
            vm_define = node_vm.get("node_vm_define", {})
            node_name_opt = ""
            if node_name in opt_nodes:
                node_name_opt = node_name
            fmt_para = (prefix, num)
            controls_tmp = list()
            controls_tmp.append(ConfigControls.get_config("virtual_%s_vm_node_%d" % fmt_para,
                                                          node_name,
                                                          depends_node_name=node_name_opt))
            controls_tmp.append(ConfigControls.get_config("%s_vm_host_%d" % fmt_para,
                                                          node_name.replace("_", "-"),
                                                          depends_node_name=node_name_opt))
            if is_nfvi.lower() == "yes":
                default_value = self.kvs.get("%s_vm_datastore_%d" % fmt_para)
                if num % 2 == 1:
                    if not default_value:
                        default_value = "VolumeService01"
                    auto_fill_store = auto_fill_store1
                else:
                    if not default_value:
                        default_value = "VolumeService02"
                    auto_fill_store = auto_fill_store2

                if is_single_scene.lower() == "no" and anti_affinity_dict:
                    if anti_affinity_dict.get(node_name):
                        node_anti_affinity = anti_affinity_dict.get(node_name)
                    else:
                        node_anti_affinity = (node_name, "soft-anti-affinity")

                    controls_tmp.append(ConfigControls.get_config("%s_anti_affin"
                                                                  "ity_group_%d" % fmt_para,
                                                                  node_anti_affinity[0],
                                                                  editable="false",
                                                                  depends_node_name=node_name_opt))
                    controls_tmp.append(ConfigControls.get_config("%s_anti_affinity"
                                                                  "_strategy_%d" % fmt_para,
                                                                  node_anti_affinity[1],
                                                                  editable="false",
                                                                  depends_node_name=node_name_opt))
                else:
                    controls_tmp.append(ConfigControls.get_config("%s_anti_affinit"
                                                                  "y_group_%d" % fmt_para,
                                                                  "--",
                                                                  editable="false",
                                                                  depends_node_name=node_name_opt))
                    controls_tmp.append(ConfigControls.get_config("%s_anti_affinity_"
                                                                  "strategy_%d" % fmt_para, "--",
                                                                  editable="false",
                                                                  depends_node_name=node_name_opt))
                controls_tmp.append(
                    ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para, default_value,
                                              cfg_type="enum",
                                              editable="true",
                                              depends_node_name=node_name_opt,
                                              other=auto_fill_store))
            else:
                # 添加刀片槽位号,扩容仅产品不显示刀片槽位号
                if scene not in ["C02"] or not is_expansion:
                    blade_slot_ctrl = ConfigControls.get_config("%s_vm_blade_slot_%d" % fmt_para,
                                                                node_to_blade.get(node_name, ""),
                                                                cfg_type="enum",
                                                                editable=is_editable,
                                                                depends_node_name=node_name_opt)

                    if kvs.get("target_blade_switch", ""):
                        validation_from = "target_blade_switch"
                    elif (not kvs.get("target_blade_switch", "")) \
                            and kvs.get("source_blade_switch", ""):
                        validation_from = "source_blade_switch"
                    else:
                        validation_from = "blade_switch"
                    if is_editable == "false":
                        blade_slot_ctrl.update({"validation_ra"
                                                "nge": node_to_blade.get(node_name, "")})
                    else:
                        blade_slot_ctrl.update({"validation_from": validation_from,
                                                "exclude": exclude})
                    controls_tmp.append(blade_slot_ctrl)

                if scene not in ["C02"]:
                    old_datastore = kvs.get("%s_vm_datastore_%d" % fmt_para, "")
                    if scene != "C00" and old_datastore not in ["datastore", "LUN002_NCE"]:
                        controls_tmp.append(
                            ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para,
                                                      old_datastore, cfg_type="string",
                                                      editable=is_editable,
                                                      depends_node_name=node_name_opt))
                    elif scene in ['C00']:
                        if kvs.get("cpu_type") == "ARM" or kvs.get("server_type") in ["2288X_V5"]:
                            new_controls.append(
                                ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para,
                                                          "datastore",
                                                          cfg_type="string",
                                                          editable=is_editable,
                                                          other={"visible": False}))
                        else:
                            if enclosure_num and enclosure_num != "default" and int(
                                    enclosure_num) > 0 \
                                    and node_name.startswith("Analyzer_Calc_Storage"):
                                new_controls.append(
                                    ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para,
                                                              "LUN_Big_Data_01",
                                                              cfg_type="string",
                                                              editable=is_editable,
                                                              other={"visible": False}))
                            else:
                                new_controls.append(
                                    ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para,
                                                              "LUN002_NCE",
                                                              cfg_type="string",
                                                              editable=is_editable,
                                                              other={"visible": False}))
                    else:
                        controls_tmp.append(
                            ConfigControls.get_config("%s_vm_datastore_%d" % fmt_para, "",
                                                      cfg_type="string",
                                                      editable=is_editable,
                                                      depends_node_name=node_name_opt))

            controls_tmp.append(
                ConfigControls.get_config("%s_vm_numcpu_%d" % fmt_para, str(vm_define.get("CPU")),
                                          cfg_type=config_type,
                                          editable=is_editable,
                                          other={"min": cpu_min,
                                                 "max": 2 * int(vm_define.get("CPU"))},
                                          depends_node_name=node_name_opt))
            controls_tmp.append(
                ConfigControls.get_config("%s_vm_memory_%d" % fmt_para,
                                          str(vm_define.get("memory")),
                                          cfg_type=config_type,
                                          editable=is_editable,
                                          other={"min": mem_min,
                                                 "max": 2 * int(vm_define.get("memory"))},
                                          depends_node_name=node_name_opt))

            if node_name in fi_nodename_list and vm_define.get("storage") not in ["0", ""]:
                total_disk = int(vm_define.get("storage"))
                system_storage = storage_define.get("default").get("system_storage")
                storage_col_1 = 250
                for data_storage in storage_define.get("special_node").get("data_storage"):
                    if data_storage.get("total_storage") == total_disk:
                        storage_col_1 = data_storage.get("data_storage_1") + system_storage

                controls_tmp.append(
                    ConfigControls.get_config("%s_vm_harddisk_%d" % fmt_para,
                                              storage_col_1, cfg_type=config_type,
                                              editable=is_editable,
                                              other={"min": "150", "max": 2 * storage_col_1},
                                              depends_node_name=node_name_opt))
                new_controls.append(
                    ConfigControls.get_config("%s_vm_addDisk_size_%d" % fmt_para,
                                              str(int(vm_define.get("storage")) - storage_col_1),
                                              cfg_type=config_type,
                                              editable=is_editable,
                                              other={"min": "150", "visible": False,
                                                     "max": 2 * int(vm_define.get("storage"))},
                                              depends_node_name=node_name_opt))
            else:
                controls_tmp.append(
                    ConfigControls.get_config("%s_vm_harddisk_%d" % fmt_para,
                                              str(vm_define.get("storage")),
                                              cfg_type=config_type,
                                              editable=is_editable,
                                              other={"min": "150",
                                                     "max": 2 * int(vm_define.get("storage"))},
                                              depends_node_name=node_name_opt))

            if is_expansion:
                node_status = changed_node_status.get(node_name, "old")
                controls_tmp.append(ConfigControls.get_config("%s_vm_status_show_%d" % fmt_para,
                                                              node_status,
                                                              text_zh=taskmgr_lang_zh.
                                                              get(node_status, ""),
                                                              text_en=taskmgr_lang_en.
                                                              get(node_status, ""),
                                                              required="false"))
                new_controls.append(ConfigControls.get_config("%s_vm_status_%d" % fmt_para,
                                                              node_status,
                                                              other={"visible": "false"}))

                if scene == "C02" and node_name in old_node_list and kvs.get(
                        "expansion_sub_type") == "as_increment" and \
                        is_single_scene.lower() != "yes":
                    for control in controls_tmp:
                        control["visible"] = False
                elif node_status == "old":
                    AddIncreaseNodeDepends.add_depends_to_configs(controls_tmp)
                elif node_status == "resource_changed":
                    self.deal_changed_resource_nodes_configs(controls_tmp)
            new_controls.extend(controls_tmp)
            kvs.update({node_name: str(num)})
            node_idx = ConfigControls.get_config(node_name, str(num))
            node_idx.update({"visible": False})
            new_controls.append(node_idx)
            num += 1

    @staticmethod
    def deal_changed_resource_nodes_configs(config_set):
        """
        扩容场景下,批量为资源变化节点节点增加处理可编辑
        :param config_set: 待处理的config字典
        :return:
        """
        blade_slot_pattern = r"node_vm_blade_slot_(\d+)"
        vm_datastore_pattern = r"node_vm_datastore_(\d+)"
        for config in config_set:
            config_id = config.get("id", "")
            if re.match(blade_slot_pattern, config_id) or re.match(vm_datastore_pattern, config_id):
                config["editable"] = "false"

    def get_protect_blades(self):
        """
        获取保护刀片
        :param kvs:
        :return:
        """
        protect_blades = set()
        protect_blade_num = self.kvs.get('protect_blade_num', None)
        if protect_blade_num is None:
            blade_index = self.kvs.get('plat_vcsa_protect_blade', None)
            if str(blade_index).isdigit():
                protect_blades.add(blade_index)
        elif str(protect_blade_num).isdigit():
            for index in range(int(protect_blade_num)):
                blade_index = self.kvs.get('plat_vcsa_protect_blade_{0}'.format(index+1))
                if str(blade_index).isdigit():
                    protect_blades.add(blade_index)
        return protect_blades

    def get_vrm_node(self):
        """
        获取VRM实际部署节点
        :return:
        """
        mode = self.kvs.get('plat_vrm_install_mode', 'master_and_standby_mode')
        vrm_node = {}
        vrm_num = self.kvs.get('plat_vrm_master_server_num', '')
        if vrm_num:
            vrm_node['VRM_01'] = vrm_num

        if mode == 'master_and_standby_mode':
            vrm_num = self.kvs.get('plat_vrm_standby_server_num', '')
            if vrm_num:
                vrm_node['VRM_02'] = vrm_num

        return vrm_node

    def get_current_server(self):
        """
        获取当前可用的服务器编号
        :return:
        """
        current_server = [server_id for server_id in
                          self.kvs.get('blade_switch').split(',') if server_id]
        current_server_num = set(current_server)
        protect_blades = self.get_protect_blades()
        # 去除保护刀片
        current_server_num = current_server_num - protect_blades

        return current_server_num

    def node_to_server_process(self, node_to_server):
        """
        处理服务器刀片映射关系
        :param node_to_server:
        :return:
        """
        if not node_to_server or self.kvs.get('action') != 'install' or \
                self.kvs.get('server_type', '').lower() != 'e9000':
            return
        # 源服务器编号
        src_server_nums = set(node_to_server.values())
        # 获取当前可使用的服务器编号
        current_server_nums = self.get_current_server()

        # 当前VRM节点编号
        vrm_node = self.get_vrm_node()
        server_map = {}
        for vrm_name in vrm_node:
            src_num = node_to_server.get(vrm_name)
            if (not src_num) or (vrm_node[vrm_name] not in current_server_nums):
                continue
            server_map[src_num] = vrm_node[vrm_name]
            current_server_nums.remove(vrm_node[vrm_name])

        for num in src_server_nums:
            if not current_server_nums:
                break
            if num in server_map:
                continue
            if num not in current_server_nums:
                server_map[num] = current_server_nums.pop()
                continue
            server_map[num] = num
            current_server_nums.remove(num)

        for node_name in node_to_server:
            server_id = node_to_server[node_name]
            if server_id not in server_map:
                continue
            node_to_server[node_name] = server_map[server_id]

    def exe(self):
        """
        填充前台资源表表格入口
        :return:
        """

        # 填充前台资源表表格入口
        self.fulfill_vm_res()
