#!/bin/bash
# 替换json文件中的ip地址
cd /opt/expansion

#遍历入参键值对,进行逐一替换

for keyvalue in $*
do
    #以“=”拆分每一个参数
    OLD_IFS=$IFS
    IFS='='
    keyvalue_arry=($keyvalue)
    key=${keyvalue_arry[0]}
    value=${keyvalue_arry[1]}
    IFS=$OLD_IFS

    #替换模板json文件中的key为相应的value

    sed -i "s/\${$key}/$value/g" input.json > /dev/null 2>& 1
    sed -i "s/\${$key}/$value/g" nodes_NCE.json > /dev/null 2>& 1
    sed -i "s/\${$key}/$value/g" networkinfo_NCE.json > /dev/null 2>& 1
    sed -i "s/\${$key}/$value/g" networkinfo.json > /dev/null 2>& 1
    sed -i "s/\${$key}/$value/g" product_NCE.json > /dev/null 2>& 1
    sed -i "s/\${$key}/$value/g" networkinfo_OMP.json > /dev/null 2>& 1

done
# 适配可选节点，替换完成之后删除nodes_NCE.json中的空节点
cd /opt/expansion
bash remove_empty_node.sh /opt/expansion/nodes_NCE.json > /dev/null 2>& 1
bash remove_lvs_proxy.sh /opt/expansion/networkinfo_NCE.json > /dev/null 2>& 1
exit $?