#!/bin/bash

RPM_POST_FAILED_FLAG="RPM_POST_FAILED"
ROOT_DIR="$(dirname $(readlink -f $0))"
LOG_DIR="/var/log/pangea_internal_upgrade/mediaproto"
LOG_FILE="${LOG_DIR}/raid_rpm_log"
INSTALL_LOG="${LOG_DIR}/raid_install_log"

function raid_driver_upgrade()
{
    local raid_driver=$(cat "${ROOT_DIR}/version.xml" |grep -i "<RpmName>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}')
    if [ -z "${raid_driver}" ]; then
        echo "[$(date '+%Y-%m-%d %H:%M:%S')][RAID][Get raid driver name from version.xml failed.]" >> "${INSTALL_LOG}"
        sed -i "/Progress:/c Progress: -1" $2
        sed -i "/End time:/c End time: $(date '+%Y-%m-%d %H:%M:%S')" $2
        return 1
    fi

    rpm -qa | grep -w ${raid_driver} | xargs -i rpm -e {} &> /dev/null
    rpm -Uvh ${1} --oldpackage &> ${LOG_FILE}
    ret=$?
    cat ${LOG_FILE} | grep "${RPM_POST_FAILED_FLAG}" &> /dev/null
    if [[ $? != 0 && ${ret} == 0 ]];then
        sed -i "/Progress:/c Progress: 100" $2
        sed -i "/End time:/c End time: $(date '+%Y-%m-%d %H:%M:%S')" $2
        return 0
    else
        sed -i "/Progress:/c Progress: -1" $2
        sed -i "/End time:/c End time: $(date '+%Y-%m-%d %H:%M:%S')" $2
        return 1
    fi
}

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Start upgrade $1 " >> "${INSTALL_LOG}"
raid_driver_upgrade $1 $2
exit $?