#!/bin/bash
LOG_DIR="/var/log/pangea_internal_upgrade/mediaproto"
LOG_FILE="${LOG_DIR}/raid_fw_log"
TMP_FILE="${LOG_DIR}/raid_c${3}_tmp.txt"

function operate_log()
{
    echo "[$(date '+%Y-%m-%d %H:%M:%S')][RAID] $1" >> "${LOG_FILE}"
}

function raid_fw_upgrade()
{
    if [[ ${1} = "storcli" ]];
    then
        ${2} /c${3} download file=${4} nosigchk noverchk 1>${TMP_FILE} 2>&1
        result=$(cat ${TMP_FILE} | grep Status | awk '{print $3}')
    elif [[ ${1} = "arcconf" ]];
    then
        ${2} romupdate ${3} ${4} noprompt 1>${TMP_FILE} 2>&1
        result=$(cat ${TMP_FILE} | grep -w "Succeeded")
    elif [[ ${1} = "hiraid" ]];
    then
        result="failed"
        ${2} c${3} update fw file=${4} 1>${TMP_FILE} 2>&1
        ret=$(cat ${TMP_FILE} | grep "Status = Success" | wc -l)
        if [ ${ret} -gt 0 ];then
            ${2} c${3} active fw type=cold 1>${TMP_FILE} 2>&1
            ret=$(cat ${TMP_FILE} | grep "Status = Success" | wc -l)
            if [ ${ret} -gt 0 ];then
                result="Success"
            fi
        fi
    else
        result="failed"
    fi

    if [[ $result != "Success" && $result != "Succeeded" ]];then
        operate_log "Upgrade fw for c${3}(${4}) failed."
        cat ${TMP_FILE} >> ${LOG_FILE}
        rm -rf ${TMP_FILE} 2>/dev/null
        sed -i "/Progress:/c Progress: -1" $5
        sed -i "/End time:/c End time: `date '+%Y-%m-%d %H:%M:%S'`" $5
        return 1
    else
        operate_log "Upgrade fw for c${3}(${4}) success."
        rm -rf ${TMP_FILE} 2>/dev/null
        sed -i "/Progress:/c Progress: 100" $5
        sed -i "/End time:/c End time: `date '+%Y-%m-%d %H:%M:%S'`" $5
        return 0
    fi
}

operate_log "Start upgrade fw for c${3}(${4})."
raid_fw_upgrade $1 $2 $3 $4 $5
exit $?