#!/usr/bin/env bash

export G_ROOT_DIR="$(dirname $(readlink -f $0))"
export G_LOG_DIR="/var/log/pangea_internal_upgrade/mediaproto"
export G_OPERATE_LOG="$G_LOG_DIR/chip_operate_log"
export G_PROGRESS_RATE_FILE="$G_LOG_DIR/chip_progress"
export G_CHIP_NUM=0
export G_CHIP_UPDATE_CNT=0

STATUS_OK=0
STATUS_FAIL=1
STATUS_NO_PERMISSION=2
STATUS_NO_FILE=3
STATUS_NO_CHIP=4

if [ ! -d $G_LOG_DIR ]; then
    mkdir $G_LOG_DIR -p
    chmod 0750 $G_LOG_DIR -R
fi

G_CHIP_NUM=$(lspci -n|grep -E "1e81:37d8|19e5:37d8" |wc -l)

# 
function pangea_upgrade_progress()
{
    echo "$1" > $G_PROGRESS_RATE_FILE
}

# ¼־
function operate_log()
{
    if [ -f $G_OPERATE_LOG ]; then
        echo "[$(date '+%Y-%m-%d %H:%M:%S')][$1]" >> "$G_OPERATE_LOG"
    else
        echo "[$(date '+%Y-%m-%d %H:%M:%S')][$1]" > "$G_OPERATE_LOG"
    fi
}


# ȡǰ汾
function read_actual_version()
{
    local SAS_HOST_ID=${1}
    local curSesVer=""

    curChipVer=`cat /sys/class/scsi_host/host${SAS_HOST_ID}/fw_version |awk -F: '{print $2}'`
    if [ "${curChipVer}" == "" ]; then
        operate_log "Get version of SCSI HOST:${SAS_HOST_ID} is null"
    else
        operate_log "Get version of SCSI HOST:${SAS_HOST_ID} is ${curChipVer}"
    fi

    echo ${curChipVer}
    return
}


# ȡhost chip汾
function read_host_belongs()
{
    local SAS_HOST_ID=${1}
    local ret=0

    ret=`cat /sys/class/scsi_host/host${SAS_HOST_ID}/host_belongs |awk -F: '{print $1}'`
    if [ $ret == 1 ]; then
        return 0
    else
        return 1
    fi
}

# ȡǰ汾
function pangea_1880_getver()
{
    local SAS_HOST_ID=0
    #ȡscsiַŵļ
    lsscsi -H |grep "sal_layer" >sas_layer_info_read
    if [ 0 != $? ]; then
        echo "--"
        operate_log "There is no sas driver"
        exit $STATUS_NO_FILE
    fi

    dos2unix sas_layer_info_read 2>/dev/null 1>&2

    while read LINE
    do
        #ȡʵʵ豸
        SAS_HOST_ID=`echo $LINE | awk -F"[][]"  '{print $2}'`
        read_host_belongs $SAS_HOST_ID
        if [ 0 == $? ]; then
            operate_log "SCSI HOST:${SAS_HOST_ID} belongs current node"
            echo -n ${SAS_HOST_ID}": "
            read_actual_version $SAS_HOST_ID
        fi
    done < sas_layer_info_read
    rm -rf sas_layer_info_read > /dev/null
    return 0
}


# Ӳܷװ
function check_hw_envir()
{
    operate_log "Check environment hw start"

    if [ "$input" = "getver" ]; then
        local failed_str="NOT_MATCH"
    else
        local failed_str="failure"
    fi

    # ̫ƽ󡢱󡢶Ӳϰװ
    local support_products=(STL6SPCM STL6SPCO STL6SPCX STL6SPCY STL6SPCY55 STL6SPCY44 STL6SPCH01 STL6SPCH02)
    product_type=$(dmidecode -t 2 |grep "Product Name" -i | awk -F ': ' '{print $2}')
    for product in ${support_products[@]}
    do
        if [ "${product_type}" == "${product}" ];then
            if [ $G_CHIP_NUM -ne 0 ];then
                operate_log "Check product:$product_type pass, has 1880 chip:$G_CHIP_NUM!"
                return $STATUS_OK
            else
                echo "${failed_str}"
                operate_log "reason: Current product is $product_type 1880 chip num:$G_CHIP_NUM and not match gluon fw."
                exit $STATUS_NO_CHIP
            fi
        fi
    done

    echo "${failed_str}"
    operate_log "reason: Current product is $product_type not match gluon chip fw."
    exit $STATUS_NO_PERMISSION
}


# ѯ
function pangea_1880_quiry_progress()
{
    # ȱΪգٴγʼ
    if [ ! -f $G_PROGRESS_RATE_FILE ]; then
        echo "failure"
        return
    fi
    for((Int_Index=1; Int_Index<10; Int_Index++))
    do
        result=$(cat $G_PROGRESS_RATE_FILE)
        if [[ "$result" == "success" ]] || [[ "$result" == "failure" ]] || [[ "$result" == "upgrading"* ]]; then
            echo $result
            return 0
        fi
        operate_log "get chip upgrade process retry:$Int_Index"
        sleep 1
    done
    echo "failure"
}

function main()
{
    if [ "$input" = "upgrade" ]; then
        operate_log "perform 1880 chip fw upgrade"
        check_hw_envir
        pangea_upgrade_progress "upgrading 0"
        setsid sh $G_ROOT_DIR/upgrade.sh 1>/dev/null 2>&1 & #̨
        if [ $? -ne $STATUS_OK ]; then
            pangea_upgrade_progress "failure"
            echo "failure"
            echo "reason: Failed to invoke the upgrade.sh."
        else
            echo "success"
        fi
        return 0
    elif [ "$input" = "getver" ]; then
        operate_log "perform 1880 chip getversion"
        check_hw_envir
        pangea_1880_getver
        return 0
    elif [ "$input" = "getupgraderate" ]; then
        operate_log "perform 1880 chip fw getupgraderate"
        pangea_1880_quiry_progress
        return 0
    else
        echo "Unknown options"
        return 1
    fi
}

input=$1
main "$input"
exit $?
