#!/usr/bin/env bash
OS_VERSION=$(uname -r | cut -d - -f 1)
DRIVER_PATH="/usr/lib/modules/pangea_sas"
ARCH=`uname -i`

# Ʒű
# 1check_serial_upgrade : ǷҪ
# 2check_status : 洢״̬Ƿ
# ֵ:
# result=0 : ͨ
# result=1 : 鲻ͨ
# result=2 : 쳣, δ֪
UPGRADE_CHECK_SCRIPT="/opt/fusionstorage/persistence_layer/osd/script/tool/upgrade_check.sh"
CHECK_OK="result=0"
CHECK_FAILED="result=1"
CHECK_ERROR="result=2"

G_BELONGS_CHIP_NUM=0

STATUS_OK=0
STATUS_FAIL=1
STATUS_NO_PERMISSION=2
STATUS_NO_FILE=3

ACTIVE_BY_REBOOT="0"
ACTIVE_IMMEDIATELY="1"
CANCEL_ALL_CHIP_REBOOT_ACTIVE="2"

NEED_SERIAL_UPGRADE=0

# ¼־
function operate_log()
{
    if [ -f $G_OPERATE_LOG ]; then
        echo "[$(date '+%Y-%m-%d %H:%M:%S')][$1]" >> $G_OPERATE_LOG
    else
        echo "[$(date '+%Y-%m-%d %H:%M:%S')][$1]" > $G_OPERATE_LOG
    fi
}


# ȡhost chip汾
function read_host_belongs()
{
    local SAS_HOST_ID=${1}
    local ret=0

    ret=`cat /sys/class/scsi_host/host${SAS_HOST_ID}/host_belongs |awk -F: '{print $1}'`
    if [ $ret == 1 ]; then
        return 0
    else
        return 1
    fi
    return
}

# ȡǰ
function get_fw_update_result()
{
    local SAS_HOST_ID=${1}
    local ret=0
    ret=`cat /sys/class/scsi_host/host${SAS_HOST_ID}/fw_upgrade |awk '{print $1}'`
    if [ $ret == 2 ]; then
        pangea_upgrade_progress "upgrading 40"
        operate_log "SCSI HOST:${SAS_HOST_ID} update success!"
        return 0
    else
        operate_log "SCSI HOST:${SAS_HOST_ID} update result: $ret"
        return 1
    fi
}

# ǰFW
function update_fw_version()
{
    local SAS_HOST_ID=${1}
    for((try=1;try<4;try++))
    do
        #ͬӿ
        echo -n "$G_ROOT_DIR/packet_raid.img" >/sys/class/scsi_host/host${SAS_HOST_ID}/fw_upgrade
        #ȡ
        get_fw_update_result $SAS_HOST_ID
        if [ 0 == $? ]; then
            break
        fi
        operate_log "SCSI HOST:${SAS_HOST_ID} update retry $try!"
        sleep 3
    done
    return
}

# 
function collect_chip_process()
{
    local SAS_HOST_ID=${1}
    local ret=0
    ret=`cat /sys/class/scsi_host/host${SAS_HOST_ID}/fw_upgrade |awk '{print $1}'`
    if [ $ret == 2 ]; then
        ((G_CHIP_UPDATE_CNT++))
    fi
}

# ȡǰchip 
function collect_all_chip_process()
{
    #ȡɹ
    lsscsi -H |grep "sal_layer" >sas_layer_info_read
    if [ 0 != $? ]; then
        operate_log "There is no sas driver"
        pangea_upgrade_progress "failure"
        return 1
    fi
    dos2unix sas_layer_info_read 2>/dev/null 1>&2

    while read LINE
    do
        SAS_HOST_ID=`echo $LINE | awk -F"[][]"  '{print $2}'`
        read_host_belongs $SAS_HOST_ID
        if [ 0 == $? ]; then
            collect_chip_process $SAS_HOST_ID
        fi
    done < sas_layer_info_read

    if [ $G_CHIP_UPDATE_CNT == $G_BELONGS_CHIP_NUM ]; then
        operate_log "Current update chip success num:$G_CHIP_UPDATE_CNT match belongs chip, update success"
        pangea_upgrade_progress "upgrading 80"
        return 0
    else
        operate_log "Current update chip success num:$G_CHIP_UPDATE_CNT not match chip num:$G_BELONGS_CHIP_NUM"
        pangea_upgrade_progress "failure"
        return 1
    fi
}

# ȡǰ汾
function pangea_chip_upgrade()
{
    local SAS_HOST_ID=0
    #ȡscsiַŵļ
    lsscsi -H |grep "sal_layer" >sas_layer_info_read
    if [ 0 != $? ]; then
        pangea_upgrade_progress "failure"
        operate_log "There is no sas driver"
        exit $STATUS_NO_FILE
    fi
    dos2unix sas_layer_info_read 2>/dev/null 1>&2
    pangea_upgrade_progress "upgrading 1"

    #ȡҪchip
    while read LINE
    do
        SAS_HOST_ID=`echo $LINE | awk -F"[][]"  '{print $2}'`
        read_host_belongs $SAS_HOST_ID
        if [ 0 == $? ]; then
            ((G_BELONGS_CHIP_NUM++))
        fi
    done < sas_layer_info_read
    operate_log "Current node need to update chip num:$G_BELONGS_CHIP_NUM"

    #ִ
    while read LINE
    do
        {
            #ȡʵʵ豸
            SAS_HOST_ID=`echo $LINE | awk -F"[][]"  '{print $2}'`
            read_host_belongs $SAS_HOST_ID
            if [ 0 == $? ]; then
                operate_log "being to update scsi host:$SAS_HOST_ID fW"
                update_fw_version $SAS_HOST_ID
            fi
        } &
    done < sas_layer_info_read
    #ִɺ
    wait
    sleep 2
    operate_log "ending to update all scsi host fW"
    rm -rf sas_layer_info_read > /dev/null
    return 0
}

function wait_disk_pool_status_ok()
{
    # 洢ػָÿμ10s, 90(15)
    for((try=1;try<90;try++))
    do
        local check_result=$(/bin/bash ${UPGRADE_CHECK_SCRIPT} "check_status")
        if [ "${check_result}" == "${CHECK_OK}" ]; then
            operate_log "wait disk pool status OK!"
            return 0
        fi
        # űERROR˵δ֪, ϱʧ
        if [ "${check_result}" == "${CHECK_ERROR}" ]; then
            operate_log "Error happend in disk pool status."
            return 1
        fi
        sleep 10
    done
    operate_log "wait disk pool status timeout!"
    return 1
}

function do_active_fw()
{
    local SAS_HOST_ID=${1}
    local ACTIVE_TYPE=${2}
    operate_log "SCSI HOST:${SAS_HOST_ID} ready to active fw by type:${ACTIVE_TYPE}!"
    echo -n "${ACTIVE_TYPE}" >/sys/class/scsi_host/host${SAS_HOST_ID}/fw_active
}

# ǰFW
function active_fw()
{
    local SAS_HOST_ID=${1}
    if [ ${NEED_SERIAL_UPGRADE} == 0 ]; then
        # ҪΪλЧ
        do_active_fw ${SAS_HOST_ID} ${ACTIVE_BY_REBOOT}
        return 0
    fi

    # rebootЧ
    do_active_fw ${SAS_HOST_ID} ${CANCEL_ALL_CHIP_REBOOT_ACTIVE}

    #  ȴ洢ػָ -> ̼ -> ȴ -> ȴ洢ػָ -> һ̼
    wait_disk_pool_status_ok
    if [ $? != 0 ]; then
        return 1
    fi
    do_active_fw ${SAS_HOST_ID} ${ACTIVE_IMMEDIATELY}
    # ȴ̼Ч(оƬremove 10s, 洢ؼ⵽out 30s)
    sleep 40
    return 0
}

function get_need_serial_upgrade()
{
    # ûнűΪҪ
    if [ ! -f "${UPGRADE_CHECK_SCRIPT}" ]; then
        operate_log "Check script is not exist."
        NEED_SERIAL_UPGRADE=0
        return 0
    fi
    # ͨűжǷҪ
    local check_result=$(/bin/bash ${UPGRADE_CHECK_SCRIPT} "check_serial_upgrade")
    if [ "${check_result}" == "${CHECK_FAILED}" ]; then
        NEED_SERIAL_UPGRADE=0
        return 0
    fi
    if [ "${check_result}" == "${CHECK_OK}" ]; then
        operate_log "Check need serial upgrade."
        NEED_SERIAL_UPGRADE=1
        return 0
    fi
    # Ϊ, ʧ
    operate_log "Error happend in checking software status,result:${check_result}."
    return 1
}

function active_all_chip_fw()
{
    lsscsi -H |grep "sal_layer" > sas_layer_info_read
    if [ 0 != $? ]; then
        operate_log "There is no sas driver"
        pangea_upgrade_progress "failure"
        return
    fi
    dos2unix sas_layer_info_read 2>/dev/null 1>&2

    # жǷҪ
    get_need_serial_upgrade
    if [ $? != 0 ]; then
        pangea_upgrade_progress "failure"
        return
    fi

    while read LINE
    do
        SAS_HOST_ID=`echo $LINE | awk -F"[][]"  '{print $2}'`
        read_host_belongs ${SAS_HOST_ID}
        if [ $? == 0 ]; then
            active_fw ${SAS_HOST_ID}
            if [ $? != 0 ]; then
                pangea_upgrade_progress "failure"
                return
            fi
        fi
    done < sas_layer_info_read
    operate_log "Active all chip fw OK."
    pangea_upgrade_progress "success"
    return
}

# 
function pangea_upgrade_progress()
{
    echo "$1" > $G_PROGRESS_RATE_FILE
}

function main()
{
    operate_log "ready to upgrade chip fw..."
    pangea_chip_upgrade
    collect_all_chip_process
    if [ $? == 0 ]; then
        active_all_chip_fw
    fi
}

main
exit 0
