/**
 * Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
 * Description: vmdk errno code.
 * Create: 2024
 */
#ifndef VMDK_ERRNO_H
#define VMDK_ERRNO_H

#include "vmdk_mid.h"

#ifdef __cplusplus
extern "C" {
#endif

#define VMDK_MAKE_ERRNO(mid, n) ((mid) << 16 | (n))

/**
 * @ingroup vmdk
 * 0 Execution success.
 */
#define VMDK_ERR_SUCCESS        0

/**
 * @ingroup vmdk
 * -1 Failures caused by other exceptions.
 */
#define VMDK_ERR_FAILURE        (~0U)

/**
 * @ingroup vmdk
 * 0x10000001 Parameter error.
 */
#define VMDK_ERR_PARAMETER      VMDK_MAKE_ERRNO(VMDK_MID_BASE, 0x1)

#ifdef __cplusplus
}
#endif
#endif /* vmdk_errno.h */
