/**
 * Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
 * Description: vmdk pmem errno, common Linux error codes are supported, means 0~0xFF see@linux errno.h.
 * Create: 2024
 */
#ifndef VMDK_PMEM_ERRNO_H
#define VMDK_PMEM_ERRNO_H
#include "vmdk_errno.h"
#include "vmdk_mid.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @ingroup vmdk_pmem
 * 0x10010001 The parameter is invalid.
 */
#define VMDK_PMEM_ERR_PARAMETER      VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x1)

/**
 * @ingroup vmdk_pmem
 * 0x10010002 Pmem module is not initialized.
 */
#define VMDK_PMEM_ERR_NOT_INITIALIZED     VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x2)

/**
 * @ingroup vmdk_pmem
 * 0x10010003 No persistent memory space available.
 */
#define VMDK_PMEM_ERR_NO_PMEM_SPACE  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x3)

/**
 * @ingroup vmdk_pmem
 * 0x10010004 Memory operation error.
 */
#define VMDK_PMEM_ERR_EIO  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x4)

/**
 * @ingroup vmdk_pmem
 * 0x10010005 Persistent memory is already mmaped.
 */
#define VMDK_PMEM_ERR_MMAPED  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x5)

/**
 * @ingroup vmdk_pmem
 * 0x10010006 Invalid memory address.
 */
#define VMDK_PMEM_ERR_INVALID_ADDR  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x6)

/**
 * @ingroup vmdk_pmem
 * 0x10010007 Invalid socket id.
 */
#define VMDK_PMEM_ERR_INVALID_SOCKET_ID  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x7)

/**
 * @ingroup vmdk_pmem
 * 0x10010008 The OS does not support the FMA notification reporting capability.
 */
#define VMDK_PMEM_ERR_NOT_SUPPORT_FMA  VMDK_MAKE_ERRNO(VMDK_MID_PMEM, 0x8)

#ifdef __cplusplus
}
#endif
#endif /* vmdk_pmem_errno.h */
