#!/bin/bash

# **************************************************************************** #
# File Name: sas_chip_log.sh
# Description: save sas chip log from ddr to hdd
# Input: 1. source file
#        2. destination dir type
# Output: none
# Created: 2016/08/17
# **************************************************************************** #

CardID=$1
LogTimes=$2
G_SRC_DIR=$3
G_CHIP_TYPE=$4
G_DEST_LASTDIR1=/var/log/
G_DEST_LASTDIR2=sas_log
G_DEST_DIR=sas_chip_log
G_LOG_TOOL_DIR=/usr/lib/modules/pangea_sas/logtool

cd "${G_DEST_LASTDIR1}" >/dev/null 2>&1
if [ ! -d "${G_DEST_LASTDIR2}" ] ;then
   mkdir -p "${G_DEST_LASTDIR2}" >/dev/null 2>&1
fi

#/var/log/sas_logĿ¼ȨΪ750(rwxr-x---)
chmod 750 "${G_DEST_LASTDIR1}/${G_DEST_LASTDIR2}"

cd "${G_DEST_LASTDIR2}" >/dev/null 2>&1
if [ ! -d "${G_DEST_DIR}" ] ;then
   mkdir -p "${G_DEST_DIR}" >/dev/null 2>&1
fi

#sas_chip_logĿ¼ȨΪ750(rwxr-x---)
chmod 750 "${G_DEST_LASTDIR1}/${G_DEST_LASTDIR2}/${G_DEST_DIR}"

cd "${G_SRC_DIR}" >/dev/null 2>&1

if [[ "${G_CHIP_TYPE}" = "SAS2_0" && -f "${G_LOG_TOOL_DIR}" ]] ;then
    if [ ! -d "Card${CardID}_tmp" ] ;then
       mkdir -p "Card${CardID}_tmp" >/dev/null 2>&1
    fi
    chmod 750 "${G_SRC_DIR}/Card${CardID}_tmp"
    ${G_LOG_TOOL_DIR} show log path=./ out_file=Card${CardID}_tmp/out.log >/dev/null 2>&1
    mv Card${CardID}-${LogTimes}* Card${CardID}_tmp >/dev/null 2>&1
    cd "Card${CardID}_tmp" >/dev/null 2>&1
fi

G_LOG_LL_LOG_PKG="Card${CardID}-${LogTimes}.tgz"

#жļǷΪļ
pangea_checklinkfile()
{
    INPUT_FILE=$1
    if [ -L "${INPUT_FILE}" ]; then
        logger "[sas_chip_log.sh][ERROR] ${INPUT_FILE} is a link file."
        exit 1
    fi
}
pangea_checklinkfile "$G_LOG_LL_LOG_PKG"
pangea_checklinkfile "${G_DEST_LASTDIR1}/${G_DEST_LASTDIR2}/${G_DEST_DIR}/${G_LOG_LL_LOG_PKG}"

tar -zcf ${G_LOG_LL_LOG_PKG} Card${CardID}-${LogTimes}* >/dev/null 2>&1

mv "${G_LOG_LL_LOG_PKG}" "${G_DEST_LASTDIR1}/${G_DEST_LASTDIR2}/${G_DEST_DIR}"

rm -rf "${G_SRC_DIR}/Card${CardID}_tmp" > /dev/null 2>&1
rm -rf Card${CardID}-${LogTimes}* > /dev/null 2>&1

#sas_chip_logѹļȨΪ440(r--r-----)
chmod 440 "${G_DEST_LASTDIR1}/${G_DEST_LASTDIR2}/${G_DEST_DIR}"/*






