#!/bin/bash
readonly DPC_USER_CONF=/opt/oceanstor/dataturbo/conf/dpc_user_config.xml
readonly SCRIPT_LOG="/var/log/dataturbo/dataturbo_script/dataturbo.action.log"
readonly DPC_PROCESS=/opt/oceanstor/dataturbo/bin/dpc
FAIL_COUNT_ARRAY=(0 0 0 0 0 0)

function log_err()
{
    if [ -L ${SCRIPT_LOG} ]; then
        return;
    fi
    local func_name=${FUNCNAME[1]}
    if [ "$2" != "" ]; then
        func_name="$2"
    fi
    echo "[`date "+%Y-%m-%d %T"`:$$][ERR][monitor][${0##*/}][${func_name}]:" "$1" >> ${SCRIPT_LOG}
}

function monitor_process()
{
    local cgroup_mem_conf=$(cat "${DPC_USER_CONF}" | grep "DpcCgroupLimitMemory")
    cgroup_mem_conf=${cgroup_mem_conf#*>}
    cgroup_mem_conf=${cgroup_mem_conf%%<*}
    cgroup_mem_conf=$(echo ${cgroup_mem_conf} | awk -F  '.' '{print $1}')
    cgroup_mem_conf=$(expr "${cgroup_mem_conf}" \* 1024 \* 1024)

    while true
    do
    {
        sleep 5
        check_mem_usage ${cgroup_mem_conf}
    }
    done
}

function check_mem_usage()
{
    local dpc_pid=""
    dpc_pid=$(ps -ef | grep "$DPC_PROCESS" | grep -v grep | awk '{print $2}')
    if [ "${dpc_pid}" == "" ]; then
        log_err "get dpc pid failed."
        return 1
    fi

    local mem_usage=$(cat /proc/${dpc_pid}/status | awk '/VmRSS/{print $2}')
    local fail_count=0
    for (( i=0; i<${#FAIL_COUNT_ARRAY[@]} - 1;i++ ));  do
        FAIL_COUNT_ARRAY[$i]=${FAIL_COUNT_ARRAY[$(expr $i + 1)]}
        fail_count=$(expr ${fail_count} + ${FAIL_COUNT_ARRAY[$i]})
    done

    if [ "${mem_usage}" -ge "$1" ]; then
        FAIL_COUNT_ARRAY[5]=1
        fail_count=$(expr ${fail_count} + 1)
        log_err "Memory usage{${mem_usage} KB} is over expectations{$1 KB}, failed count{${fail_count}}."  
        if [ ${fail_count} -eq 3 ]; then
            log_err "The number of memory alloc failures reaches the upper limit{3}, the dpc process will be resarted."
            kill -9 "${dpc_pid}" 2 > /dev/null
            exit 1
        fi  
    else
        FAIL_COUNT_ARRAY[5]=0
    fi
}

monitor_process
