#!/bin/bash
################################################################################
#   1.  stop.sh 完成DPC模块的停止
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/common.sh

function stop_process_with_retry()
{
    local target_process=$1
    ps -ef | grep ${target_process} | grep -v grep  > /dev/null 2>&1
    if [ $? -ne 0 ]; then # 进程不存在
        return 0
    fi
    # When stop by kill -9 cmd failed, it will be retried 3 times
    for i in {0..3}
    do
        kill -9 `ps -ef | grep ${target_process} | grep -v grep | awk '{print $2}'`  > /dev/null 2>&1
        if [ $? -eq 0 ];then
            LOG "stop ${target_process} process succeed"
            return 0
        fi
        sleep 0.5
    done
    LOG_ERR "stop ${target_process} process failed!"
    return 1
}

function stop_remount_script()
{
    stop_process_with_retry "${CUR_DIR}/remount.sh"
    rm -rf ${CUR_DIR}/dataturbo_remount_*.lock > /dev/null 2>&1
}

function stop_sysinfo_monitor()
{
    stop_process_with_retry "${MONITOR_SCRIPT_RUN_PATH}"
    stop_process_with_retry "${XNET_MONITOR_SCRIPT_RUN_PATH}"
}

function stop_dpc_process()
{
    stop_process_with_retry "${DPC_PROCESS}"
    return $?
}


function main()
{
    stop_remount_script

    stop_sysinfo_monitor

    stop_dpc_process
    return $?
}
 
main
