#!/bin/bash
################################################################################
#   1.  check_status.sh 检查DPC状态
################################################################################

function check_dpc_status()
{
    RETRY_SLEEP_TIME=0.5
    DPC_PROC="/opt/oceanstor/dataturbo/bin/dpc"
    # When check dpc status by ps cmd failed, it will be retried 3 times
    for i in {0..3}
    do
        ps -ef | grep ${DPC_PROC} | grep -v grep 1>/dev/null
        if [ $? -eq 0 ];then  # dpc is running
            return 1
        fi
        sleep $RETRY_SLEEP_TIME
    done
    return 0
}
  
function main()
{
    check_dpc_status
    ret=$?
    if [ ${ret} -ne 0 ]; then
        echo "dpc process is running."
        return $ret
    fi

    echo "dpc process is not running;"
    return 0
}

main
exit $?

