#!/bin/bash
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
# Description: install handle script for dataturbo
# Author: daiwenxin
# Create: 2022/01/29
#
PROG_NAME=$0
# 接口名
ACTION=$1
# rpm安装阶段，pre和post
STAGE=$2
# 安装或者升级
STATUS=$3
# 用户组
CUSTOM_USER=$4
CUR_DIR=$(cd "$(dirname "$0")"; pwd)
ret=0
source $CUR_DIR/common.sh

function usage()
{
    echo "Usage: $PROG_NAME {start|install_dpc|install_dpc_rollback|uninstall_dpc|uninstall_dpc_rollback|check_status}"
}

function copy_service()
{
    # 先将服务配置文件拷贝到systemd中
    cp -f /opt/oceanstor/dataturbo/conf/dataturbo.service /usr/lib/systemd/system/dataturbo.service
    # 开机重启, 需要先enable
    systemctl enable dataturbo.service 2>/dev/null
}

#init log file
logInit

#check user
if [ "$UID" -ne "0" ]; then
    LOG_ERR "The script must run as root"
    exit 3
fi

#check usage
if [ $# -lt 1 ]; then
    usage
    exit 2
fi

#main start
START_TIME=`date +%s`
LOG "begin exec $ACTION, PARA(STAGE=$STAGE, STATUS=$STATUS, CUSTOM_USER=$CUSTOM_USER)."
case "${ACTION}" in
    "install_dpc")
        copy_service
        LOG "run runhook.sh ${ACTION}."
        # ${CUR_DIR}/runhook.sh $dir $STAGE $STATUS $CUSTOM_USER
        LOG "${CUR_DIR}/runhook.sh ${CUR_DIR}/${ACTION} $STAGE $STATUS $CUSTOM_USER"
        sh ${CUR_DIR}/runhook.sh ${CUR_DIR}/${ACTION} $STAGE $STATUS $CUSTOM_USER
        ret=$?
        if [ ${ret} == "0" ]; then
            LOG "Success to run ${ACTION} script, ${ACTION} Successful!"
        fi

        # 重新reload服务
        systemctl daemon-reload
        ;;
    "install_dpc_rollback")
        #安装dpc失败回滚
        sh ${CUR_DIR}/runhook.sh ${CUR_DIR}/${ACTION} $STAGE $STATUS $CUSTOM_USER
        ret=$?
        ;;
    "start")
        # 拉起服务
        systemctl daemon-reload && systemctl start dataturbo.service
        ret=$?
        if [ ${ret} == "0" ]; then
            LOG "Success to ${ACTION} dataturbo service, ${ACTION} Successful!"
        fi
        ;;
    "uninstall_dpc")
        #卸载
        sh ${CUR_DIR}/runhook.sh ${CUR_DIR}/${ACTION} $STAGE $STATUS $CUSTOM_USER
        ret=$?
        ;;
    "uninstall_dpc_rollback")
        #卸载dpc失败回滚
        sh ${CUR_DIR}/runhook.sh ${CUR_DIR}/${ACTION} $STAGE $STATUS $CUSTOM_USER
        ret=$?
        ;;
    "check_status")
        # 检查进程的状态
        ret=$?
        if [ ${ret} == "0" ]; then
            sh ${CUR_DIR}/${ACTION}.sh
            ret=$?
        else
            LOG "The process is running and cannot be uninstalled."
        fi
        ;;
    *)
        usage
        ret=1
        ;;
esac

END_TIME=`date +%s`
EXECUTING_TIME=`expr $END_TIME - $START_TIME`
LOG "end exec ${ACTION}, return ${ret}. exec time (${EXECUTING_TIME})"

if [ ${ret} -ne 0 ]; then
    LOG_ERR "Exec ${ACTION} failed!"
    exit 1
fi

exit 0
