#!/bin/bash
################################################################################
#   dataturbo rpm安装过程 hook脚本
#   需要有执行权限
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/../common.sh

stage=$1   # 脚本运行阶段(pre or post:)
status=$2  # upgrade or install
usrname=$3

STAGE_RPM_PRE="pre"
STAGE_RPM_POST="post"
STATUS_INSTALL=1
STAGE_UPGRADE=2
INSTALL_BASE_DIR=/opt/oceanstor/dataturbo

function check_avx512_env()
{
	cpu_count=$(cat /proc/cpuinfo |grep "processor" | wc -l)
	avx512f_count=$(cat /proc/cpuinfo |grep "avx512f" | wc -l)
	avx512dq_count=$(cat /proc/cpuinfo |grep "avx512dq" | wc -l)
	avx512cd_count=$(cat /proc/cpuinfo |grep "avx512cd" | wc -l)
	avx512bw_count=$(cat /proc/cpuinfo |grep "avx512bw" | wc -l)
	avx512vl_count=$(cat /proc/cpuinfo |grep "avx512vl" | wc -l)

	if [[ $cpu_count -eq $avx512f_count && $cpu_count -eq $avx512dq_count && $cpu_count -eq $avx512cd_count && $cpu_count -eq $avx512bw_count && $cpu_count -eq $avx512vl_count ]];then
	   return 1
	fi
	return 0
}

function adpater_avx512_vdpclient_lib()
{
    check_avx512_env
    if [ $? -eq 0 ]; then
        # 不支持avx512指令集,替换
        cp ${INSTALL_BASE_DIR}/lib/libvdp_client.so ${INSTALL_BASE_DIR}/lib/libvdp_client_v5.so
        cp ${INSTALL_BASE_DIR}/lib/libvdp_client_not_v5.so ${INSTALL_BASE_DIR}/lib/libvdp_client.so
        LOG "cpu is not V5"
    else
        # 支持avx512指令集,不做处理
        LOG "cpu is V5 or V5 above"
    fi
}

# 将占位符替换为uuid
function gen_cgw_config_uuid()
{
    uuid=$(uuidgen)
    LOG "INFO: gen cgw config uuid[$uuid]."
    sed -i "s/{{Uuid}}/$uuid/" /opt/oceanstor/dataturbo/conf/dpc_config.xml
}

function update_user_name_config()
{
    if [ ! ${usrname} ]; then 
        return
    fi
    USER_NAME_CONF_FILE=${INSTALL_BASE_DIR}/bin/dpc_username_config.ini
    echo "[user]" > ${USER_NAME_CONF_FILE}
    echo "username="${usrname} >> ${USER_NAME_CONF_FILE}
    groupname=$(id -gn ${usrname})
    echo "usergroup="${groupname} >> ${USER_NAME_CONF_FILE}
}


# 只有升级场景才会调到pre, 注意：此时新包还未安装，调用的接口均为老版本
function handle_install_pre()
{
    LOG "INFO: execute install_dpc.sh hook in ${status} stage..."
    return 0
}

function handle_install_post()
{
    # TP点 仅debug包使用
    if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
        script_tp_inject $0 $STAGE_RPM_POST  # 读取注入脚本的TP点
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi
    
    # 仅升级场景执行
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then
        LOG "INFO: execute install_dpc.sh hook in ${status} stage and upgrade status..."
        gen_cgw_config_uuid

        recover_config_file

        adpater_avx512_vdpclient_lib

        dataturbo_permission_manage
        return $?
    fi

    # 仅安装场景执行
    LOG "INFO: execute install_dpc.sh hook in ${status} stage and install status with username=${usrname}..."
    update_user_name_config

    adpater_avx512_vdpclient_lib

    dataturbo_permission_manage

    gen_cgw_config_uuid

    create_coredump_path

    return $?
}

function main()
{
    logInit
    LOG "S01install_dpc.sh: run with param [STAGE=${STAGE}, STATUS=${STATUS}, CUSTOM_USER=${usrname}]"
    if [ "${stage}" == "${STAGE_RPM_PRE}" ]; then
        handle_install_pre
    elif [ "${stage}" == "${STAGE_RPM_POST}" ]; then
        handle_install_post
    fi

    if [ $? -ne 0 ]; then
        LOG_ERR "execute install_dpc.sh hook faild."
        return 1
    fi
    LOG "INFO: execute install_dpc.sh hook succeed."
    return 0
}

main
exit $?

