#!/bin/bash
################################################################################
#   dataturbo rpm卸载过程 hook脚本
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/../common.sh
stage=$1   # 脚本运行阶段(pre or post:)
status=$2  # upgrade or install
usrname=$3

STAGE_RPM_PREUN="pre"
STAGE_RPM_POSTUN="post"
STATUS_INSTALL=0
STAGE_UPGRADE=1

function handle_uninstall_pre()
{
    # TP点 仅debug包使用
    if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
        script_tp_inject $0 $STAGE_RPM_PREUN  # 读取注入脚本的TP点
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then
        LOG "INFO: execute uninstall_dpc.sh hook in ${stage} stage and upgrade status..."
        return 0
    fi
    username=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini |grep username | sed -e "s/username=\([0-9A-Za-z]*\)/\1/g" | tr -d '\r') 
    setfacl -x ${username} /dev/shm
    rm -rf ${CONFIG_PATH}/dpc_alive
    change_dataturbo_file_to_root
    return 0
}

# 仅在升级场景会调到，该接口被调用时为新包中的接口
function handle_uninstall_post()
{
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then
        LOG "INFO: execute uninstall_dpc.sh hook in ${stage} stage and upgrade status..."
        # TP点 仅debug包使用
        if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
            script_tp_inject $0 $STAGE_RPM_POSTUN  # 读取注入脚本的TP点
            if [ $? -ne 0 ]; then
                return 1
            fi
        fi
    fi
    return 0
}

function main()
{
    if [ ${stage} == ${STAGE_RPM_PREUN} ]; then
        handle_uninstall_pre
    elif [ ${stage} == ${STAGE_RPM_POSTUN} ]; then
        handle_uninstall_post
    fi

    if [ $? -ne 0 ]; then
        LOG_ERR "execute uninstall_dpc.sh hook faild."
        return 1
    fi
    LOG "INFO: execute uninstall_dpc.sh hook succeed."
    return 0
}

main
exit $?
