#!/usr/bin/sh
set +x

PWD=`pwd`
source $PWD/util.sh
source $PWD/commfunc.sh

LOG_FILE_NAME=${OST_BASE}/log/ost_install.log
DataTurboVersionComaptible_Flag=0

DataTurboVersionList=("1.0.0")

function CreateInstallDIR() {
    [ ! -d ${OST_BASE}/conf ] && mkdir -p ${OST_BASE}/conf
    [ ! -d ${OST_BASE}/kmc ] && mkdir -p ${OST_BASE}/kmc
    [ ! -d ${OST_BASE}/log ] && mkdir -p ${OST_BASE}/log
    [ ! -d ${OST_BASE}/scripts ] && mkdir -p ${OST_BASE}/scripts
    [ ! -d ${OST_BASE}/temp ] && mkdir -p ${OST_BASE}/temp
    chmod 750 ${OST_BASE}/conf
    chmod 640 ${OST_BASE}/kmc
    chmod 640 ${OST_BASE}/log
    chmod 640 ${OST_BASE}/scripts
    chmod 640 ${OST_BASE}/temp
}

function InstallOstPlugin() {
    cp -rf ost.conf ${OST_BASE}/conf
    cp -rf ost_conf.xml ${OST_BASE}/conf
    cp -rf commfunc.sh ${OST_BASE}/scripts
    cp -rf util.sh ${OST_BASE}/scripts
    cp -rf config_filesystem.sh ${OST_BASE}/scripts
    cp -rf uninstall.sh ${OST_BASE}/scripts
    cp -rf libstspiOceanProtect*.so  /usr/openv/lib/ost-plugins/
    chmod 550 ${OST_BASE}/scripts/*.sh
    chmod 640 ${OST_BASE}/conf/*
}

function CheckDataTurboVersionIsCompatible() {
    for version in ${DataTurboVersionList[@]}; 
    do
        if [ $version == $DataTurboVersion ]; then
            DataTurboVersionComaptible_Flag=1
            Log "The installed dataturbo client is compatible with OST plugin. (version $DataTurboVersion)"
            break
        fi
    done
}

function InstallDataturbo() {
    if [ $DataturboInstalled_Flag -eq 1 ]; then
        echo "The System has installed the dataturbo Client."
        Log "The System has installed the dataturbo Client."
        CheckDataTurboVersionIsCompatible
        if [ $DataTurboVersionComaptible_Flag -eq 0 ]; then
            echo "The installed dataturbo client (version $DataTurboVersion) is not compatible with OST plugin."
            Log "The  installed dataturbo client (version $DataTurboVersion) is not compatible with OST plugin."
            exit
        fi        
    else
        if [ $OSTPackageContainDataturbo_Flag -eq 1 ]; then
            UnzipDataTurboPackage
            echo "Install dataturbo Client."
            sh ${DATATURBO_DIR}/install.sh -s dataturbo
            if [ $? -ne 0 ]; then
                echo "Install dataturbo client failed."
                Log "Install dataturbo client failed."
                exit
            fi
            touch ${OST_BASE}/conf/OST_placehodler.flag
        fi
    fi
}

function CheckAndInstallDataTurbo() {
    if [ $OS_TYPE != "SunOS" ]; then
        # Check whether the dataturbo client has been installed in the system
        CheckDataTurboInstalled

        # Check whether the OST plugin package contains the dataturbo client package
        CheckOSTPackageContainDataTurboPackage

        # Install dataturbo plugins
        InstallDataturbo
    fi
}

function PrintEND() {
    echo "Installation at end."
}

function PrintBegan() {
  echo "Begin installation."
}

echo "**********************************************"

PrintBegan
CheckKernel
CheckNBUSoftware
CheckOSTPlugin "install"
CreateInstallDIR
CheckAndInstallDataTurbo
TerminateNbrmms
InstallOstPlugin
StartNbrmms
PrintPluginInfo
PrintEND
