Name:           dataturbo
Version:        1.1.0.SPC10
Release:        202404121501
Summary:        dataturbo
License:        Share
Group:          huawei
Source0:        dataturbo
BuildROOT:      %{_topdir}/BUILDROOT
Prefix:         %{_prefix}

%define __os_install_post %{nil}
%define _prefix /opt/oceanstor/dataturbo
###################################### description ######################################
%description
This is dataturbo software.

%install
mkdir -p %{buildroot}/%{_prefix}
cp -aP %{_topdir}/SOURCES/* %{buildroot}/%{_prefix}

echo "install...$(pwd)..................."

%clean
# 制作rpm完成后需要执行哪些动作
echo "clean...$(pwd)....................."
rm -rf %{buildroot}

%files

%defattr(-,root,root)
%{_prefix}
%pre
# 安装前需要做的任务

DATATURBO_PATH=/opt/oceanstor/dataturbo
DATATURBO_SCRIPT=${DATATURBO_PATH}/script
HANDLE_FILE=${DATATURBO_SCRIPT}/dataturbo_rpm_handle.sh

DEFAULT_USER_NAME="dataturbo"
DEFAULT_GROUP_NAME="dataturbo"
CUSTOM_USER=${CUSTOM_USER=${DEFAULT_USER_NAME}}

STATUS_INSTALL="1"
STATUS_UPGRADE="2"

WHITELIST_CONTENT=( 
"CentOS7,3.10.0,x86_64" 
"SLES12SP4,4.12.14,x86_64"
"SLES12SP5,4.12.14,x86_64"
"OL7,4.14.35,x86_64"
)

function print_error()
{
    echo -e -n "\033[31m[ERROR]\033[0m [$(date +%Y%m%d%H%M%S)]"; echo "$1"
}

function print_warn()
{
    echo -e -n "\033[31m[WARNING]\033[0m [$(date +%Y%m%d%H%M%S)]"; echo "$1"
}

function print_debug()
{
    echo -e -n "\033[0;32;32m[DEBUG]\033[0m ";echo "$1"
}

#磁盘空间检查函数
function do_check_free_space()
{
    SPACE_STR=$(df -k "$1" | sed -n '$p')
    if [ "$SPACE_STR" = "" ]; then
        print_error "Check free space failed"
        exit 1
    fi

    FREE_SPACE=$(df -k "$1" | sed -n '$p' | awk '{print $(NF-2)}')
    if [ -z "$FREE_SPACE" ] || [ "$FREE_SPACE" -lt "$2" ]; then
        print_error "[$1] File Directory need more disk free space, need[$(expr $2 / 1024)M], The current disk space is [$(expr ${FREE_SPACE} / 1024)M]"
        exit 1
    fi
}

# 内存空间检查 5G 5*1024*1024 -->5242880
function do_check_mem_space()
{
    local spaceStr=""
    if [ -z "$1" ]; then
        print_error "param error[$1]"
        exit 1
    fi

    spaceStr=$(cat /proc/meminfo |awk '/MemAvailable/{print $2}')
    if [ "${spaceStr}" = "" ]; then
        print_error "get memory free space failed"
        exit 1
    fi
    # 当前内存值小于阀值
    if [ "${spaceStr}" -lt "$1" ]; then
        let freeSpaceMB=$(expr "$1" / 1024)
        print_error "more memory free space need["${freeSpaceMB}"MB],The current memory size is [$(expr "${spaceStr}" / 1024)MB]"
        exit 1
    fi
}

function get_os_type_online()
{
    local os_type=""
    if [ -f "/etc/oracle-release" ]; then
        if [ $(cat /etc/oracle-release | grep -c "Oracle Linux Server release 7") -ne 0 ]; then
            uVersion=$(cat /etc/oracle-release | awk -F "." '{print $2}')
	        if [ "${uVersion}" = "" ];then
                os_type="OL7U0"
            else
                os_type="OL7U${uVersion}"
            fi
        else
            echo "ERROR: This OS is not supported."
            exit 1
        fi
    elif [ -f "/etc/redhat-release" ]; then
        if [ $(grep -c -E "(Red Hat Enterprise Linux Server release 7|CentOS release 7|CentOS Linux release 7)" /etc/redhat-release) -ne 0 ]; then
            uVersion=$(cat /etc/redhat-release | awk -F "." '{print $2}' | awk -F " " '{print $1}')
            if [ "${uVersion}" = "" ]; then
                os_type="CentOS7U0"
            else
                os_type="CentOS7U${uVersion}"
            fi
        else
            echo "ERROR: This OS is not supported."
            exit 1
        fi
    elif [ -f "/etc/SuSE-release" ]; then
        local vernum=$(cat /etc/SuSE-release | sed -n 's/^[[:blank:]]*VERSION[[:blank:]]*=[[:blank:]]*\([0-9][0-9]*\)[[:blank:]]*$/\1/p')
        local versp=$(cat /etc/SuSE-release | sed -n 's/^[[:blank:]]*PATCHLEVEL[[:blank:]]*=[[:blank:]]*\([0-9][0-9]*\)[[:blank:]]*$/\1/p')
        local version="SLES${vernum}SP${versp}"
        if [ $(echo "${version}" | grep -c -E "SLES12SP4|SLES12SP5") -ne 0 ]; then
            os_type="${version}"
        else
            echo "ERROR: This OS is not supported. ${version}."
            exit 1
        fi
    fi
    echo "${os_type}"
}

function check_logcbb_dpc_file_link()
{
    if [ -L ${LOGCBB_DPC_PATH} ]; then
        print_warn "${LOGCBB_DPC_PATH} is a link file"
        return 1
    fi

    logcbb_dpc_file=$(ls ${LOGCBB_DPC_PATH})
    for file in ${logcbb_dpc_file}; do
        if [ -L ${LOGCBB_DPC_PATH}/${file} ]; then
            print_warn "${LOGCBB_DPC_PATH}/${file} is a link file"
            return 1
        fi
    done
}

function check_log_file_link()
{
    if [ -L ${DATATURBO_LOG_PATH} ]; then
        print_warn "${DATATURBO_LOG_PATH} is a link file"
        return 1
    fi

    log_path=$(ls ${DATATURBO_LOG_PATH})
    for file in ${log_path}; do
        if [ -L ${DATATURBO_LOG_PATH}/${file} ]; then
            print_warn "${DATATURBO_LOG_PATH}/${file} is a link file"
            return 1
        fi
    done

    if [ -L ${DATATURBO_LOG_PATH}/dataturbo_script/dataturbo.action.log ]; then
        print_warn "${DATATURBO_LOG_PATH}/dataturbo_script/dataturbo.action.log is a link file"
        return 1
    fi

    if [ -L ${DATATURBO_LOG_PATH}/dpc/run ]; then
        print_warn "${DATATURBO_LOG_PATH}/dpc/run is a link file"
        return 1
    fi

    if [ -L ${DATATURBO_LOG_PATH}/dpc/run/dsware_dpc_0.log ]; then
        print_warn "${DATATURBO_LOG_PATH}/dpc/run/dsware_dpc_0.log is a link file"
        return 1
    fi

    if [ -L ${DATATURBO_LOG_PATH}/dpc/bak ]; then
        print_warn "${DATATURBO_LOG_PATH}/dpc/bak is a link file"
        return 1
    fi

    log_path=$(ls ${DATATURBO_LOG_PATH}/dpc/bak)
    for file in ${log_path}; do
        if [ -L  ${DATATURBO_LOG_PATH}/dpc/bak/${file} ]; then
            print_warn ${DATATURBO_LOG_PATH}/dpc/bak/${file} is a link file"
            return 1
        fi
    done

    log_path=$(ls ${DATATURBO_LOG_PATH}/cli_log)
    for file in ${log_path}; do
        if [ -L  ${DATATURBO_LOG_PATH}/cli_log/${file} ]; then
            print_warn ${DATATURBO_LOG_PATH}/cli_log/${file} is a link file"
            return 1
        fi
    done

    return 0
}

function check_ftds_log_link()
{
    local link_file_num=0
 
    if [ -L ${FTDS_LOG_DIR} ]; then
        print_warn "${FTDS_LOG_DIR} is a link file"
        return 1
    fi
 
    link_file_num=$(find ${FTDS_LOG_DIR} -type l | wc -l)
    if [ ${link_file_num} -ne 0 ]; then
        print_warn "${FTDS_LOG_DIR} has ${link_file_num} link file, you can input [ find ${FTDS_LOG_DIR} -type l ] to show it."
        return 1
    fi
 
    return 0
}

function check_conf_file_link()
{
    if [ -L ${DATATURBO_PATH}/conf ]; then
        print_warn "${DATATURBO_PATH}/conf is a link file"
        return 1
    fi

    filelist=$(ls ${DATATURBO_PATH}/conf)
    for file in ${filelist}; do
        if [ -L ${DATATURBO_PATH}/conf/${file} ]; then
        print_warn "${DATATURBO_PATH}/conf/${file} is a link file"
        return 1
    fi
    done

    filelist=$(ls ${DATATURBO_PATH}/conf/config)
    for file in ${filelist}; do
        if [ -L ${DATATURBO_PATH}/conf/config/${file} ]; then
        print_warn "${DATATURBO_PATH}/conf/config/${file} is a link file"
        return 1
    fi
    done

    return 0
}

# 检查文件是否存在软连接
function check_file_link()
{
    if [ -d ${FTDS_LOG_DIR} ]; then
        check_ftds_log_link
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi

    if [ -d ${DATATURBO_LOG_PATH} ]; then
        check_log_file_link
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi

    if [ -d ${DATATURBO_PATH}/conf ]; then
        check_conf_file_link
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi

    if [ -d ${LOGCBB_DPC_PATH} ]; then
        check_logcbb_dpc_file_link
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi

    return 0
}

function check_kernel_version()
{
    local os_type=""
    local cur_os_type="$(get_os_type_online)"
    local kernel_version=""
    
    for str in "${WHITELIST_CONTENT[@]}"
    do
        os_type=$(echo "${str}" | awk -F "," '{print $1}')
        kernel_version=$(echo "${str}" | awk -F "," '{print $2}')
        arch_type=$(echo "${str}" | awk -F "," '{print $3}')
        if [ $(echo "${cur_os_type}" | grep -c "${os_type}") -eq 1 ] && \
           [ $(uname -r | grep -c "${kernel_version}") -eq 1 ] && \
           [ "${arch_type}" == "$(uname -p)" ]; then
            return 0
        fi
    done

    return 1
}

function check_cpu_constant_tsc()
{
    cpu_tsc=$(cat /proc/cpuinfo | grep -o constant_tsc)
    if [[ ${cpu_tsc} ]]; then
        return 0
    fi

    return 1
}

# 安装和升级前公共检查。
function install_check()
{
    check_kernel_version
    if [ $? -ne 0 ]; then
        echo "ERROR: This OS with kernel version{$(uname -r)} is not supported."
        exit 1
    fi

    # 磁盘空间检查函数 500M
    do_check_free_space /opt 512000
    if [ $? = "1" ]; then
        print_error "check free space failed."
        exit 1
    fi

    # 内存空间检查 2G 2*1024*1024 -->2097152
    do_check_mem_space 2097152
    if [ $? = "1" ]; then
        print_error "check mem space failed."
        exit 1
    fi

    check_cpu_constant_tsc
    if [ $? -ne 0 ]; then
        print_error "The cpu not support constant tsc."
        exit 1
    fi

    check_file_link
    if [ $? = "1" ]; then
        print_error "dataturbo log or config file has been changed to link file."
        exit 1
    fi
}

function exec_handle()
{
    local status="$1"  # 1-install, 2-upgrade
    local custom_user="$2"
    if [ ! -f "${HANDLE_FILE}" ]; then
        print_error "not found ${HANDLE_FILE}"
        return 1
    fi
    bash "${HANDLE_FILE}" "install_dpc" "pre" "$status" "$custom_user"
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "install_dpc_rollback" "pre" "$status" 1>/dev/null
        print_error "dataturbo pre install failed."
        return 1
    fi

    return 0
}

if [ "$1" = "${STATUS_UPGRADE}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        print_error "not found ${HANDLE_FILE}"
        exit 1
    fi

    exec_handle "${STATUS_UPGRADE}" "${CUSTOM_USER}"
    if [ "$?" = "1" ]; then
        print_error "ERROR: exec handle failed."
        exit 1
    fi
fi


%post
# 安装后需要做的任务
STATUS_INSTALL="1"
STATUS_UPGRADE="2"

# main
DATATURBO_PATH=/opt/oceanstor/dataturbo
DATATURBO_SCRIPT=${DATATURBO_PATH}/script
HANDLE_FILE=${DATATURBO_SCRIPT}/dataturbo_rpm_handle.sh
UPGRADE_RESULT=${DATATURBO_SCRIPT}/upgrade_res
RES_FAIL="1"
CUSTOM_USER=${CUSTOM_USER:="dataturbo"}

function add_upgrade_fail_flag()
{
    touch ${UPGRADE_RESULT}
    chmod 600 ${UPGRADE_RESULT}
    echo ${RES_FAIL} > ${UPGRADE_RESULT}
}

if [ "$1" = "${STATUS_INSTALL}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        echo "ERROR: not found ${HANDLE_FILE}"
        exit 1
    fi

    chmod 500 "${HANDLE_FILE}"
    bash "${HANDLE_FILE}" "install_dpc" "post" "${STATUS_INSTALL}" "${CUSTOM_USER}"
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "install_dpc_rollback" "post" "${STATUS_INSTALL}" 1>/dev/null
        echo "ERROR: install_dpc_rollback exec failed."
        exit 1
    fi

elif [ "$1" = "${STATUS_UPGRADE}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        echo "ERROR: not found ${HANDLE_FILE}"
        add_upgrade_fail_flag
        exit 1
    fi

    chmod 500 "${HANDLE_FILE}"
    bash "${HANDLE_FILE}" "install_dpc" "post" "${STATUS_UPGRADE}" 1>/dev/null
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "install_dpc_rollback" "post" "${STATUS_UPGRADE}" 1>/dev/null
        echo "ERROR: dataturbo upgrade failed in post stage."
        add_upgrade_fail_flag
        exit 1
    fi

else
    echo "ERROR: unsupport action."
fi

%preun

# 卸载前执行的脚本
PARAM_UNINSTALL="0"
PARAM_UPGRADE="1"

DATATURBO_PATH=/opt/oceanstor/dataturbo
DATATURBO_SCRIPT=${DATATURBO_PATH}/script
HANDLE_FILE=${DATATURBO_SCRIPT}/dataturbo_rpm_handle.sh
UPGRADE_RESULT=${DATATURBO_SCRIPT}/upgrade_res
RES_FAIL="1"

function add_upgrade_fail_flag()
{
    touch ${UPGRADE_RESULT}
    chmod 600 ${UPGRADE_RESULT}
    echo ${RES_FAIL} > ${UPGRADE_RESULT}
}

#main start
if [ "$1" -eq "${PARAM_UNINSTALL}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        echo "ERROR: not found ${HANDLE_FILE}"
        exit 1
    fi

    bash "${HANDLE_FILE}" "uninstall_dpc" "pre" ${PARAM_UNINSTALL} 2>/dev/null
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "uninstall_dpc_rollback" "pre" ${PARAM_UNINSTALL} 2>/dev/null
        echo "ERROR: uninstall dataturbo failed in preun stage."
        exit 1
    fi

elif [ "$1" = "${PARAM_UPGRADE}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        echo "ERROR: not found ${HANDLE_FILE}"
        add_upgrade_fail_flag
        exit 1
    fi

    chmod 500 "${HANDLE_FILE}"
    bash "${HANDLE_FILE}" "uninstall_dpc" "pre" ${PARAM_UPGRADE} 2>/dev/null
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "uninstall_dpc_rollback" "pre" ${PARAM_UPGRADE} 2>/dev/null
        echo "ERROR: upgrade dataturbo failed in preun stage."
        add_upgrade_fail_flag
        exit 1
    fi

else
    echo "ERROR: unsupport action[$1]."
    # not exit 1 avoid uninstall fail all the time
fi

%postun
# 卸载后执行的脚本
PARAM_INSTALL="0"
PARAM_UPGRADE="1"

readonly CGROUP_CPU_DIR=/sys/fs/cgroup/cpu/dataturbo
readonly CGROUP_MEM_DIR=/sys/fs/cgroup/memory/dataturbo
DATATURBO_PATH=/opt/oceanstor/dataturbo
DATATURBO_SCRIPT=${DATATURBO_PATH}/script
HANDLE_FILE=${DATATURBO_SCRIPT}/dataturbo_rpm_handle.sh
UPGRADE_RESULT=${DATATURBO_SCRIPT}/upgrade_res
RES_FAIL="1"

function add_upgrade_fail_flag()
{
    touch ${UPGRADE_RESULT}
    chmod 600 ${UPGRADE_RESULT}
    echo ${RES_FAIL} > ${UPGRADE_RESULT}
}

function rm_cgroup_dir()
{
    if [ -d "${CGROUP_CPU_DIR}" ]; then
        rmdir "${CGROUP_CPU_DIR}" >/dev/null 2>&1
    fi

    if [ -d "${CGROUP_MEM_DIR}" ]; then
        rmdir "${CGROUP_MEM_DIR}" >/dev/null 2>&1
    fi
}

if [ "$1" = "${PARAM_INSTALL}" ]; then
    systemctl disable dataturbo.service 2>/dev/null
    rm -f /usr/lib/systemd/system/dataturbo.service
    rm -rf /opt/oceanstor/dataturbo/
    rm -f /usr/bin/dataturbo
    rm -f /usr/bin/dataturbo_sysinfo_monitor.sh
    rm -f /usr/bin/dataturbo_xnet_sysinfo_monitor.sh
    rm -f /usr/bin/dataturbo_rescan
    rm -f /OSM/script/logcbb_file_ops.sh
    id dataturbo >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        userdel -r dataturbo 2>/dev/null
        groupdel dataturbo 2>/dev/null
    fi
    rm_cgroup_dir
    rm -rf /var/log/dr >/dev/null 2>&1
    echo "uninstall dataturbo successful."
elif [ "$1" = "${PARAM_UPGRADE}" ]; then
    if [ ! -f "${HANDLE_FILE}" ]; then
        echo "ERROR: not found ${HANDLE_FILE}"
        add_upgrade_fail_flag
    fi

    chmod 500 "${HANDLE_FILE}"
    bash "${HANDLE_FILE}" "uninstall_dpc" "post" ${PARAM_UPGRADE} 2>/dev/null
    if [ $? -ne 0 ]; then
        bash "${HANDLE_FILE}" "uninstall_dpc_rollback" "post" ${PARAM_UPGRADE} 2>/dev/null
        echo "ERROR: dataturbo upgrade failed in postun stage."
        add_upgrade_fail_flag
        exit 1
    fi
    echo "uninstall old package successful."
else
    echo "ERROR: unsupport action[$1]."
    # not exit 1 avoid uninstall fail all the time
fi
