#!/usr/bin/sh
set +x

PWD=`pwd`
source $PWD/util.sh
source $PWD/commfunc.sh
Dataturbo_PlaceFile=${OST_BASE}/conf/OST_placehodler.flag

LOG_FILE_NAME=${OST_BASE}/log/ost_upgrade.log

# backup config file
function backupConfigFile() {
    Log "Backup configuration files."
    if [ ! -d ${OST_BASE}/bak ]; then
        mkdir ${OST_BASE}/bak
    fi

    if [ -f "${OST_BASE}/conf/ost_conf.xml" ]; then
        Log "Backup configuration files ost_conf.xml ."
        cp ${OST_BASE}/conf/ost_conf.xml ${OST_BASE}/bak/ost.xml
    fi

    if [ -f "${OST_BASE}/conf/ost.conf" ]; then
        Log "Backup configuration files ost.conf ."
        cp -rf ${OST_BASE}/conf/ost.conf ${OST_BASE}/bak/ost.conf
        OST_CONF_FILE=${OST_BASE}/bak/ost.conf
        inportinternal=`cat ${OST_CONF_FILE} | grep "IMPORTINTERNAL"`
        if [[ -z $inportinternal ]]; then
            inputLine="IMPORTINTERNAL=120"
            echo $inputLine >> ${OST_CONF_FILE}
            cat ${OST_CONF_FILE} | sort | uniq > ${OST_CONF_FILE}.bak
            cat ${OST_CONF_FILE}.bak > ${OST_CONF_FILE}
        fi
    fi 

    if [ -f "${OST_BASE}/conf/file_mountIp.txt" ]; then
        Log "Backup configuration files file_mountIp.txt ."
        cp -rf ${OST_BASE}/conf/file_mountIp.txt ${OST_BASE}/bak/file_mountIp.txt
    fi

    if [ -f "${OST_BASE}/conf/storageIpList.txt" ]; then
        Log "Backup configuration files storageIpList.txt ."
        cp -rf ${OST_BASE}/conf/storageIpList.txt ${OST_BASE}/bak/storageIpList.txt
    fi

    if [ -f "${OST_BASE}/conf/OST_placehodler.flag" ]; then
        Log "Backup configuration files OST_placehodler.flag ."
        cp -rf ${OST_BASE}/conf/OST_placehodler.flag ${OST_BASE}/bak/OST_placehodler.flag
    fi

    cp -rf /usr/openv/lib/ost-plugins/libstspi${DISK_TYPE}*.so ${OST_BASE}/bak/
}

# update ost plugin so
function UpdateOSTPluginSo() {
    Log "Upgrade configuration file."
    cp -rf util.sh ${OST_BASE}/scripts
    cp -rf commfunc.sh ${OST_BASE}/scripts
    cp -rf config_filesystem_storage.sh ${OST_BASE}/scripts
    if [ -f "${OST_BASE}/scripts/config_filesystem.sh" ]; then
        rm -rf ${OST_BASE}/scripts/config_filesystem.sh
    fi
    cp -rf install.sh ${OST_BASE}/scripts
    cp -rf uninstall.sh ${OST_BASE}/scripts
    cp -rf libstspi${DISK_TYPE}*.so  /usr/openv/lib/ost-plugins/
    rm -rf ${OST_BASE}/scripts/config_filesystem.sh
}

# update or install dataTurbo
function updateDataTurboPlugin() {
    UnzipDataTurboPackage
    Log "Start Upgrade dataTurbo client."
    sh ${DATATURBO_DIR}/upgrade.sh
    if [ $? -ne 0 ]; then
        echo "Upgrade dataturbo client failed."
        Log "Upgrade dataturbo client failed."
    else
        echo "Upgrade dataturbo client success."
        Log "Upgrade dataturbo client success."
    fi
    systemctl start dataturbo
    if [ $? -ne 0 ]; then
        echo "Start dataturbo client failed."
        Log "Start dataturbo client failed."
    else
        echo "Start dataturbo client success."
        Log "Start dataturbo client success."
    fi
}

# umount IP
function UmountLinkIP() {
    configFile=$1
    while read line
    do
        cnt=0
        shareName=""
        for element in $(echo $line | tr " " "\n")
        do
            cnt=`expr $cnt + 1`
            if [ $cnt == 3 ]; then
                shareName=${element}
            fi
            if [ $cnt -ge 3 ]; then
                Logicip=${element}
                srcMountPoint=${Logicip}:/${shareName}/
                MountItem=`mount | grep ${srcMountPoint}`
                if [ ! -n $MountItem ]; then
                    Log "uMount $MountItem"
                    umount `echo $MountItem | $COMMON_AWK '{print $3}'` -lf
                    if [ $? -ne 0 ]; then
                        Log "umount $MountItem failed!"
                    fi
                fi
            fi
        done
    done < ${configFile}
}

# install dataturbo
function InstallDataTurbo() {
    UnzipDataTurboPackage
    # Install dataturbo client
    sh ${DATATURBO_DIR}/install.sh -s dataturbo
    if [ $? -ne 0 ]; then
        echo "Install dataturbo client failed."
        Log "Install dataturbo client failed."
    fi
}

function UpdateOSTPlugin() {
    backupConfigFile
    UpdateOSTPluginSo
    inputLine="${DISK_TYPE}"
    if [ $inputLine == "" ]; then
        echo "Disktype is null, install failed."
        exit
    fi
    echo $inputLine >> ${DISK_TYPE_FILE}
    cat ${DISK_TYPE_FILE} | sort | uniq > ${DISK_TYPE_FILE}.bak
    cat ${DISK_TYPE_FILE}.bak > ${DISK_TYPE_FILE}
    echo "Upgrade OST plugin successfully."
    Log "Upgrade OST plugin successfully."
}

function PreCheckUpgrade() {
    if [ $OS_TYPE != "SunOS" ]; then
        CheckDataTurboInstalled
        if [ $DataturboInstalled_Flag != 0 ] && [ $OSTPackageContainDataturbo_Flag == 0 ] && [ -f $Dataturbo_PlaceFile ]; then
             echo "The dataturbo exist with old OST, not allow to upgrade OST independently! exit upgrade!"
             Log "The dataturbo exist with old OST, not allow to upgrade OST independently! exit upgrade!"
             exit
        fi
    fi
}

function DoUpgrade() {
    echo "start upgrade."
    if [ $OS_TYPE != "SunOS" ]; then
        if [ $DataturboInstalled_Flag == 0 ]; then
            if [ $OSTPackageContainDataturbo_Flag == 1 ]; then
                InstallDataTurbo
            fi
            UpdateOSTPlugin
            touch $Dataturbo_PlaceFile
        else
            if [ $OSTPackageContainDataturbo_Flag == 0 ]; then
                UpdateOSTPlugin
            else
                updateDataTurboPlugin
                UpdateOSTPluginSo
                UmountLinkIP "${OST_BASE}/conf/file_mountIp.txt"
            fi
        fi
    else
        UpdateOSTPlugin
    fi
}

function PrintEND() {
    echo "Upgrade at end."
}

function PrintBegan() {
  echo "Begin upgrade."
}

echo "**********************************************"

PrintBegan
if [ $# -ne 2 ] || [ $1 != "-disktype" ]; then
    echo "**********************************************"
    echo "Upgrade Params invalid, upgrade params format:"
    echo " sh upgrade.sh -disktype OceanProtect "
    echo " disktype is OceanProtect or Other Type. "
    echo " Please restart to upgrade."
    echo "**********************************************"
    exit
fi
CheckDiskType $2
CheckKernel
CheckOSTPlugin "upgrade"
CheckOSTPackageContainDataTurboPackage
PreCheckUpgrade
TerminateNbrmms
DoUpgrade
StartNbrmms
PrintPluginInfo
PrintEND