#!/bin/bash
LOG_MAX_SIZE=1024*1024*5
LOG_MAX_NUM=100

LOG_FILE_PATH=/var/log/dataturbo/sysinfo
LOG_FILE_NAME=sys_info.log
LOG_FILE_PATH_RUN=${LOG_FILE_PATH}/run
LOG_FILE_PATH_BAK=${LOG_FILE_PATH}/bak
LOG_FILE=${LOG_FILE_PATH_RUN}/${LOG_FILE_NAME}

user_name=$1
group_name=$2
PERMISSION_LOG_DIR=700
PERMISSION_LOG_FILE=600
PERMISSION_LOG_bak=400

function LOG()
{
    prepare_run_dir
    if [ -L ${LOG_FILE} ]; then
        return;
    fi
    echo "$1" >> ${LOG_FILE}
}

function clear_log()
{
    prepare_run_dir
    if [ -L ${LOG_FILE} ]; then
        return;
    fi
    echo "" > ${LOG_FILE}
}

function prepare_run_dir()
{
    if [ ! -d "${LOG_FILE_PATH_RUN}" ]; then
        mkdir -p "${LOG_FILE_PATH_RUN}"
        chown -h ${user_name}:${group_name} ${LOG_FILE_PATH_RUN}
        chmod ${PERMISSION_LOG_DIR} ${LOG_FILE_PATH_RUN}
    fi
    if [ ! -f "${LOG_FILE}" ]; then
        touch ${LOG_FILE}
        chown -h ${user_name}:${group_name} ${LOG_FILE}
        chmod ${PERMISSION_LOG_FILE} ${LOG_FILE}
    fi
}

function prepare_bak_dir()
{
    if [ ! -d "${LOG_FILE_PATH_BAK}" ]; then
         mkdir -p "${LOG_FILE_PATH_BAK}"
         chown -h ${user_name}:${group_name} ${LOG_FILE_PATH_BAK}
         chmod ${PERMISSION_LOG_DIR} ${LOG_FILE_PATH_BAK}
    fi
}

function prepare_dir()
{
    prepare_run_dir
    prepare_bak_dir
}

function rotate_log()
{
    if [ ! -f "${LOG_FILE}" ]; then
        return 0
    fi
    curr_size=$(ls -l ${LOG_FILE} | awk '{print $5}')
    prepare_bak_dir
    if [[ ${curr_size} -ge ${LOG_MAX_SIZE} ]]; then
        date_str=$(date +%Y%m%d%H%M%S)
        cd ${LOG_FILE_PATH_BAK}
        cp -p ${LOG_FILE} ${LOG_FILE_NAME}${date_str}
        gzip ${LOG_FILE_NAME}${date_str}
        chown -h ${user_name}:${group_name} ${LOG_FILE_NAME}${date_str}.gz
        chmod ${PERMISSION_LOG_bak} ${LOG_FILE_NAME}${date_str}.gz
        clear_log
    fi
    log_file_num=$(ls -l ${LOG_FILE_PATH_BAK} | grep "${LOG_FILE_NAME}" | grep gz | grep -v grep | wc -l)
    while [ ${log_file_num} -gt ${LOG_MAX_NUM} ]
    do
        old_file=$(ls -lrt ${LOG_FILE_PATH_BAK} | grep "${LOG_FILE_NAME}" | grep gz | grep -v grep | head -1|awk -F' ' '{print $NF}')
        if [ X"" != X"$old_file" ]; then
            delete_file=${LOG_FILE_PATH_BAK}/${old_file}
            rm -rf ${delete_file}
        fi
        let "log_file_num--"
    done
    return 0
}

function get_bandwidth()
{
    temp=$(cat /proc/net/dev | grep -v "lo" | grep -Ev "Inter|bytes")
    TX_pre=$(echo "$temp" | sed 's/:/ /g' | awk '{print $10}')
    RX_pre=$(echo "$temp" | grep -v "lo" | grep -Ev "Inter|bytes" | sed 's/:/ /g' | awk '{print $2}')
    TX_drop_pre=$(echo "$temp" | grep -v "lo" | grep -Ev "Inter|bytes" | sed 's/:/ /g' | awk '{print $13}')
    RX_drop_pre=$(echo "$temp" | grep -v "lo" | grep -Ev "Inter|bytes" | sed 's/:/ /g' | awk '{print $5}')
    TX_pack_pre=$(echo "$temp" | grep -v "lo" | grep -Ev "Inter|bytes" | sed 's/:/ /g' | awk '{print $11}')
    RX_pack_pre=$(echo "$temp" | grep -v "lo" | grep -Ev "Inter|bytes" | sed 's/:/ /g' | awk '{print $3}')
    TX_pre=($TX_pre)
    RX_pre=($RX_pre)
    TX_drop_pre=($TX_drop_pre)
    RX_drop_pre=($RX_drop_pre)
    TX_pack_pre=($TX_pack_pre)
    RX_pack_pre=($RX_pack_pre)
    dev_num_pre=${#TX_pre[@]}

    sleep 1

    temp=$(cat /proc/net/dev | grep -v "lo" | grep -Ev "Inter|bytes")
    TX_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $10}')
    RX_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $2}')
    TX_drop_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $13}')
    RX_drop_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $5}')
    TX_pack_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $11}')
    RX_pack_next=$(echo "$temp" | sed 's/:/ /g' | awk '{print $3}')
    Names=$(echo "$temp" | sed 's/:/ /g' | awk '{print $1}')
    TX_next=($TX_next)
    RX_next=($RX_next)
    TX_drop_next=($TX_drop_next)
    RX_drop_next=($RX_drop_next)
    TX_pack_next=($TX_pack_next)
    RX_pack_next=($RX_pack_next)

    dev_num_next=${#TX_next[@]}
    if (($dev_num_next != $dev_num_pre)); then
        return
    fi

    LOG "$(date +%Y-%m-%d\ %H:%M:%S)"
    printf -v p_str "%-20s%-20s%-20s%-20s%-20s\n" "dev" "TX_BW(KB/s)" "RX_BW(KB/s)" "TX_Drop(%)" "RX_Drop(%)"
    LOG "$p_str"
    local i=0
    for name in ${Names}
    do
        RX=$((${RX_next[$i]}-${RX_pre[$i]}))
        RX=`echo | awk "{print $RX/1024}"`
        TX=$((${TX_next[$i]}-${TX_pre[$i]}))
        TX=`echo | awk "{print $TX/1024}"`
        TX_packs=$((${TX_pack_next[$i]}-${TX_pack_pre[$i]}))
        RX_packs=$((${RX_pack_next[$i]}-${RX_pack_pre[$i]}))
        TX_drops=$((${TX_drop_next[$i]}-${TX_drop_pre[$i]}))
        RX_drops=$((${RX_drop_next[$i]}-${RX_drop_pre[$i]}))
        if (($TX_packs == 0)); then
            TX_drop_ratio=0
        else
            TX_drop_ratio=`echo | awk "{print $TX_drops*100/$TX_packs}"`
        fi
        
        if (($RX_packs == 0)); then
            RX_drop_ratio=0
        else
            RX_drop_ratio=`echo | awk "{print $RX_drops*100/$RX_packs}"`
        fi
        printf -v p_str "%-20s%-20.2f%-20.2f%-20.2f%-20.2f\n" $name $TX $RX $TX_drop_ratio $RX_drop_ratio
        LOG "$p_str"
        i=$[i+1]
    done
}

function monitor_process()
{
    while true
    do
    {
        get_bandwidth
        LOG "$(top -b -c -n 1 | head -n 20)"
        printf -v p_str "\n"
        LOG "$p_str"
        sleep 5
        rotate_log
    }
    done
}

prepare_dir
monitor_process
