#!/bin/bash

# ********************************************** ***************************** #
# File Name: logcbb_file_op.sh 
# Description: logcbbļ
# Input: 
# Output: 
# Author: 
# Created:
# Function List: backupdirlimitcleardir
# History 
# 1.Date: 2016/12/17
#   Author:
#   Modification: 
# **************************************************************************** #

# ű

# --------------------------  variables  ------------------------------------- #
# 
G_SRC_FILE=""
G_SRC_FILE_PATH=""
G_SRC_FILE_NAME=""
G_DST_FILE=""
G_DST_FILE_PATH=""
G_LIMIT=100
G_LIMIT_CNT=512
G_PATTERN=""

G_LINE_NUM=0

function chmod_safe()
{
    local recursion="no"
    if [ "$1" == "-R" ]; then
        recursion="yes"
        shift
    fi
    
    file_mode=$1
    shift
    
    for origin_list in $@
    do
        if [ "${recursion}" == "yes" ]; then
            for clean_list in `find ${origin_list} -not -type l`
            do
                chmod ${file_mode} ${clean_list} 1>/dev/null 2>&1
            done
        else
            if [ ! -L "${origin_list}" ]; then
                chmod ${file_mode} ${origin_list} 1>/dev/null 2>&1
            else
                dcm_log "${file_mode} is a symbolic link."
            fi
        fi
    done
}

# --------------------------  clear file descriptor  ------------------------- #
# 
# ļִкܳʱ䣬˴ר̳еļͶԵߵӰ
#
G_CUR_FILE_NAME=`basename $0`
G_CUR_FILE_FD=`ls -l /proc/$$/fd|grep "${G_CUR_FILE_NAME}"|awk '{print $9}'|head -1`
G_FLOCK_FD=9
[ ${G_CUR_FILE_FD} -eq 9 ] && G_FLOCK_FD=8

for fd in `ls /proc/$$/fd`
do
    [ ${fd} -eq ${G_CUR_FILE_FD} ] && continue

    case "$fd" in
        0|1|2)
        ;;
    *)
        eval "exec $fd<&-"
        ;;
    esac
done

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: logcbb_print
# Description: ʽӡϢĻshow
# Parameter: FORMAT [ARGUMENT] ...
# Return: 
# **************************************************************************** #
logcbb_print()
{
    G_LINE_NUM=`expr ${G_LINE_NUM} + 1`
    output=$(printf "%3s" "${G_LINE_NUM}")
    output=${output}$(printf " $@")
    echo "${output}"
}

# **************************************************************************** #
# Function Name: logcbb_log
# Description: ӡ־ָļĬ/OSM/log/cur_debug/messages
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_log()
{
    echo "logcbb: $@" >/dev/kmsg
}

# **************************************************************************** #
# Function Name: logcbb_flock
# Description:
# Parameter: file/dir
# Return: ɹ0򷵻ط0
# **************************************************************************** #
logcbb_flock()
{
    lockFile=$1
    if [ "" == "${lockFile}" ]; then
        logcbb_log "logcbb_flock lockFile is null"
        return 1
    fi

    eval "exec ${G_FLOCK_FD}<${lockFile}"
    ret=$?
    if [ 0 -ne ${ret} ]; then
        logcbb_log "logcbb_flock exec ${G_FLOCK_FD}<${lockFile} fail ${ret}"
        return 2
    fi
        
    flock -x -n "${G_FLOCK_FD}"
    [ 0 -ne $? ] && return 3

    return 0
}
logcbb_flockw()
{
    lockFile=$1
    if [ "" == "${lockFile}" ]; then
        logcbb_log "logcbb_flock lockFile is null"
        return 1
    fi

    eval "exec ${G_FLOCK_FD}<${lockFile}"
    ret=$?
    if [ 0 -ne ${ret} ]; then
        logcbb_log "logcbb_flock exec ${G_FLOCK_FD}>${lockFile} fail ${ret}"
        return 2
    fi
        
    flock -x ${G_FLOCK_FD}
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_funlock
# Description:
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_funlock()
{
    flock -u "${G_FLOCK_FD}"
    eval "exec ${G_FLOCK_FD}<&-"
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_backup
# Description: ѹתԴļĿ·
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_backup()
{
    if [ "" == "${G_SRC_FILE}" ];then
        logcbb_log "G_SRC_FILE is NULL"
        return 0
    fi

    if [ ! -e "${G_SRC_FILE}" ];then
        logcbb_log "${G_SRC_FILE} is not exsit"
        return 0
    fi

    if [ "" == "${G_DST_FILE_PATH}" ];then
        G_DST_FILE_PATH="${G_SRC_FILE_PATH}"
        logcbb_log "G_DST_FILE_PATH is NULL, use ${G_SRC_FILE_PATH}"
    fi

    if [ ! -e "${G_DST_FILE_PATH}" ];then
        oldmask=`umask`
        umask 0027
        mkdir -p "${G_DST_FILE_PATH}" >/dev/null 2>&1
        umask ${oldmask}
    fi

    cd ${G_SRC_FILE_PATH} >/dev/null
        if [ -L ${G_DST_FILE_PATH}/${G_SRC_FILE_NAME}.tgz ]; then
            rm -rf ${G_DST_FILE_PATH}/${G_SRC_FILE_NAME}.tgz
        fi

        oldmask='umask'
        umask 0027
        tar -czf "${G_DST_FILE_PATH}/${G_SRC_FILE_NAME}.tgz" "${G_SRC_FILE_NAME}"
        fsync "${G_DST_FILE_PATH}/${G_SRC_FILE_NAME}.tgz"
        umask ${oldmask}

        chmod_safe 440 "${G_DST_FILE_PATH}/${G_SRC_FILE_NAME}.tgz"
        rm -f ${G_SRC_FILE}        
    cd - >/dev/null 2>&1

    return 0
}

# **************************************************************************** #
# Function Name: logcbb_dirlimit
# Description: Ŀ¼С
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_dirlimit()
{
    if [ "" == "${G_DST_FILE_PATH}" ];then
        logcbb_log "G_DST_FILE_PATH is NULL"
        return 0
    fi

    if [ ! -e "${G_DST_FILE_PATH}" ];then
        logcbb_log "${G_DST_FILE_PATH} is not exsit"
        return 0
    fi

    ((dirSizeLimit = G_LIMIT * 1024))
    if [ ${dirSizeLimit} -le 0 ];then
        logcbb_log "dirSizeLimit ${dirSizeLimit} is <= 0"
        return 1
    fi

    cd "${G_DST_FILE_PATH}" >/dev/null
    DIR_SIZE=`du -k --max-depth=0|head -1|tr -cd 0-9`

    logcbb_flock "${G_DST_FILE_PATH}"
    if [ 0 -ne $? ];then
        if [ "${DIR_SIZE}" -lt "${dirSizeLimit}" ];then
            cd - &>/dev/null
            return 0
        fi

        logcbb_log "dir size has reached ${DIR_SIZE}, waiting for rm done"
        logcbb_flockw "${G_DST_FILE_PATH}"
        DIR_SIZE=`du -k --max-depth=0|head -1|tr -cd 0-9`
        logcbb_log "wait for rm done, cur dir size is ${DIR_SIZE}"        
    fi

    ((dirSizeLimit=dirSizeLimit*9/10))
    if [ "${DIR_SIZE}" -gt "${dirSizeLimit}" ];then
        local rmCnt=1
        
        if [ ${G_LIMIT} -ge 10240 ];then
            rmCnt=100
        elif [ ${G_LIMIT} -ge 1024 ];then
            ((rmCnt=10*G_LIMIT/1024))
        elif [ ${G_LIMIT} -ge 100 ];then
            ((rmCnt=1*G_LIMIT/100))
        else
            rmCnt=1
        fi
        
        local tmpCnt=${rmCnt}
        ls .|sort -n|grep "^\w"|while read line
        do
            rm -rf ${line}
            ((rmCnt--))
            [ ${rmCnt} -gt 0 ] && continue

            rmCnt=${tmpCnt}
            DIR_SIZE=`du -k --max-depth=0|head -1|tr -cd 0-9`
            if [ "${DIR_SIZE}" -le "${dirSizeLimit}" ];then
                break
            fi
        done
    fi        
    logcbb_funlock
    
    cd - &>/dev/null    
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_backuplimit
# Description: Ŀ¼Сıݲ
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_backuplimit()
{
    logcbb_backup
    if [ 0 -ne $? ];then
        logcbb_log "logcbb backup fail ret $?"
        return $?
    fi
    
    logcbb_dirlimit
    if [ 0 -ne $? ];then
        logcbb_log "logcbb dirlimit fail ret $?"
        return $?
    fi
    
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_cntlimit
# Description: Ŀ¼ļ
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_cntlimit()
{
    if [ "" == "${G_DST_FILE_PATH}" ];then
        logcbb_log "G_DST_FILE_PATH is NULL"
        return 0
    fi

    if [ ! -e "${G_DST_FILE_PATH}" ];then
        logcbb_log "${G_DST_FILE_PATH} is not exsit"
        return 0
    fi

    if [ ${G_LIMIT_CNT} -le 0 ];then
        logcbb_log "dirFileCntLimit ${G_LIMIT_CNT} is <= 0"
        return 1
    fi

    logcbb_flock "${G_DST_FILE_PATH}"
    [ 0 -ne $? ] && return 0
    
    cd "${G_DST_FILE_PATH}" >/dev/null
    file_cnt=`ls | grep ${G_PATTERN} | wc -l`
    if [ "${file_cnt}" -gt "${G_LIMIT_CNT}" ];then
        local rmCnt
        
        ((rmCnt=file_cnt-G_LIMIT_CNT))
        if [ ${G_LIMIT_CNT} -ge 10000 ];then
            ((rmCnt+=200))
        elif [ ${G_LIMIT_CNT} -ge 1000 ];then
            ((rmCnt+=100))
        elif [ ${G_LIMIT_CNT} -ge 100 ];then
            ((rmCnt+=10))
        fi
            
        ls .|grep ${G_PATTERN}|sort -n|grep "^\w"|while read line
        do
            rm -f ${line}
            ((rmCnt--))
            [ 0 -eq ${rmCnt} ] && break
        done
    fi        
    cd - &>/dev/null

    logcbb_funlock
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_backupcntlimit
# Description: ļıݲ
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_backupcntlimit()
{
    logcbb_backup
    if [ 0 -ne $? ];then
        logcbb_log "logcbb backup fail ret $?"
        return $?
    fi
    
    logcbb_cntlimit
    if [ 0 -ne $? ];then
        logcbb_log "logcbb cntlimit fail ret $?"
        return $?
    fi
    
    return 0
}
    
# **************************************************************************** #
# Function Name: logcbb_cleardir
# Description: 
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_cleardir()
{
    CLEAR_CMD="rm -f"
    
    if [ "" == "${G_SRC_FILE_PATH}" ];then
        logcbb_log "G_SRC_FILE_PATH is NULL"
        return 0
    fi

    if [ ! -e "${G_SRC_FILE_PATH}" ];then
        logcbb_log "${G_SRC_FILE_PATH} is not exsit"
        return 0
    fi

    if [ "" != "${G_DST_FILE_PATH}" ];then
        CLEAR_CMD="mv"    
        if [ ! -e "${G_DST_FILE_PATH}" ];then
            oldmask=`umask`
            umask 0027            
            mkdir -p "${G_DST_FILE_PATH}" >/dev/null 2>&1
            umask ${oldmask}
        fi    
    fi

    `${CLEAR_CMD} ${G_SRC_FILE} ${G_DST_FILE_PATH}` >/dev/null 2>&1
    
    return 0
}

# **************************************************************************** #
# Function Name: logcbb_fsckmountdisk
# Description: ״̬޸ɹز
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_fsckmountdisk()
{
    fsck -t ext3 -a "${G_SRC_FILE_PATH}"
    ret=$?
    if [ 0 -ne ${ret} ];then
        logcbb_log "fscking ${G_SRC_FILE_PATH} fail, ret:${ret}, exec mkfs.ext3"
        mkfs.ext3 "${G_SRC_FILE_PATH}"
    fi
    
    mount -o noatime,nodiratime "${G_SRC_FILE_PATH}" "${G_DST_FILE_PATH}" 
    ret=$?
    if [ 0 -ne ${ret} ];then
        logcbb_log "mount ${G_SRC_FILE_PATH} ${G_DST_FILE_PATH} fail, ret:${ret}, exec mkfs.ext3 and retry"
        mkfs.ext3 "${G_SRC_FILE_PATH}"
        mount -o noatime,nodiratime "${G_SRC_FILE_PATH}" "${G_DST_FILE_PATH}"
        ret=$?
    fi

    if [ 0 -ne ${ret} ];then
        return 1
    fi
    
    return 0;
}
   
# **************************************************************************** #
# Function Name: logcbb_mount
# Description: ش̵ָĿ¼
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_mount()
{
    if [ "" == "${G_SRC_FILE_PATH}" ];then
        logcbb_log "G_SRC_FILE_PATH is NULL"
        return 1
    fi

    if [ ! -e "${G_SRC_FILE_PATH}" ];then
        logcbb_log "${G_SRC_FILE_PATH} is not exsit"
        return 2
    fi

    if [ "" == "${G_DST_FILE_PATH}" ];then
        logcbb_log "G_DST_FILE_PATH is NULL"
        return 3
    fi

    if [ ! -e "${G_DST_FILE_PATH}" ];then
        oldmask=`umask`
        umask 0027        
        mkdir -p "${G_DST_FILE_PATH}"
        umask ${oldmask}        
    fi
    
    logcbb_fsckmountdisk
    ret=$?
    if [ 0 -ne ${ret} ];then
        return 4
    fi

    chmod_safe 750 "${G_DST_FILE_PATH}"
    logcbb_log "mount ${G_SRC_FILE_PATH} ${G_DST_FILE_PATH} sucess"
    while read line
    do
        logcbb_log "${line}"
    done << EOF
`mount`
EOF

    return 0
}


# **************************************************************************** #
# Function Name: logcbb_checkdisk
# Description: ramdisk״̬쳣޸
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_checkdisk()
{
    if [ "" == "${G_SRC_FILE_PATH}" ];then
        logcbb_log "G_SRC_FILE_PATH is NULL"
        return 1
    fi

    if [ ! -e "${G_SRC_FILE_PATH}" ];then
        logcbb_log "${G_SRC_FILE_PATH} is not exsit"
        return 2
    fi

    if [ "" == "${G_DST_FILE_PATH}" ];then
        logcbb_log "$G_DST_FILE_PATH is NULL"
        return 3
    fi

    if [ ! -e "${G_DST_FILE_PATH}" ];then
        logcbb_log "${G_DST_FILE_PATH} is not exsit"
        return 4       
    fi
    
    fsck -n "${G_SRC_FILE_PATH}"
    ret=$?
    logcbb_log "logcbb_checkdisk, fsck -n "${G_SRC_FILE_PATH}", ret:${ret}"
    if [ 0 -ne ${ret} ];then
        umount -l -f "${G_DST_FILE_PATH}"
        logcbb_log "${G_SRC_FILE_PATH} is invalid,ret:${ret}"
        logcbb_fsckmountdisk
        ret=$?
        if [ 0 -ne ${ret} ];then
            return 5
        fi
    fi

    return 0;
}


# **************************************************************************** #
# Function Name: logcbb_umount
# Description: ش̵ָĿ¼
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_umount()
{
    if [ "" == "${G_SRC_FILE_PATH}" ];then
        logcbb_log "G_SRC_FILE_PATH is NULL"
        return 0
    fi

    if [ ! -e "${G_SRC_FILE_PATH}" ];then
        logcbb_log "${G_SRC_FILE_PATH} is not exsit"
        return 0
    fi

    umount "${G_SRC_FILE_PATH}"
    
    return $?
}

# **************************************************************************** #
# Function Name: logcbb_isvailddisk
# Description: жϴǷ
# Parameter: 
# Return: 0ʾ̿ã򲻿
# **************************************************************************** #
logcbb_isvailddisk()
{
    disk="${1%/}"

    if [ "" == "${disk}" ];then
        return 1
    fi

    if [ ! -e "${disk}" ];then
        return 2        
    fi

    #${disk}Ŀոʡ
    if [ "" == "`mount|grep \"${disk} \"`" ];then
        return 3
    fi 

    return 0
}

# **************************************************************************** #
# Function Name: logcbb_setdisk
# Description: dstĿ¼ʹ·src
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_setdisk()
{
    if [ "" == "${G_DST_FILE_PATH%/}" ];then
        return 0
    fi

    if [ "${G_SRC_FILE_PATH}" == "${G_DST_FILE_PATH}" ];then
        return 0
    fi

    logcbb_isvailddisk "${G_SRC_FILE_PATH}"
    if [ 0 -eq $? ];then
        rm -rf "${G_DST_FILE_PATH}" 2>/dev/null

        #ǿộͨӽ
        ln -s "${G_SRC_FILE_PATH}" "${G_DST_FILE_PATH%/}"
        if [ 0 -ne $? ];then
            mkdir -p "${G_DST_FILE_PATH}"
        fi
        return 0
    fi

    #̲ãֱӽǰĿ¼Ϊ·
    if [ -L "${G_DST_FILE_PATH}" ];then
        rm -rf "${G_DST_FILE_PATH%/}"
        
        mkdir -p "${G_DST_FILE_PATH}"
        return $?
    fi
    
    return 0
}

# **************************************************************************** #
# Function Name: cg_usage
# Description: ʹ˵
# Parameter: 
# Return: 
# **************************************************************************** #
logcbb_usage()
{
    logcbb_print "Usage: logcbb_file_ops.sh [-option param] [...] [cmd]"
    logcbb_print "    backup        backup src file to dst dir"     
    logcbb_print "    dirlimit      limit the dst dir size" 
    logcbb_print "    backuplimit   backup src file to dst dir with dirlimit"
    logcbb_print "    cleardir      move the all matched src file to dst dir, if dst dir is not exsit, then the files will be removed"
    logcbb_print "    mount         mount disk specified by src to dst dir"
    logcbb_print "    umount        umount src dir"
    logcbb_print "    setdisk       create a link file to the disk specified by src if the disk has been mount, or use the orignal disk" 
    logcbb_print "    -s xxx        specify the src file or dir[end with '/']"    
    logcbb_print "    -d xxx        specify the dst file or dir[end with '/']" 
    logcbb_print "    -l xxx        specify the limit value"     
    logcbb_print "    -p xxx        specify the pattern"     
    logcbb_print "    -h            usage"
    logcbb_print ""
    logcbb_print "Notes:  just used for logcbb"
    logcbb_print "        "
    logcbb_print "example:"
    logcbb_print "    logcbb_file_ops.sh -s \"/src/txt\" -d \"/dst/\" backup"
    logcbb_print "    logcbb_file_ops.sh -s \"/src/txt\" -l 100 dirlimit"    
    logcbb_print "    logcbb_file_ops.sh -s \"/src/txt\" -d \"/dst/\" cleardir"    
    logcbb_print "    logcbb_file_ops.sh -s \"/dev/ramdisk/\" -d \"/ramdisk/\" mount"
    logcbb_print "    logcbb_file_ops.sh -s \"/ramdisk/\" umount"
    logcbb_print "    logcbb_file_ops.sh -s \"/ramdisk/\" -d \"/dst/\" setdisk"    
    logcbb_print ""
}



# --------------------------  main  ------------------------------------------ #
# 
trap "" 1 2 3 15

# 
#εȫֱݴִӦĹܺɹ0
# ʧܷط
#

while getopts ":s:d:l:p:h" opt
do
    case "${opt}" in
        s)
            G_SRC_FILE=$OPTARG
            G_SRC_FILE_PATH=${G_SRC_FILE%/*}
            G_SRC_FILE_NAME=${G_SRC_FILE##*/}            
            ;;
        d)
            G_DST_FILE=$OPTARG
            G_DST_FILE_PATH=${G_DST_FILE%/*}
            ;;
        l)
            G_LIMIT=$OPTARG
            G_LIMIT_CNT=$OPTARG
            ;;
        p)
            G_PATTERN=$OPTARG
            ;;
        h)
            logcbb_usage
            exit 0
            ;;
        :)
            logcbb_log "-$OPTARG needs an argument"
            exit 1
            ;;
        \?)  
            logcbb_log "-$OPTARG unmatched option"
            exit 1
            ;;
        *)  
            logcbb_log "-$OPTARG unknown failed"
            exit 1
            ;;
    esac
done
shift $(($OPTIND - 1))

case "$1" in
    backup)
        logcbb_backup
        ret=$?
        ;;
    dirlimit)
        logcbb_dirlimit
        ret=$?
        ;;
    backuplimit)
        logcbb_backuplimit
        ret=$?
        ;;
    backupcntlimit)
        logcbb_backupcntlimit
        ret=$?
        ;;
    cleardir)
        logcbb_cleardir
        ret=$?
        ;;
    mount)
        logcbb_mount
        ret=$?
        ;;
    umount)
        logcbb_umount
        ret=$?
        ;;
    setdisk)
        logcbb_setdisk
        ret=$?
        ;;
    checkdisk)
        logcbb_checkdisk
        ret=$?
        ;;
    *)
        ret=1
        ;;    
esac 2>/dev/null

if [ 0 -ne ${ret} ]; then
    logcbb_log "exec $1 failed, ret:${ret}"
fi

exit ${ret}

