#!/usr/bin/sh
set +x

PWD=`pwd`
source $PWD/commfunc.sh

LOG_FILE_NAME=$PWD/ost_uninstallation.log

# ************************************************************************************

function UninstallOST(){
  rm -rf $OSTPLUGIN
}

function CheckAndUninstallDataTurbo() {
    if [ $OS_TYPE != "SunOS" ]; then
        Dataturboinfo=`rpm -q "dataturbo"`
        if [ $? -eq 0 ] && [ -f ${OST_BASE}/conf/OST_placehodler.flag ]; then
            DataTurboVersion=`echo $Dataturboinfo | $COMMON_AWK -F "[-]" '{print $2}'`
            Log "The dataturbo client was installed with OST uninstallation, dataturbo client version is $DataTurboVersion."
            systemctl stop dataturbo
            rpm -e dataturbo
            if [ $? -eq 0 ]; then
                echo "The dataturbo client uninstallation complete!"
                Log "The dataturbo client uninstallation complete!"
            else
                echo "The DataTurbo client uninstallation failed! The uninstallation exit."
                Log "The DataTurbo client uninstallation failed! The uninstallation exit."
                exit
            fi
        else
            echo "The dataturbo client is not installed or not install with OST. skip uninstall dataturbo."
            Log "The dataturbo client is not installed or not install with OST. skip uninstall dataturbo."
        fi
    fi
}

function PrintBegan() {
  echo "Begin uninstallation."
}

function LastClean(){
    rm -rf ${OST_BASE}
    echo "Uninstallation at end."
}

# ************************************************************************************

PrintBegan
CheckNBUSoftware
CheckOSTPlugin "uninstall"
CheckAndUninstallDataTurbo
TerminateNbrmms
UninstallOST
StartNbrmms
LastClean
