#! /bin/bash
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# Description: run pragrams in hook dir by name order
# Create: 2022-03-19
#
# run pragrams in hook dir by name order.
# parameter: hook dir path.
# return errno.

# run pragrams in hook dir by name order
# parameter: hook dir path
#
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/common.sh

function run_hook()
{
	  local rex="[0-9][0-9]"
	  local hook_dir="$1"
	  local stage="$2"
	  local status="$3"
	  local custom_user="$4"
	  local link
	  local service

    for link in "$hook_dir"/S${rex}*; do
        test -x "$link" || continue

        service=${link##*/S$rex}
        LOG "$link ${stage} ${status} ${custom_user}"
        $link ${stage} ${status} ${custom_user}
        if [ $? == 0 ]; then
            LOG "$service done"
        else
            LOG "$service failed"
            return 1
        fi
    done
	return 0
}

# ${*} 全部参数
# main
# ${@:2} 从第二个参数开始。
ret=0
logInit
LOG "run $1 $2 $3 $4."
if test -d "$1" ; then
	  run_hook "$1" "$2" "$3" "$4"
	  ret=$?
else
	  LOG "dir $1 not exist"
	  ret=1
fi

exit $ret