#!/bin/sh
set +x

NBRMMS=/usr/openv/netbackup/bin/nbrmms
OSTPLUGIN=/usr/openv/lib/ost-plugins/libstspiOceanProtect*.so
OST_BASE=/opt/OceanProtect
DATATURBO_DIR=dataturbo
DATATURBO=OceanStor_DataTurbo*.zip
DataturboInstalled_Flag=0
OSTPackageContainDataturbo_Flag=0
OS_TYPE=`uname -s`
DataTurboVersion="";
LOGFILE_SUFFIX="gz"
BACKLOGCOUNT=5
MAXLOGSIZE=52428800

if [ "$OS_TYPE" = "SunOS" ]; then
    COMMON_AWK=nawk
else
    COMMON_AWK=awk
fi

function DumpLog() {
    BACKLOGNAME="${LOG_FILE_NAME}.${BACKLOGCOUNT}.${LOGFILE_SUFFIX}"
    NUMBER=`expr ${BACKLOGCOUNT} - 1`
    LOGFILESIZE=`ls -l "${LOG_FILE_NAME}" | $COMMON_AWK -F " " '{print $5}'`
    if [ ${LOGFILESIZE} -gt ${MAXLOGSIZE} ]; then
        if [ -f "${BACKLOGNAME}" ]; then
            rm -f "${BACKLOGNAME}"
        fi

        while [ ${NUMBER} -ge 0 ]
        do
            if [ ${NUMBER} -eq 0 ]; then
                gzip -f -q -9 "${LOG_FILE_NAME}"
                BACKLOGNAME="${LOG_FILE_NAME}.${LOGFILE_SUFFIX}"
            else
                BACKLOGNAME="${LOG_FILE_NAME}.${NUMBER}.${LOGFILE_SUFFIX}"
            fi

            if [ -f "${BACKLOGNAME}" ]; then
                DestNum=`expr $NUMBER + 1`
                mv -f "${BACKLOGNAME}" "${LOG_FILE_NAME}.${DestNum}.${LOGFILE_SUFFIX}"
                chmod 440 "${LOG_FILE_NAME}.${DestNum}.${LOGFILE_SUFFIX}"
            fi

            NUMBER=`expr $NUMBER - 1`
        done
    fi

    if [ ! -f "${LOG_FILE_NAME}" ]; then
        touch "${LOG_FILE_NAME}"
        chmod 600 "${LOG_FILE_NAME}"
    fi
}

function Log() {
    if [ ! -f "${LOG_FILE_NAME}" ]; then
        touch "${LOG_FILE_NAME}"
        chmod 600 "${LOG_FILE_NAME}"
    fi

    DATE=`date +%y-%m-%d--%H:%M:%S`
    if [ "$OS_TYPE" = "SunOS" ]; then
        command -v whoami >/dev/null
        if [ $? -eq 0 ]; then
            USER_NAME=`whoami`
        else
            USER_NAME=`/usr/ucb/whoami`
        fi
    fi
    USER_NAME=`whoami`

    echo "${DATE}:[$$]:${USER_NAME} $1 " >> "${LOG_FILE_NAME}"
    DumpLog
}

function TerminateNbrmms() {
    echo "Terminate nbrmms"
    /usr/openv/netbackup/bin/nbrmms -terminate
    WAIT_TIME=60
    EXIT_FLAG=0
    while [ ${WAIT_TIME} -ge 0 ]
    do
        ps -ef | grep -v grep | grep nbrmms > /dev/null
        if [ $? -ne 0 ]; then
            echo "The nbrmms process has been terminate."
            Log "The nbrmms process has been terminate."
            EXIT_FLAG=1
            break
        fi
        sleep 1
    done

    if [ ${EXIT_FLAG} -eq 0 ]; then
        echo "Terminate nbrmms process failed."
        Log "Terminate nbrmms process failed."
        exit
    fi
}

function StartNbrmms() {
    echo "Start nbrmms"
    /usr/openv/netbackup/bin/nbrmms
    WAIT_TIME=60
    START_FLAG=0
    while [ ${WAIT_TIME} -ge 0 ]
    do
        ps -ef | grep -v grep | grep nbrmms > /dev/null
        if [ $? -eq 0 ]; then
            echo "The nbrmms process started successfully."
            Log "The nbrmms process started successfully."
            START_FLAG=1
            break
        fi
        sleep 1
    done

    if [ $[START_FLAG] -eq 0 ]; then
        echo "The nbrmms process started failed."
        Log "The nbrmms process started failed."
        exit
    fi
}

function CheckOSTPlugin() {
    ls -l ${OSTPLUGIN} > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "The OST plugin exist."
        if [[ $1 == "install" ]]; then
            echo "Exit installation!"
            exit
        fi
    else
        echo "The OST plugin not exist."
        if [[ $1 == "upgrade" ]]; then
            echo "Exit upgrade!"
            exit
        fi
        if [[ $1 == "uninstall" ]]; then
            echo "Exit uninstallation!"
            exit
        fi
    fi
}

function CheckDataTurboInstalled() {
    Dataturboinfo=`rpm -q "dataturbo"`
    if [ $? -eq 0 ]; then
        DataTurboVersion=`echo $Dataturboinfo | $COMMON_AWK -F "[-]" '{print $2}'`
        DataturboInstalled_Flag=1
        Log "The dataturbo installed, the version is $DataTurboVersion."
    else
        Log "The dataturbo client is not installed."
        DataturboInstalled_Flag=0
    fi
}

function CheckOSTPackageContainDataTurboPackage() {
    ls -l ${DATATURBO} > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        Log "The OST plugin package contains the dataturbo client package."
        OSTPackageContainDataturbo_Flag=1
    else
        Log "The OST plugin package does not contain the dataturbo client package."
        OSTPackageContainDataturbo_Flag=0
    fi
}

function UnzipDataTurboPackage() {
    if [ -d ${DATATURBO_DIR} ]; then
        rm -rf ${DATATURBO_DIR}
    fi
    echo "Unzip the dataturbo package."
    Log "unzip the ${DATATURBO_DIR}."
    unzip ${DATATURBO}
    UNZIPED_DIR_NAME=`basename ${DATATURBO} .zip`
    mv ${UNZIPED_DIR_NAME}/ ${DATATURBO_DIR}
}

function PrintPluginInfo() {
    echo "**********************************************"
    /usr/openv/netbackup/bin/admincmd/bpstsinfo -pi -sp OceanProtect
    echo "**********************************************"
}

function CheckKernel(){
    if ! check_kernel ; then
        exit
    fi
}

function CheckNBUSoftware() {
    if [ ! -f  "${NBRMMS}" ]; then
        echo "NBU software not exist!"
        exit
    fi
    echo "The NBU software exist."
}