#!/bin/bash
################################################################################
#   dataturbo rpm安装过程 hook脚本
#   需要有执行权限
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/../common.sh

stage=$1   # 脚本运行阶段(pre or post:)
status=$2  # upgrade or install
usrname=$3

STAGE_PRE="pre"
STAGE_POST="post"
STATUS_INSTALL=1
STAGE_UPGRADE=2
INSTALL_BASE_DIR=/opt/oceanstor/dataturbo

# 将占位符替换为uuid
function gen_cgw_config_uuid()
{
    local system_uuid=$(dmidecode -s system-uuid)
    local flag='true'
    check_is_uuid ${system_uuid}
    if [ $? -eq 1 ]; then
        flag='false'
    fi
    check_is_valid_uuid ${system_uuid}
    if [ $? -eq 1 ]; then
        flag='false'
    fi

    salt=$(date +%s)
    combined_string="$system_uuid$salt"
    md5sum_output=$(echo -n "$combined_string" | md5sum)
    md5sum_value=$(echo "$md5sum_output" | cut -d ' ' -f 1)
    system_uuid=$(echo "$md5sum_value" | sed 's/\(.\{8\}\)\(.\{4\}\)\(.\{4\}\)\(.\{4\}\)\(.\{12\}\)/\1-\2-\3-\4-\5/')

    if [ ${flag} == 'true' ]; then
        sed -i "s/{{SaltData}}/$salt/" /opt/oceanstor/dataturbo/conf/dpc_config.xml
        sed -i "s/{{SystemUuid}}/$system_uuid/" /opt/oceanstor/dataturbo/conf/dpc_config.xml
        log_info "INFO: Succeeded in obtaining the system UUID:[$uuid]."
    else
        local uuid=$(uuidgen)
        log_info "INFO: gen cgw config uuid[$uuid]."
        sed -i "s/{{Uuid}}/$uuid/" /opt/oceanstor/dataturbo/conf/dpc_config.xml
    fi
}

function update_user_name_config()
{
    if [ ! ${usrname} ]; then 
        return
    fi
    USER_NAME_CONF_FILE=${INSTALL_BASE_DIR}/bin/dpc_username_config.ini
    echo "[user]" > ${USER_NAME_CONF_FILE}
    echo "username="${usrname} >> ${USER_NAME_CONF_FILE}
    groupname=$(id -gn ${usrname})
    echo "usergroup="${groupname} >> ${USER_NAME_CONF_FILE}
}


# 只有升级场景才会调到pre, 注意：此时新包还未安装，调用的接口均为老版本
function handle_install_pre()
{
    log_info "execute install_dpc.sh hook in ${status} stage..."
    return 0
}

function handle_install_post()
{
    # TP点 仅debug包使用
    if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
        script_tp_inject $0 $STAGE_POST  # 读取注入脚本的TP点
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi
    
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then # 仅升级场景执行
        log_info "execute install_dpc.sh hook in ${status} stage and upgrade status..."
    elif [ ${status} -eq ${STATUS_INSTALL} ]; then # 仅安装场景执行
        log_info "execute install_dpc.sh hook in ${status} stage and install status with username=${usrname}..."
        gen_cgw_config_uuid
    fi
    
    update_user_name_config

    create_coredump_path

    dataturbo_permission_manage

    return $?
}

function main()
{
    logInit
    log_info "S01install_dpc.sh: run with param [STAGE=${stage}, STATUS=${status}, CUSTOM_USER=${usrname}]"
    if [ "${stage}" == "${STAGE_PRE}" ]; then
        handle_install_pre
    elif [ "${stage}" == "${STAGE_POST}" ]; then
        handle_install_post
    fi

    if [ $? -ne 0 ]; then
        log_error "execute install_dpc.sh hook faild."
        return 1
    fi
    log_info "execute install_dpc.sh hook succeed."
    return 0
}

main
exit $?

