#!/bin/bash
################################################################################
#   1.  start.sh 完成DPC模块的启动
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/common.sh
PID_FILE="/run/dataturbo.pid"
 
function register_dpc_pid_to_systemd()
{
    dpc_pid=$(get_dpc_pid)
    if [ "${dpc_pid}" ];then
        echo ${dpc_pid} > ${PID_FILE}
        return 0
    fi
 
    log_error "register dpc pid to systemd failed！"
    return 1
}

#Description: 设置在OOM流程中，进程被选中并被kill的优先级，改优先级会影响被kill
#             的顺序，但只是影响因素之一，还会受其他因素，例如申请内存大小、存活
#             时间长短等影响
function modify_oom_score_adj()
{
    DPC_PID=$(ps -ef | grep "$DPC_PROCESS" | grep -v grep | awk '{print $2}')
    if [ -f /proc/${DPC_PID}/oom_score_adj ];then
        # 设置低优先级，但不能禁止（-1000），防止内存无限泄漏，cgroup kill不掉
        echo '-800' > /proc/${DPC_PID}/oom_score_adj
        return 0
    fi

    log_error "set oom_score_adj faild！"
    return 1
}
 
function start_sysinfo_monitor()
{
    if [ ! -f ${MONITOR_SCRIPT_RUN_PATH} ]; then
        return
    fi

    monitor_pid=$(ps -ef | grep "${MONITOR_SCRIPT_RUN_PATH}" | grep -v grep | awk '{print $2}')
    if [ "${monitor_pid}" != "" ];then
        log_info "dataturbo restart sysinfo_monitor module."
        kill -9 ${monitor_pid} 1>/dev/null 2>/dev/null
    fi
    
    group_name=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini | grep "usergroup" | cut  -f2  -d "=")
    user_name=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini | grep "username" | cut  -f2  -d "=")
    su - ${user_name} -s /bin/bash -c "bash ${MONITOR_SCRIPT_RUN_PATH} $user_name $group_name &>>${SCRIPT_LOG} &"
    log_info "dataturbo start sysinfo_monitor successfully!"
}

function start_xnet_sysinfo_monitor()
{
    if [ ! -f ${XNET_MONITOR_SCRIPT_RUN_PATH} ]; then
        return
    fi

    local monitor_pid=$(ps -ef | grep "${XNET_MONITOR_SCRIPT_RUN_PATH}" | grep -v grep | awk '{print $2}')
    if [ "${monitor_pid}" != "" ];then
        log_info "dataturbo restart xnet_sysinfo_monitor module."
        kill -9 ${monitor_pid} 1>/dev/null 2>/dev/null
    fi
    
    local group_name=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini | grep "usergroup" | cut  -f2  -d "=")
    local user_name=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini | grep "username" | cut  -f2  -d "=")
    su - ${user_name} -s /bin/bash -c "bash ${XNET_MONITOR_SCRIPT_RUN_PATH} $user_name $group_name 1>>${SYSINFO_LOG_DIR}/run/sys_info.log 2>>${SYSINFO_LOG_DIR}/run/sys_info.log &"
    log_info "dataturbo start xnet_sysinfo_monitor successfully!"
}

function start_remount_script()
{
    bash ${CUR_DIR}/remount.sh 1>/dev/null 2>/dev/null &
}

function start_dataturbo()
{
    ps -ef | grep ${CUR_DIR}/remount.sh | grep -v grep 1>/dev/null 2>/dev/null
    if [ $? -eq 0 ]; then
        kill -9 `ps -ef | grep ${CUR_DIR}/remount.sh | grep -v grep | awk '{print $2}'` 2>/dev/null
    fi
    rm -rf ${CUR_DIR}/dataturbo_remount.lock > /dev/null 2>&1

    bash ${CUR_DIR}/start_dpc.sh
    if [ $? -eq 1 ]; then
        log_error "dataturbo start command was executed faild！"
        return 1
    fi

    start_remount_script

    start_sysinfo_monitor

    start_xnet_sysinfo_monitor

    log_info "dataturbo start command was executed successfully！"
    return 0
}
 
function main()
{
    start_dataturbo
    if [ $? -ne 0 ];then
        exit 1
    fi
    register_dpc_pid_to_systemd
    if [ $? -ne 0 ];then
        exit 1
    fi
    modify_oom_score_adj
    exit $?
}
 
main
