#!/usr/bin/sh
set +x

PWD=`pwd`
source $PWD/commfunc.sh

LOG_FILE_NAME=$PWD/ost_uninstallation.log

# ************************************************************************************

function UninstallOST(){
  rm -rf $OSTPLUGIN
  sed "/^${DISK_TYPE}/d" ${DISK_TYPE_FILE} > ${DISK_TYPE_FILE}.bak;
  mv ${DISK_TYPE_FILE}.bak ${DISK_TYPE_FILE}
}

function CheckAndUninstallDataTurbo() {
    if [ $OS_TYPE != "SunOS" ]; then
        Dataturboinfo=`rpm -q "dataturbo"`
        if [ $? -eq 0 ] && [ -f ${OST_BASE}/conf/OST_placehodler.flag ]; then
            DataTurboVersion=`echo $Dataturboinfo | $COMMON_AWK -F "[-]" '{print $2}'`
            Log "The dataturbo client was installed with OST uninstallation, dataturbo client version is $DataTurboVersion."
            CheckOSTPackageContainDataTurboPackage
            if [ $OSTPackageContainDataturbo_Flag == 0 ]; then
                echo "Not allow to uninstall OST-of-DataTurbo version by a non-DataTurbo-OST-package uninstallation script! Exit uninstallation!"
                Log "Not allow to uninstall OST-of-DataTurbo version by a non-DataTurbo-OST-package uninstallation script! Exit uninstallation!"
                exit
            else
                systemctl stop dataturbo
                rpm -e dataturbo
                if [ $? -eq 0 ]; then
                    echo "The dataturbo client uninstallation complete!"
                    Log "The dataturbo client uninstallation complete!"
                else
                    echo "The DataTurbo client uninstallation failed! The uninstallation exit."
                    Log "The DataTurbo client uninstallation failed! The uninstallation exit."
                    exit
                fi
            fi
        else
            echo "The dataturbo client is not installed or not install with OST. skip uninstall dataturbo."
            Log "The dataturbo client is not installed or not install with OST. skip uninstall dataturbo."
        fi
    fi
}

function PrintBegan() {
  echo "Begin uninstallation."
}

function LastClean(){
    read -p "Do you want to remove the OST conf dir /opt/OceanProtect/?(Yes OR No): " option
    if [ "$option" == "Yes" ]; then
        echo "**********************************************"
        echo "remove the conf dir"
        rm -rf ${OST_BASE}
        echo "**********************************************"
    else
        echo "skip to remove the conf dir"
    fi
    echo "Uninstallation at end."
}

# ************************************************************************************

PrintBegan
if [ $# -ne 2 ] || [ $1 != "-disktype" ]; then
    echo "**********************************************"
    echo "Uninstall Params invalid, uninstall params format:"
    echo " sh uninstall.sh -disktype OceanProtect "
    echo " disktype is OceanProtect or Other Type. "
    echo " Please restart to upgrade."
    echo "**********************************************"
    exit
fi
CheckDiskType $2
CheckNBUSoftware
CheckOSTPlugin "uninstall"
read -p "Do you want to uninstall dataturbo service?(Yes OR No): " option
if [ "$option" == "Yes" ]; then
    echo "**********************************************"
    echo "Begin to uninstall dataturbo"
    CheckAndUninstallDataTurbo
    echo "**********************************************"
else
    echo "skip to uninstall dataturbo"
fi
TerminateNbrmms
UninstallOST
StartNbrmms
LastClean
