#!/bin/bash
################################################################################
#   dataturbo rpm卸载过程 hook脚本
################################################################################
CUR_DIR="$( cd "$( dirname "$0"  )" && pwd )"
source $CUR_DIR/../common.sh
stage=$1   # 脚本运行阶段(pre or post:)
status=$2  # upgrade or install
usrname=$3

STAGE_RPM_PREUN="pre"
STAGE_RPM_POSTUN="post"
STAGE_UPGRADE=1

function uninstall_check()
{
    if [ "$(id -u)" -ne 0 ]; then
        log_error_print "Must login as root."
        return 1
    fi

    # 检查服务的状态
    check_srv_status
    if [ $? -eq 1 ]; then
        log_error_print "dataturbo service is active, please stop first, and then uninstall."
        return 1
    fi

    # 检查进程的状态
    check_dpc_status
    if [ $? -eq 1 ]; then
        log_error_print "dpc process is running, please stop first, and then uninstall."
        return 1
    fi
}

function handle_uninstall_pre()
{
    # TP点 仅debug包使用
    if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
        script_tp_inject $0 $STAGE_RPM_PREUN  # 读取注入脚本的TP点
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then
        log_info "execute uninstall_dpc.sh hook in ${stage} stage and upgrade status..."
        return 0
    fi

    uninstall_check
    if [ $? -ne 0 ]; then
        return 1
    fi

    username=$(cat ${DATATURBO_PATH}/bin/dpc_username_config.ini |grep username | sed -e "s/username=\([0-9A-Za-z]*\)/\1/g" | tr -d '\r')
    local os_name=$(cat /etc/os-release |grep ^NAME | awk -F "=" '{print $2}' | sed 's/\"//g')
    if [ "${os_name}" != "Ubuntu" ]; then
        setfacl -x ${username} /dev/shm 2>/dev/null
    fi

    # delete sudo command
    sed -i '/'${user_name}' ALL=(root) NOPASSWD: \/opt\/oceanstor\/dataturbo\/script\/drop_caches.sh/d' /etc/sudoers

    rm -rf ${CONFIG_PATH}/dpc_alive
    change_dataturbo_file_to_root
    return 0
}

# 仅在升级场景会调到，该接口被调用时为新包中的接口
function handle_uninstall_post()
{
    if [ ${status} -eq ${STAGE_UPGRADE} ]; then
        log_info "execute uninstall_dpc.sh hook in ${stage} stage and upgrade status..."
        # TP点 仅debug包使用
        if [ "${DATATURBO_PACKAGE_TYPE}" == "debug" ]; then
            script_tp_inject $0 $STAGE_RPM_POSTUN  # 读取注入脚本的TP点
            if [ $? -ne 0 ]; then
                return 1
            fi
        fi
    fi
    return 0
}

function main()
{
    if [ ${stage} == ${STAGE_RPM_PREUN} ]; then
        handle_uninstall_pre
    elif [ ${stage} == ${STAGE_RPM_POSTUN} ]; then
        handle_uninstall_post
    fi

    if [ $? -ne 0 ]; then
        log_error "execute uninstall_dpc.sh hook faild."
        return 1
    fi
    log_info "execute uninstall_dpc.sh hook succeed."
    return 0
}

main
exit $?
