#!/usr/bin/sh
source $(dirname "$0")/util.sh
echo "**********************************************"

if ! check_kernel ; then
    exit
fi
DT_TAG=`date +%Y%m%d-%H%M%S`
OST_BASE=/opt/OceanProtect/
mkdir -p ${OST_BASE}/conf
mkdir -p ${OST_BASE}/kmc
mkdir -p ${OST_BASE}/log
mkdir -p ${OST_BASE}/scripts
mkdir -p ${OST_BASE}/temp
if [ -f "${OST_BASE}/ost.conf" ]; then
    mv ${OST_BASE}/ost.conf ${OST_BASE}/conf/ost.conf_${DT_TAG}
fi

if [ -f "${OST_BASE}/conf/ost_conf.xml" ]; then
    mv ${OST_BASE}/conf/ost_conf.xml ${OST_BASE}/conf/ost_conf.xml_${DT_TAG}
fi

if [ -f "${OST_BASE}/conf/ost.conf" ]; then
    cp -rf ${OST_BASE}/conf/ost.conf ${OST_BASE}/conf/ost.conf_${DT_TAG}
fi

if [ -f "${OST_BASE}/conf/ost_conf.xml" ]; then
    cp -rf ${OST_BASE}/conf/ost_conf.xml ${OST_BASE}/conf/ost_conf.xml_${DT_TAG}
fi

cp -rf ost.conf /opt/OceanProtect/conf
cp -rf ost_conf.xml /opt/OceanProtect/conf
cp -rf util.sh ${OST_BASE}/scripts
cp -rf config_filesystem.sh ${OST_BASE}/scripts
chmod 640 ${OST_BASE}/scripts/*.sh
echo "Terminate nbrmms"
/usr/openv/netbackup/bin/nbrmms -terminate
if [ "$?" -eq "0" ]; then
    cp -rf libstspiOceanProtect*.so  /usr/openv/lib/ost-plugins/
fi
echo "Restart nbrmms"
/usr/openv/netbackup/bin/nbrmms
echo "**********************************************"
/usr/openv/netbackup/bin/admincmd/bpstsinfo -pi -sp OceanProtect
echo "**********************************************"
