# -*- coding: utf-8 -*-
from utils.common.exception import FCUException
from plugins.eBackup.common.params_check_tool import init_params
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import check_workflow_web_login
from plugins.eBackup.common.params_check_tool import check_openstack_params


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过FCUException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    """

    db_opt = ParamUtil()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_result = HandleParamCheck()
    all_params = ["openstack_cps_web_pwd", "openstack_cps_admin_pwd",
                  "eBackup_Workflow_nodes", "eBackup_Datamover_nodes",
                  "eBackup_hcp_pwd",
                  "eBackup_root_pwd", "eBackup_admin_pwd"]
    init_params(check_data, db_opt, project_id, check_result, all_params)
    unpassed_ebackup_hcp_nodes = []
    unpassed_ebackup_root_nodes = []
    unpassed_openstack_fsp_nodes = []
    unpassed_openstack_root_nodes = []
    check_ebackup_nodes(
        check_result, "eBackup_Datamover_nodes",
        check_data.get("eBackup_Datamover_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes)
    check_ebackup_nodes(
        check_result, "eBackup_Workflow_nodes",
        check_data.get("eBackup_Workflow_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes)
    ebackup_check_openstack_param(
        check_result, project_id, check_data, unpassed_openstack_fsp_nodes,
        unpassed_ebackup_root_nodes, unpassed_ebackup_hcp_nodes,
        unpassed_openstack_root_nodes)
    # check workflow web login
    result = check_workflow_web_login(check_data, check_result, all_params)
    return result


def ebackup_check_openstack_param(
    check_result, project_id, check_data, unpassed_openstack_fsp_nodes,
    unpassed_ebackup_root_nodes, unpassed_ebackup_hcp_nodes,
        unpassed_openstack_root_nodes):
    if 0 == len(unpassed_ebackup_hcp_nodes):
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=500,
                                      error_msg=FCUException(650001, ",".join(
                                          unpassed_ebackup_hcp_nodes)))
    if 0 == len(unpassed_ebackup_root_nodes):
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=500,
                                      error_msg=FCUException(650002, ",".join(
                                          unpassed_ebackup_root_nodes)))

    check_openstack_params(check_result, project_id, check_data,
                           unpassed_openstack_fsp_nodes,
                           unpassed_openstack_root_nodes)
    if 0 != len(unpassed_openstack_fsp_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"],
                                      status=500,
                                      error_msg=FCUException(650005, ",".join(
                                          unpassed_openstack_fsp_nodes)))
    if 0 != len(unpassed_openstack_root_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"],
                                      status=500,
                                      error_msg=FCUException(650006, ",".join(
                                          unpassed_openstack_root_nodes)))
