# -*- coding:utf-8 -*-
import os
import base64
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.eBackup.common.eBackupDriverUpgrade import EbackupDriverUpgrader
from utils.common.ssh_util import Ssh
from plugins.eBackup.common.util import update_driver_cert_path
from plugins.eBackup.common.util import Utils


class DriverUpgrade(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(DriverUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region_id = regionid_list[0]
        self.database = BaseOps()
        self._db_param_dict = Utils.init_system_params(project_id,
                                                       regionid_list[0])
        self.reverse_proxy_ip = self._db_param_dict['openstack_reverse_proxy_ip']
        self.fsp_user = "fsp"
        self.fsp_pwd = self._db_param_dict['openstack_fsp_pwd']
        self.fsp_root_pwd = self._db_param_dict['openstack_root_pwd']
        self.cps_pwd = self._db_param_dict['openstack_cps_admin_pwd']

    def _execute_upgrade(self):
        try:
            driver_upgrade = EbackupDriverUpgrader(
                self.reverse_proxy_ip,
                self._db_param_dict
            )
            if self.get_cps_upg_state() == "upg":
                self.set_cps_upg_state("all_open")
                # 将状态保存到文件 防止失败重试时未将状态置回 OpenStack在网络服务升级大工步结束后才将升级状态置为all_open
                Utils.set_value_to_config_file("need_rollback_state", "True")
            upgrade_result = driver_upgrade.upgrade()
            update_driver_cert_path(self.reverse_proxy_ip, self._db_param_dict)
            if Utils.get_value_from_config_file("need_rollback_state") == "True":
                self.set_cps_upg_state("upg")
                Utils.set_value_to_config_file("need_rollback_state", "False")
            self.clean_up_env()
            return upgrade_result
        except Exception as ex:
            logger.error(str(ex))
            return False

    def clean_up_env(self):
        sshclient = Utils.get_ssh_client(
            self.reverse_proxy_ip, self.fsp_user, self.fsp_pwd, self.fsp_root_pwd)
        cmd = "sed -i '/CPS_PASSWORD/d' ~/.bash_history;sed -i '/CPS_PASSWORD/d' /var/log/messages"
        Utils.ssh_send_comand_return(sshclient, cmd)

    def set_cps_upg_state(self, state):
        sshclient = Utils.get_ssh_client(
            self.reverse_proxy_ip, self.fsp_user, self.fsp_pwd, self.fsp_root_pwd)
        cmd = f"export CPS_USERNAME=cps_admin;export CPS_PASSWORD='{self.cps_pwd}';" \
              f"upgrade cps reststate-update {state};echo last cmd result: $?"
        result = Utils.ssh_send_comand_return(sshclient, cmd)
        if str(result).find("last cmd result: 0") == -1:
            raise FCUException(650063, state, str(result), self.reverse_proxy_ip, state)

    def get_cps_upg_state(self):
        sshclient = Utils.get_ssh_client(
            self.reverse_proxy_ip, self.fsp_user, self.fsp_pwd, self.fsp_root_pwd)
        cmd = f"export CPS_USERNAME=cps_admin;export CPS_PASSWORD='{self.cps_pwd}';" \
              f"upgrade cps reststate-show;echo last cmd result: $?"
        result = Utils.ssh_send_comand_return(sshclient, cmd)
        if str(result).find("upg") != -1:
            return "upg"
        elif str(result).find("all_open") != -1:
            return "all_open"
        else:
            raise FCUException(650064, str(result))

    def check_cutover_status(self):
        ssh_client = None
        try:
            file_path = os.path.realpath(__file__ + '/../bin/queryDriverNodes.py')
            cps_admin_pwd_unicode = self._db_param_dict['openstack_cps_admin_pwd']
            cps_admin_pwd = base64.b64encode(cps_admin_pwd_unicode.encode("utf-8")).decode(encoding="utf-8")
            ssh = Ssh()
            ret = ssh.put_file(
                self.reverse_proxy_ip, self.fsp_user, self.fsp_pwd, file_path, "/home/fsp/")
            if not ret:
                logger.error("Upload %s to %s failed." % (file_path, self.reverse_proxy_ip))
                raise FCUException(650007, self.reverse_proxy_ip, '/home/fsp', self.fsp_user)
            logger.info("Upload queryDriverNode.py to %s successfully." % self.reverse_proxy_ip)

            cmd = 'cd /home/fsp;chmod +x queryDriverNodes.py;' + \
                  'python queryDriverNodes.py cps_admin \"%s\" ' + \
                  'check_cutover && echo "Success";' % cps_admin_pwd + \
                  '''sed -i '/queryDriverNodes.py/ d' ~/.bash_history;''' + \
                  '''history -c;rm -f /home/fsp/queryDriverNodes.py'''
            ssh_client = ssh.ssh_create_client(
                self.reverse_proxy_ip, self.fsp_user,self.fsp_pwd)
            ssh.ssh_send_command(ssh_client, 'su - root', 'Password:', 100)
            ssh.ssh_send_command(ssh_client, self.fsp_root_pwd, '#', 100)
            result = ssh.ssh_exec_command_return_list(ssh_client, cmd)
            if -1 == str(result).find("Success"):
                logger.error("Cinder backup deploy info cutover is"
                             " not completed.")
                return False
            logger.error("Cinder backup deploy info cutover is completed.")
            return True
        except Exception as e:
            logger.error(
                "Check cinder backup cutover status failed: " + str(e))
            raise e
        finally:
            Utils.close_ssh_clinet(ssh_client)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            is_true = self._execute_upgrade()
            if not is_true:
                logger.info("Fail to Upgrade eBackup driver.")
                return Message(500, "Fail to Upgrade eBackup driver.")
            return Message(200)
        except FCUException as ex:
            logger.error("Exception occurs when upgrade "
                         "eBackup driver: " + str(ex))
            return Message(500, ex)
        except Exception as e:
            logger.error("Upgrade eBackup driver failed, "
                         "the reason is: " + str(e))
            return Message(500, error_msg_cn="升级eBackup Driver失败，"
                                             "请查看日志详情, 异常信息：%s" %
                                             str(e),
                           error_msg_en="Upgrade eBackup driver failed,please"
                                        " see the log for detail, error info："
                                        "%s" % str(e))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)
