#!/bin/sh
source /opt/huawei/dj/inst/bin/utils.sh
CONTROL_PARA="$1"
CURRENT_DIR=$(dirname $(readlink -f $0))
LOG_PATH="/var/log/huawei/dj/services/system/DJServiceControl"
LOG_FILE="${LOG_PATH}/DJServiceControl.log"
SERVICE_LIST="zookeeper cps-monitor omm-ha cms scagent rabbitmq haproxyinternal karbor-api karbor-protection karbor-operation resource_manager"

function waitDockerReady()
{
    for i in {1..200}
    do
        count=`systemctl status  docker.service | grep "Active: active (running)" | wc -l `
        if [ ${count} -ne 0 ];then
            systemctl restart haveged
            return 0
        fi
        log_info "Waiting for the docker service to be ready ......"
        systemctl restart  docker.service
        sleep 3
    done
    log_error "Docker service is not ready, exit soon."
    exit 1
}

function restart_service()
{
    log_info "begin restart backup service..."
    for service in ${SERVICE_LIST};do
        if [ ! -f "/usr/bin/${service}Control" ];then
            continue
        fi
        cmd_retry "${service}Control -A RESTART" 60 5
        CHECK_RESULT $? "restart ${service} failed!"
        log_info "restart ${service} success."
    done
    log_info "restart backup service finish."
}

function start_service()
{
    log_info "begin start backup service..."
    for service in ${SERVICE_LIST};do
        if [ ! -f "/usr/bin/${service}Control" ];then
            continue
        fi
        cmd_retry "${service}Control -S RUN" 60 5
        CHECK_RESULT $? "start ${service} failed!"
        log_info "start ${service} success."
    done
    log_info "start backup service finish."
}

function stop_service()
{
    log_info "begin stop backup service..."
    local sort_list=""
    for service in ${SERVICE_LIST};do
        sort_list="${service} ${sort_list}"
    done
    for service in ${sort_list};do
        if [ ! -f "/usr/bin/${service}Control" ];then
            continue
        fi
        cmd_retry "${service}Control -S STOP" 60 5
        CHECK_RESULT $? "stop ${service} failed!"
        log_info "stop ${service} success."
    done
    log_info "stop backup service finish."
}

#################################################### main ####################
uptime=$(cat /proc/uptime |awk '{print $1}')
uptime_second=${uptime%.*}
if [ -n "${uptime_second}" ] && [ "${uptime_second}" -lt "40" ];then
    sleep 30
    log_info "========System new reboot here======="
fi
waitDockerReady
if [[ "X${CONTROL_PARA}" == "Xrestart" ]];then
    restart_service
elif [[ "X${CONTROL_PARA}" == "Xstart" ]];then
    start_service
elif [ "X$1" == "Xstop" ];then
    stop_service
fi
exit 0