#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/huawei/dj/install.log"
source $(dirname ${cur_dir})/utils.sh
NTP_CONF_FILE="/etc/ntp.conf"
DNS_CONF_FILE="/etc/resolv.conf"


function append_default_config()
{
    cat ${NTP_CONF_FILE} | grep "^restrict -6 default kod nomodify notrap nopeer noquery" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "restrict -6 default kod nomodify notrap nopeer noquery"   >> ${NTP_CONF_FILE}
    fi
    cat ${NTP_CONF_FILE} | grep "^restrict default kod nomodify notrap nopeer noquery" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "restrict default kod nomodify notrap nopeer noquery"   >> ${NTP_CONF_FILE}
    fi
    cat ${NTP_CONF_FILE} | grep "^restrict 127.0.0.1" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "restrict 127.0.0.1"   >> ${NTP_CONF_FILE}
    fi
    cat ${NTP_CONF_FILE} | grep "^restrict ::1" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "restrict -6 ::1"   >> ${NTP_CONF_FILE}
    fi
    cat ${NTP_CONF_FILE} | grep "^disable monitor" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "disable monitor"   >> ${NTP_CONF_FILE}
    fi
}


function make_ntp_config_file()
{
    sed -i '/^server /d' ${NTP_CONF_FILE}
    set_ntp_server_by_config $@
    append_default_config
}


function set_ntp_server_by_config()
{
    ip_list1=$@
    if [ "$ip_list1" = "" ];then
        return
    fi
    service ntpd stop
    for ip in ${ip_list1[@]};do
        ntpdate -b ${ip}
        echo "server ${ip}" >> ${NTP_CONF_FILE}
    done
}


function change_ntp_conf()
{
    ntp_info=$(get_info.py ntp_server_ip)
    if [ ! -n "$ntp_info" ] || [ "$ntp_info" = "None" ]; then
        return
    fi
    ip_list=($(echo $ntp_info | tr ',' ' '))
    make_ntp_config_file ${ip_list[@]}
    service ntpd restart
    return 0
}


function change_dns_conf()
{
    dns_info=$(get_info.py dns_ip)
    if [ ! -n "$dns_info" ] || [ "$dns_info" = "None" ]; then
        return
    fi
    ip_list=($(echo $dns_info | tr ',' ' '))
    sed -i '/^nameserver /d' ${DNS_CONF_FILE}
    for ip in ${ip_list[@]};do
        echo "nameserver $ip" >> ${DNS_CONF_FILE}
    done
    return 0
}


function open_ntp_service()
{
    local service_stat=$(/usr/bin/systemctl is-enabled ntpd.service)
    if [ -z "$service_stat" ];then
         log_error "ntp service is not exist."
         return 1
    fi

    log_info "before start, ntp status is:$service_stat"
    /usr/bin/systemctl enable ntpd.service
}

change_dns_conf; CHECK_RESULT $? "Change dns conf failed!"
change_ntp_conf; CHECK_RESULT $? "Change ntp conf failed!"
open_ntp_service; CHECK_RESULT $? "Open ntp service failed!"