#!/bin/sh
cur_dir=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/huawei/dj/install.log"
LINE_ROOT=$(dirname $(dirname ${cur_dir}))
source $(dirname ${cur_dir})//utils.sh
UTIL_CONF=${LINE_ROOT}/conf/util.conf
USER_NAME="djmanager"
USER_HOME="/home/${USER_NAME}"
PRIVATE_KEY="${USER_HOME}/.ssh/id_rsa"
PUBLIC_KEY="${USER_HOME}/.ssh/id_rsa.pub"
AYTHORISED_FILE="${USER_HOME}/.ssh/authorized_keys"
SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=5 -i ${USER_HOME}/.ssh/id_rsa"

UseDNS=`grep "UseDNS " /etc/ssh/sshd_config`
if [[ "${UseDNS}" != "UseDNS no" ]]; then
    sed -i "s/${UseDNS}/UseDNS no/g" /etc/ssh/sshd_config
    service sshd restart>/dev/null
fi

local_ip=$(get_info.py --manage_ip)
ListenAddress=`grep "^ListenAddress " /etc/ssh/sshd_config`
if [[ "${ListenAddress}" != "ListenAddress ${local_ip}" ]]; then
    sed -i "/${ListenAddress}/d" /etc/ssh/sshd_config
    echo "ListenAddress ${local_ip}" >> /etc/ssh/sshd_config
    service sshd restart>/dev/null
fi

function check_logon()
{
    local host=$1
    local user=$2
    /usr/bin/expect<<-EOF
set timeout 5
spawn su - ${user}
expect {
        ":~>" {send "ssh $SSH_OPT ${user}@${host}\r"}
        "\$" {send "ssh $SSH_OPT ${user}@${host}\r"}
        }
expect {
        "yes/no" {exit 1}
        "assword:" { exit 2}
        ":~>" {exit 0}
        "\$" {exit 0}
        }
exit 3
EOF
}

function check_self_login()
{
    local host=$1
    local user=$2
    local passwd=$3
    /usr/bin/expect<<-EOF
set timeout 2
spawn su - ${user}
expect {
        ":~>" {send "ssh $SSH_OPT ${user}@${host}\r"}
        "\$" {send "ssh $SSH_OPT ${user}@${host}\r"}
        }
expect {
        "yes/no" { send "yes\r"; exp_continue}
        "assword:" { send "$passwd\r"}
        ":~>" {exit 0}
        "\$" {exit 0}
        }
expect {
        ":~>" {exit 0}
        "\$" {exit 0}
        "assword:" { exit 1}
        }
exit 3
EOF
}

function scp_tool()
{
    local host=$1
    local user=$2
    local passwd=$3
    local src_path=$4
    local dst_path=$5
    /usr/bin/expect<<-EOF
set timeout 15
spawn su - $user
expect {
        ":~>" {send "scp ${user}@\[${host}\]:${src_path} ${dst_path} \r"}
        "\$" {send "scp ${user}@\[${host}\]:${src_path} ${dst_path} \r"}
        }
expect {
        "yes/no" { send "yes\r"; exp_continue}
        "assword:" { send "$passwd\r"}
        }
expect {
        "assword:" { send "$passwd\r"}
        }
exit 0
EOF
}

function modify_auth_security()
{
    if [ -f /etc/pam.d/system-auth-local ];then
        if [ ! -f /etc/pam.d/system-auth.bak ];then
            cp -rf /etc/pam.d/system-auth-local /etc/pam.d/system-auth.bak
        fi
        sed -i "/auth        sufficient    pam_unix.so nullok try_first_pass/d" /etc/pam.d/system-auth-local
        sed -i "/password    required      pam_pwhistory.so use_authtok remember=5 enforce_for_root/d" /etc/pam.d/system-auth-local
    fi
    sed -i '/djmanager/d' /etc/security/opasswd
}


function restore_auth_security()
{
    if [ -f /etc/pam.d/system-auth-local ];then
        if [ -f /etc/pam.d/system-auth.bak ];then
            rm -f /etc/pam.d/system-auth-local
            mv /etc/pam.d/system-auth.bak /etc/pam.d/system-auth-local
        fi
    fi
}

function unlock_user()
{
    local retry_time_limit=100
    local retry_time=0
    while [[ ${retry_time} -lt ${retry_time_limit} ]];do
        count=`pam_tally2 --reset -u ${USER_NAME} | grep ${USER_NAME} | awk '{print $2}'`
        if [[ ${count} -le 0 ]];then
             break
        fi
          retry_time=$[ ${retry_time} + 1 ]
          log_error "ulock user,retry_time:${retry_time}"
    done
}


# 公、私有云场景djmanager密码不同，需要分开获取
PROFILE=$(get_info.py --profile)
if [[ "${PROFILE}" == "public" ]];then
    pwd_en=$(get_pwd djmanager_pwd_for_public_cloud ${UTIL_CONF})
else
    pwd_en=$(get_pwd djmanager_pwd_for_private_cloud ${UTIL_CONF})
fi
export ENCRYPT_DATA=${pwd_en}
USER_PWD=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")

modify_auth_security
which chpasswd >/dev/null 2>&1
if [[ $? -eq 0 ]];then
    echo "djmanager:${USER_PWD}" | chpasswd
    if [[ $? -ne 0 ]];then
        log_warn "chpasswd command failed, use passwd."
        echo ${USER_PWD} | passwd --stdin djmanager
    fi
else
    log_warn "chpasswd command not exist, use passwd."
    echo ${USER_PWD} | passwd --stdin djmanager
fi
restore_auth_security

NODE_LIST=($(get_info.py manage_ip list | sed 's/,/\ /g'))
if [[ ${#NODE_COUNT[@]} -eq 1 ]];then
    log_info "Single node ,no need config ssh."
    exit 0
fi

self_manage_ip=`get_info.py manage_ip`
check_max_count=300
check_count=0
while [[ ${check_count} -lt ${check_max_count} ]];do
    check_self_login ${self_manage_ip} ${USER_NAME} ${USER_PWD}
    if [[ $? -eq 0 ]];then
        break
    fi
    check_count=$[ ${check_count} + 1 ]
    log_error "check user,check_count:${check_count}"
    unlock_user
    sleep 1
done


retry_time_limit=200
rm -f ${PRIVATE_KEY} ${PUBLIC_KEY} ${AYTHORISED_FILE}
su ${USER_NAME} -c "echo \"n\" | ssh-keygen -t rsa -b 2048 -f ${PRIVATE_KEY} -P \"\""
su ${USER_NAME} -c "touch ${AYTHORISED_FILE} && chmod 600 ${AYTHORISED_FILE}"
cat ${PUBLIC_KEY} | grep "djmanager@"
if [[ $? -eq 1 ]]; then
    log_error "self node: do not exist public key."
    exit 1
fi


cp ${PUBLIC_KEY} ${USER_HOME}/${self_manage_ip}_id_rsa.pub
for node in ${NODE_LIST[@]};do
    if [[ "${node}" == "${self_manage_ip}" ]];then
        continue
    fi
    retry_time=0
    while [[ ${retry_time} -lt ${retry_time_limit} ]];do
        unlock_user
        scp_tool ${node}  ${USER_NAME}  ${USER_PWD} ${PUBLIC_KEY} ${USER_HOME}/${node}_id_rsa.pub
        retry_time=$[ ${retry_time} + 1 ]
        if [ -e "${USER_HOME}/${node}_id_rsa.pub" ];then
            cat ${USER_HOME}/${node}_id_rsa.pub | grep "djmanager@"
            if [ $? -eq 0 ];then
                log_info "get public key success from ${node}."
                break
            fi
        fi
        if [[ ${retry_time} -ge ${retry_time_limit} ]];then
            log_error "config internal ssh failed and exit."
            exit 1
        fi
        log_warn "get public key failed from ${node},retry_time:${retry_time}."
        sleep 2
        continue
    done
done
log_info "prepare public key list finished."


for node in ${NODE_LIST[@]};do
    cat ${USER_HOME}/${node}_id_rsa.pub>>${AYTHORISED_FILE}
    node_key=`cat ${USER_HOME}/${node}_id_rsa.pub`
    grep "$node_key" ${AYTHORISED_FILE} >>/dev/null
    if [[ $? -eq 1 ]];then
        log_warn "append public key failed on ${node},retry one time."
        cat ${USER_HOME}/${node}_id_rsa.pub>>${AYTHORISED_FILE}
    fi
done
log_info "prepare authorized_keys finished."

for node in ${NODE_LIST[@]};do
    local retry_time_limit=100
    local retry_time=0
    while [[ ${retry_time} -lt ${retry_time_limit} ]];do
        check_logon ${node} ${USER_NAME}
        if [[ $? -eq 0 ]];then
            log_info "${node} valid success."
            break
        fi
        log_warn "wait node ${node},retry_time:${retry_time}."
        retry_time=$[ ${retry_time} + 1 ]
        sleep 3
    done
done

for node in ${NODE_LIST[@]};do
    rm -f ${USER_HOME}/${node}_id_rsa.pub
done

flag_path="/home/djmanager/flag"
echo "done" >>${flag_path}
chown -h djmanager:openstack ${flag_path}

for node in ${NODE_LIST[@]};do
    ip addr | grep -w "${node}"
    if [[ $? -eq 0 ]];then
        continue
    fi
    local retry_time_limit=450
    local retry_time=0
    while [[ ${retry_time} -lt ${retry_time_limit} ]];do
        if su - djmanager -c "ssh ${node} test -e ${flag_path}";then
            log_info "${node} check finished."
            break
        else
            log_warn "failed to check ${node}, ${flag_path} is not exist."
            sleep 2
        fi
        retry_time=$[ ${retry_time} + 1 ]
        sleep 2
    done
done
chmod 600 ${USER_HOME}/.ssh/*