# coding:utf-8
# pylint: disable=missing-docstring
import os
import yaml

HA_ACTIVE_ACTIVE = 0
HA_ACTIVE_STANDBY = 1


class ParseYaml(object):
    def __init__(self, services_path):
        self.services, self.service_list = self.load_services(services_path)

    @staticmethod
    def open_yaml(file_names, services_path, service_name, services):
        file_name = "%s.yaml" % service_name
        if file_name in file_names:
            obj = open("%s/%s/%s" % (services_path, service_name, file_name))
            services[service_name] = yaml.safe_load(obj)

    def parse_yaml_files(self, services_path, services):
        service_names = os.listdir(services_path)
        for service_name in service_names:
            if os.path.isfile("%s/%s" % (services_path, service_name)):
                continue
            file_names = os.listdir("%s/%s" % (services_path, service_name))
            self.open_yaml(file_names, services_path, service_name, services)

    def get_service_layers(self, layers, services):
        for service_info in services.values():
            index = service_info.get("Level")
            if index not in layers.keys():
                same_layer_services = list()
                same_layer_services.append(service_info)
                layers[index] = same_layer_services
            else:
                layers[index].append(service_info)
        for index, same_layer in layers.items():
            layers[index] = self.sort_dependences(same_layer, services)

    def load_services(self, services_path):
        service_layers = dict()
        services_temp = dict()
        services = list()
        if os.path.exists(services_path):
            self.parse_yaml_files(services_path, services_temp)
        self.get_service_layers(service_layers, services_temp)
        for i in [0, 1, 2, 3]:
            if not service_layers.get(i):
                continue
            for name in service_layers.get(i):
                if services_temp.get(name) and name not in services:
                    services.append(name)
        return services_temp, services

    def add_dependense(self, service_info, services, service_sorted_list):
        dependense_list = service_info.get("Dependence")
        if not dependense_list:
            service_sorted_list.append(service_info.get("Name"))
            return
        for depend in dependense_list:
            if depend.get("name") in service_sorted_list:
                continue
            depend_info = services.get(depend.get("name"))
            if not depend_info:
                continue
            self.add_dependense(depend_info, services, service_sorted_list)
        if service_info.get("Name") not in service_sorted_list:
            service_sorted_list.append(service_info.get("Name"))

    def sort_dependences(self, same_layer_services, services):
        service_sorted_list = list()
        for service_info in same_layer_services:
            dependense_list = service_info.get("Dependence")
            if not dependense_list:
                service_sorted_list.append(service_info.get("Name"))
            if service_info.get("Name") in service_sorted_list:
                continue
            self.add_dependense(service_info, services, service_sorted_list)
        return service_sorted_list

    def get_service_info(self, service_name):
        return self.services[service_name]

    def get_service_list(self):
        return self.service_list
