#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/huawei/dj/install.log"
source $(dirname ${cur_dir})//utils.sh

IP_VERSION=$(get_info.py ip_version)
manage_ip=$(get_info.py manage_ip)
manage_ip_netmask=$(get_info.py manage_ip_netmask)
gaussdb_float_ip=$(get_info.py gaussdb_float_ip)
haproxy_float_ip=$(get_info.py haproxy_float_ip)
node_list=($(get_info.py manage_ip list|sed 's/,/ /g'))

function CheckIPAddr() 
{ 
    echo $1|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null; 
    if [ $? -ne 0 ];then
        log_error "Check failed.The IP address ($1) is in an incorrect format."
        return 1 
    fi
    ipaddr=$1 
    a=`echo $ipaddr|awk -F . '{print $1}'`  
    b=`echo $ipaddr|awk -F . '{print $2}'` 
    c=`echo $ipaddr|awk -F . '{print $3}'` 
    d=`echo $ipaddr|awk -F . '{print $4}'` 
    for num in $a $b $c $d 
    do
        if [ $num -gt 255 ] || [ $num -lt 0 ];then
            log_error "Check failed.The IP address ($1) is invalid."
            return 1 
        fi
    done
    for num in $a $b $c $d
    do
        if [ ${#num} -gt 1 ] && [ ${num:0:1} = 0 ];then
            log_error "Check failed.The IP address or netmask ($1) is invalid."
            return 1
        fi
    done
    return 0 
}


function CheckIPV6Addr()
{
    ip_addr=`echo $1 | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'`
    if [ "$ip_addr" = "" ];then
        log_error "not input ip"
        return 1
    fi
    if [[ $ip_addr =~ " " ]];then
        log_error "IP address contain space"
        return 1
    fi
    three_check=`echo $ip_addr | awk -F':::' '{print NF}'`
    if [ $three_check -ne 1 ];then
        log_error "IP address contain str(:::)"
        return 1
    fi
    two_check=`echo $ip_addr | awk -F'::' '{print NF}'`
    if [ $two_check -gt 2 ];then
        log_error "IP address contain count($two_check) of str(::)."
        return 1
    fi
    one_check=`echo $ip_addr | awk -F':' '{print NF}'`
    if [ $one_check -lt 3 -o  $one_check -gt 8 ];then
        log_error "IP address contain count($one_check) of str(:)."
        return 1
    fi
    until [ $one_check -le 0 ]
    do
        ipv6_value=`echo $ip_addr | awk -F':' '{print  $(echo "'"$one_check"'")}'`
        if [ ${#ipv6_value} -gt 4 ];then
            log_error "IP address contain str($ipv6_value)."
            return 1
        fi
        ipv6_check=`echo $ipv6_value | sed 's/[a-fA-F0-9]//g'`
        if [ "$ipv6_check" != "" ];then
            log_error "IP address contain str($ipv6_check)."
            return 1
        fi
        one_check=$(( $one_check - 1 ))
    done
}


function check_ini_ip()
{
    if [ $IP_VERSION = "ipv6" ];then
        eval "CheckIPV6Addr $manage_ip"
    else
        eval "CheckIPAddr $manage_ip"
    fi
    if [ $? -ne 0 ];then
        log_error "Check failed. The ip of ($ipItem) is invalid."
        return 1
    fi
    log_info "Successfully checked all IP address are valid."
    return 0
}


function all_ipv6_addr()
{
    ipv6_addr=$1
    one_check=`echo $ipv6_addr | awk -F':' '{print NF}'`
    one_check=$(( 8 - $one_check ))
    respace_str=:0000:
    until [ $one_check -le 0 ]
    do
        respace_str="${respace_str}0000:"
        one_check=$(( $one_check - 1 ))
    done
    ipv6_addr=${ipv6_addr/"::"/$respace_str}
    ipv6_addr=${ipv6_addr/#":"/"0:"}
    ipv6_addr=${ipv6_addr/%":"/":0"}
    ipv6_addr_all=""
    one_check=`echo $ipv6_addr | awk -F':' '{print NF}'`
    until [ $one_check -le 0 ]
    do
        ipv6_value=`echo $ipv6_addr | awk -F':' '{print  $(echo "'"$one_check"'")}'`
        zero_cnt=$(( 4 - ${#ipv6_value} ))
        until [ $zero_cnt -le 0 ]
        do
            ipv6_value="0$ipv6_value"
            zero_cnt=$(( $zero_cnt - 1 ))
        done
        if [ $ipv6_addr_all ];then
            ipv6_addr_all="$ipv6_value:$ipv6_addr_all"
        else
            ipv6_addr_all="$ipv6_value"
        fi
        one_check=$(( $one_check - 1 ))
    done
    echo $ipv6_addr_all
}


function CheckIPV6isinsame_net_segment()
{
    node_ip=$(all_ipv6_addr $1)
    float_ip=$(all_ipv6_addr $2)
    net_mask_code=$((128-$3))
    net_mask=$(csbs_python -c 'print("%x" %((0xffffffffffffffffffffffffffffffff<<'$net_mask_code')&0xffffffffffffffffffffffffffffffff))')
    node_ip=`echo $node_ip | sed "s/://g"`
    float_ip=`echo $float_ip | sed "s/://g"`
    node_result=$(csbs_python -c 'print("%x" %(0x'$net_mask'&0x'$node_ip'))')
    float_result=$(csbs_python -c 'print("%x" %(0x'$net_mask'&0x'$float_ip'))')
    if [ $node_result != $float_result ];then
        log_error "float_ip($2) and ip($1) is not in same net segment."
        return 1
    fi
    log_info "float_ip($2) and ip($1) is in same net segment."
}


function CheckIPisinsame_net_segment() 
{ 
    echo $1|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null; 
    if [ $? -ne 0 ];then
        log_error "Check failed. The IP address ($1) is invalid."
        return 1 
    fi
    echo $2|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null; 
    if [ $? -ne 0 ];then
        log_error "Check failed. The IP address ($1) is invalid."
        return 1 
    fi
    echo $3|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null;
    if [ $? -ne 0 ];then
        log_error "Check failed. The IP address ($1) is invalid."
        return 1 
    fi
    node_ip=$1 
    float_ip=$2
    float_netmask=$3
    netmask_a=`echo $float_netmask | awk -F. '{print $1}'`
    netmask_b=`echo $float_netmask | awk -F. '{print $2}'`
    netmask_c=`echo $float_netmask | awk -F. '{print $3}'`
    netmask_d=`echo $float_netmask | awk -F. '{print $4}'`
    log_info "Checking  float_netmask $netmask_a $netmask_b $netmask_c $netmask_d"
    float_ip_a=`echo $float_ip | awk -F. '{print $1}'`
    float_ip_b=`echo $float_ip | awk -F. '{print $2}'`
    float_ip_c=`echo $float_ip | awk -F. '{print $3}'`
    float_ip_d=`echo $float_ip | awk -F. '{print $4}'`
    log_info "Checking  float_ip $float_ip_a $float_ip_b $float_ip_c $float_ip_d"
    ip_a=`echo $node_ip | awk -F. '{print $1}'`
    ip_b=`echo $node_ip | awk -F. '{print $2}'`
    ip_c=`echo $node_ip | awk -F. '{print $3}'`
    ip_d=`echo $node_ip | awk -F. '{print $4}'`
    log_info "Checking  node_ip $ip_a $ip_b $ip_c $ip_d"
    a_fvalue=$((float_ip_a&netmask_a)) 
    b_fvalue=$((float_ip_b&netmask_b)) 
    c_fvalue=$((float_ip_c&netmask_c)) 
    d_fvalue=$((float_ip_d&netmask_d))
    a_value=$((ip_a&netmask_a)) 
    b_value=$((ip_b&netmask_b)) 
    c_value=$((ip_c&netmask_c)) 
    d_value=$((ip_d&netmask_d))
    log_info "Checking float_ip&mask $a_fvalue $b_fvalue $c_fvalue $d_fvalue IP is OK!"
    log_info "Checking ip&mask $a_value $b_value $c_value $d_value IP is OK!"
    if [ $a_fvalue -eq $a_value -a $b_fvalue -eq $b_value -a $c_fvalue -eq $c_value -a $d_fvalue -eq $d_value ];then
        log_info "float_ip and ip is in same net segment."
    else
        log_error "float_ip and ip is not in same net segment."
        return 1
    fi
    return 0 
}


function check_floatip_net_segment()
{
    if [ ${#node_list[@]} -eq 1 ];then
        log_info "Successfully checked that the static IP address."
        return 0
    fi
    if [ $IP_VERSION = "ipv6" ];then
        eval "CheckIPV6isinsame_net_segment $manage_ip $haproxy_float_ip $manage_ip_netmask"
    else
        eval "CheckIPisinsame_net_segment $manage_ip $haproxy_float_ip $manage_ip_netmask"
    fi
    if [ $? -ne 0 ];then
       log_error "Check failed. The floating IP address of management plane and static IP address are not in the same network segment."
       return 1
    fi
    if [ $IP_VERSION = "ipv6" ];then
        eval "CheckIPV6isinsame_net_segment $manage_ip $gaussdb_float_ip $manage_ip_netmask"
    else
        eval "CheckIPisinsame_net_segment $manage_ip $gaussdb_float_ip $manage_ip_netmask"
    fi
    if [ $? -ne 0 ];then
       log_error "Check failed. The ending floating IP address of gaussdb plane and static IP address are not in the same network segment."
       return 1
    fi
    log_info "Successfully checked that the floating IP address and static IP address are not in the same network segment."
    return 0
}


function check_ini_hostname()
{
    local host_name=$(get_info.py hostname)
    local old_ifs=${IFS}
    IFS=','
    local name_len=${#host_name[@]}
    IFS=${old_ifs}
    for (( i = 0; i < ${name_len}; i++ ))
    {
        echo "${host_name[i]}" | grep "^[A-Za-z0-9\-]*$" > /dev/null;
        if [ $? -ne 0 ];then
            log_error "Check failed.the parameter hostname \"${outHostnm[i]}\" is invalid that msut be (number letters or -)"
            return 1
        fi
        for (( j = `expr ${i} + 1`; j < ${name_len}; j++ ))
        {
            if [ "${host_name[i]}" = "${host_name[j]}" ];then
                log_error "Check failed. The hostname \"${host_name[j]}\" is the same as other nodes'."
                return 1
            fi
        }
    }
    log_info "Check hostname in ini file OK."
    return 0
}

function check_ini_timezone()
{
    acttimez=$(get_info.py timezone)
    if [ $? -ne 0 ] || [ "$acttimez" = "None" ];then
        log_error "Check failed. Achieve the parameter of timezone from configuration file failed."
        return 1
    fi
    timezoneFile="/usr/share/zoneinfo/$acttimez"
    spaces_num=$(echo $timezoneFile | grep " "| wc -l)
    if [ ! -f $timezoneFile ];then
        log_error "Check failed. The timezone does not exist in current operating system."
        return 1
    fi
    if [ $spaces_num -ne 0 ];then
        log_error "Check failed. The timezone does not exist in current operating system."
        return 1
    fi
    log_info "Check timezone in ini file OK."
    return 0
}


function _check_ip_for_3rdplane()
{
    if [ ${#node_list[@]} -le 1 ];then
        return 0
    fi
    for ping_ip in ${node_list[@]};do
        if [ "${ping_ip}" == "${manage_ip}" ];then
            continue
        fi
        karbor_ping -I ${manage_ip} -c 2 -w 3 ${ping_ip} >/dev/null
        if [ $? -ne 0 ];then
            log_error "Exec command karbor_ping -I ${manage_ip} -c 2 -w 3 ${ping_ip} failed."
            return 1
        fi
    done
    log_info "Successfully karbor_ping static IP address in node"
    return 0
}

function _check_dns_ip()
{
    local ret1=$(get_info.py dns_ip)
    if [ ! -n "$ret1" ] || [ "$ret1" = "None" ]; then
        log_info "no dns_ip in the /opt/huawei/dj/cfg/sys.ini"
        return 0
    fi
    ip_list=$(echo $ret1 | tr ',' ' ')
    for ip in $ip_list;
    do
        if [ $IP_VERSION = "ipv6" ];then
            eval "CheckIPV6Addr $ip"
        else
            eval "CheckIPAddr $ip"
        fi
        if [ $? -ne 0 ];then
            log_error "Check failed. The dns ip of ($ip) is invalid."
            return 1
        fi
    done
    log_info "The dns ip of ($ip) is valid."
    return 0
}

check_ini_ip ; CHECK_RESULT $? "Check manage ip failed！"
_check_ip_for_3rdplane ; CHECK_RESULT $? "Check manage ip network ping failed！"
check_ini_hostname ; CHECK_RESULT $? "Check hostname  failed！"
check_ini_timezone ; CHECK_RESULT $? "Check timezone  failed！"
check_floatip_net_segment ; CHECK_RESULT $? "Check noteip and floatip is in same net segment failed！"
_check_dns_ip ; CHECK_RESULT $? "Check dns_ip failed！"
exit 0





