#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source ${cur_dir}/bin/utils.sh
LOG_FILE="/var/log/messages"

function _uninstall_docker_rmi()
{
    ps -ewwf | grep "opensta+" | grep -v grep | awk '{print $2}' | xargs kill -9 >/dev/null 2>&1
    rpm -e --nodeps gaussdata >/dev/null 2>&1
    docker ps -a | grep -v "CONTAINER ID" | awk '{print $1}' | xargs docker rm -f >> /dev/null 2>&1
    docker images | grep -v "IMAGE ID" | awk '{print $3}' | xargs docker rmi -f >> /dev/null 2>&1
    log_info "end to uninstall docker images."
}

function _uninstall_others()
{
    rm -rf /home/{gaussdba,openstack,djmanager}
    userdel -rf djmanager >/dev/null 2>&1
    userdel -rf openstack >/dev/null 2>&1
    userdel -rf gaussdba >/dev/null 2>&1
    groupdel dbgrp >/dev/null 2>&1
    groupdel openstack >/dev/null 2>&1
    chkconfig --del DJControl >/dev/null 2>&1
    rm -rf /etc/init.d/DJControl
    rm -rf /usr/bin/{DJserviceControl,get_info.py,karbor_ping}
    rm -rf /etc/sudoers.d/{djmanager,openstack}
    rm -rf /var/log/{install.log,huawei}
    rm -rf /opt/{djbackup,huawei/dj,fusionplatform}
    rm -rf /etc/rsyslog.d/{rsyslog_*.conf,dj.conf}
    rm -rf /usr/local/bin/{ha,cps-monitor,zookeeper,jre}
    sed -i "s/PermitRootLogin no/PermitRootLogin yes/g"  /etc/ssh/sshd_config >/dev/null 2>&1
    service sshd restart >/dev/null 2>&1
    log_info "uninstall successfully."
}

function _tip()
{
    while [ 1 -eq 1 ];do
        echo "Are you sure to uninstall Karbor (y/n):"
        read char
        if [ "$char" = "y" -o "$char" = "Y" ];then
            break
        elif [ "$char" = "n" -o "$char" = "N" ];then
            exit 1
        else
            continue
        fi
    done
}

_tip
CHECK_RESULT $? "delete_before_local failed"
csbs_python ${cur_dir}/bin/srvmanager.py "${cur_dir}" --uninstall
CHECK_RESULT $? "uninstall backupservice failed"
_uninstall_docker_rmi >/dev/null 2>&1
CHECK_RESULT $? "_uninstall_docker_rmi failed!"
_uninstall_others >/dev/null 2>&1
CHECK_RESULT $? "_uninstall_others failed!"
