#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/huawei/dj/install.log"
USER_HOME="/home/djmanager"
source ${cur_dir}/bin/utils.sh

function showhelp()
{
    echo "Usage: ${cur_dir}/install.sh -f [config file patch]"
    echo "Usage: ${cur_dir}/install.sh -f restore"
}

function install_python()
{
    rpm -ihv ${cur_dir}/repo/platform/euler/eulervm/*.rpm --force --nodeps >/dev/null 2>&1
    rpm -ihv ${cur_dir}/repo/third_party/python-*.rpm --force --nodeps >/dev/null 2>&1
    csbs_python -m pip install --no-deps --force-reinstall ${cur_dir}/repo/third_party/PyYAML-*.whl >/dev/null 2>&1
    csbs_python -m pip install --no-deps --force-reinstall ${cur_dir}/repo/third_party/netifaces-*.whl >/dev/null 2>&1
    csbs_python -m pip install --no-deps --force-reinstall ${cur_dir}/repo/self_developed/basesdk*.whl >/dev/null 2>&1
}

function encrypt_ssh_keyfile()
{
    if [ ! -e "${USER_HOME}/.ssh/id_rsa" ];then
        return 0
    fi
    csbs_python -c "import kmc.kmc;A=kmc.kmc.API();A.file_encrypt(kmc.kmc.KMC_DOMAIN.DEFAULT,'${USER_HOME}/.ssh/id_rsa','${USER_HOME}/.ssh/id_rsa.tmp')"
    if [ $? -ne 0 ];then
        log_error "kmc function run failed."
        return 1
    fi
    if [ ! -e "${USER_HOME}/.ssh/id_rsa.tmp" ];then
        log_error "encrypt ssh key file failed."
        return 1
    fi
    mv ${USER_HOME}/.ssh/id_rsa.tmp ${USER_HOME}/.ssh/id_rsa
    chown -h djmanager:openstack ${USER_HOME}/.ssh/id_rsa
    log_info "encrypt ssh key file  OK."
    flag_path="/home/djmanager/flag"
    rm -rf ${flag_path}
    return 0
}

function chmod_file()
{
    /usr/bin/cp -f ${cur_dir}/conf/dj.version /opt/huawei/dj/cfg
    chown -hR root:openstack /opt/huawei/dj/cfg
    chmod 640 /opt/huawei/dj/cfg/*
    chmod 600 ${USER_HOME}/.ssh/* >/dev/null 2>&1
    sed -i "s/PermitRootLogin yes/PermitRootLogin no/g" /etc/ssh/sshd_config >/dev/null 2>&1
    service sshd restart >/dev/null 2>&1
    log_info "ssh config success."
    return $?
}

function install_config()
{
    mkdir -p /opt/huawei/dj/cfg /var/log/huawei/dj/ /opt/huawei/dj/inst/bin
    /usr/bin/cp -f ${cur_dir}/bin/get_info.py /usr/bin/get_info.py
    /usr/bin/cp -f ${cur_dir}/bin/osConfig/karbor_ping /usr/bin/karbor_ping
    chmod 550 /usr/bin/get_info.py && chmod 550 /usr/bin/karbor_ping
    dos2unix $1 >/dev/null 2>&1
}

if [ $# != 2 ] || [ $1 != "-f" ] || ! [ -f $2 ];
then
    showhelp
    exit 1
fi

if [ -f "/opt/huawei/dj/cfg/dj.version" ];
then
    echo "Karbor software has already installed."
    exit 1
fi

install_python; CHECK_RESULT $? "install python failed!"
install_config $2; CHECK_RESULT $? "install config failed!"

csbs_python ${cur_dir}/bin/pre_install.py -f $2
CHECK_RESULT $? "check install env failed"

csbs_python ${cur_dir}/bin/srvmanager.py "${cur_dir}" --install
result=$?
if [[ ${result} -eq 139 ]];then
    log_info "Install backupservice succeed."
else
    CHECK_RESULT ${result} "Install backupservice failed, status code is ${result}."
fi
encrypt_ssh_keyfile; CHECK_RESULT $? "Encrypt ssh keyfile failed!"
chmod_file; CHECK_RESULT $? "Chmod file failed!"
cmd_retry "scagentControl -A RESTART" 5 10 >/dev/null 2>&1; CHECK_RESULT $? "Restart scagent failed!"
exit 0