#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source $(dirname ${cur_dir})/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
LOG_PATH="/var/log/huawei/dj"
MOUNT_FILE="/etc/fstab"
VOLGROUP_NAME=`vgs | grep -v "#PV" | tail -n -1 | awk '{print $1}'`
ROOT_SIZE=45
OPT_SIZE=75
LOG_PATH_SIZE=25

function auto_vgextend_vg()
{
    # Partition the remaining space of all disks, create PV,
    disks=`fdisk -l | grep -E -o "^Disk /dev/(s|v|h|xv)d[a-z]" |awk '{print $2}'`
    for disk in ${disks[@]}
    do
        total_sectors=`fdisk -l ${disk} |grep -E "^Disk /dev/(s|v|h|xv)d[a-z]" |cut -d ',' -f 3 |cut -d ' ' -f 2`
        used_sectors=`fdisk -l ${disk} |tail -n -1 |awk '{print $3}'`
        if [[ "$((total_sectors-used_sectors))" -gt "1024000" ]];then
            echo -e "n\np\n\n\n\nt\n\n8e\nw\nq\n" | fdisk ${disk}
            partprobe
            CHECK_RESULT $? "Part_probe ${disk} failed."
            part_name=`fdisk -l $disk |tail -n -1 |awk '{print $1}'`
            pvcreate ${part_name}
            CHECK_RESULT $? "Create pv ${part_name} failed."
            if [[ -z "${VOLGROUP_NAME}" ]];then
                VOLGROUP_NAME="CBSVolGroup"
                vgcreate ${VOLGROUP_NAME} ${part_name}
                CHECK_RESULT $? "Create vg ${VOLGROUP_NAME} with ${part_name} failed."
            else
                vgextend ${VOLGROUP_NAME} ${part_name}
                CHECK_RESULT $? "Extend vg ${VOLGROUP_NAME} with ${part_name} failed."
            fi
        fi
    done
}

function auto_resize_for_root()
{
    df | grep "/$"
    CHECK_RESULT $? "Root dir create without vg"
    total_space=`df -k / | tail -n -1 | awk '{print $2}'`
    if [[ "${total_space}" -gt "$[ ROOT_SIZE * 1000 * 1000 ]" ]];then
        return
    fi
    root_lv=`df | grep "/$" |awk '{print $1}'`
    lvextend -L ${ROOT_SIZE}G ${root_lv}
    CHECK_RESULT $? "Lvextend ${root_lv} failed."
    resize2fs ${root_lv}
    CHECK_RESULT $? "Resize2fs ${root_lv} failed."
}

function auto_resize_for_log()
{
    df | grep "${LOG_PATH}$"
    if [[ $? -eq 0 ]];then
        total_space=`df -k ${LOG_PATH} | tail -n -1 | awk '{print $2}'`
        if [[ "${total_space}" -gt "$[ LOG_PATH_SIZE * 1000 * 1000 ]" ]];then
            return
        fi
        log_path_lv=`df | grep "${LOG_PATH}$" |awk '{print $1}'`
        lvextend -L ${LOG_PATH_SIZE}G ${log_path_lv}
        CHECK_RESULT $? "Lvextend ${log_path_lv} failed."
        resize2fs ${log_path_lv}
        CHECK_RESULT $? "Resize2fs ${log_path_lv} failed."
    else
        log_path_lv="karborlog"
        lvcreate -L ${LOG_PATH_SIZE}G -n ${log_path_lv} ${VOLGROUP_NAME}
        CHECK_RESULT $? "Lvcreate ${log_path_lv} failed."
        mkfs -t ext4 /dev/${VOLGROUP_NAME}/${log_path_lv}
        CHECK_RESULT $? "Mkfs ${log_path_lv} failed."
        mount /dev/${VOLGROUP_NAME}/${log_path_lv} ${LOG_PATH}
        CHECK_RESULT $? "Mount ${log_path_lv} failed."
        mount_dir=`blkid -o "export" /dev/${VOLGROUP_NAME}/${log_path_lv} | grep "UUID"`
        CHECK_RESULT $? "Mount_dir ${log_path_lv} failed."
        echo "${mount_dir} ${LOG_PATH}                    ext4   defaults,nodev       1 2" >> ${MOUNT_FILE}
    fi
}

function auto_resize_for_opt()
{
    df | grep "/opt$"
    if [[ $? -eq 0 ]];then
        total_space=`df -k /opt | tail -n -1 | awk '{print $2}'`
        if [[ "${total_space}" -gt "$[ OPT_SIZE * 1000 * 1000 ]" ]];then
            return
        fi
        opt_lv=`df | grep "/opt$" |awk '{print $1}'`
        lvextend -L ${OPT_SIZE}G ${opt_lv}
        CHECK_RESULT $? "Lvextend ${opt_lv} failed."
        resize2fs ${opt_lv}
        CHECK_RESULT $? "Resize2fs ${opt_lv} failed."
    else
        lv_name="opt"
        lvcreate -L ${OPT_SIZE}G -n ${lv_name} ${VOLGROUP_NAME}
        CHECK_RESULT $? "Lvcreate ${lv_name} failed."
        mkfs -t ext4 /dev/${VOLGROUP_NAME}/${lv_name}
        CHECK_RESULT $? "Mkfs ${lv_name} failed."
        mount /dev/${VOLGROUP_NAME}/${lv_name} /opt
        CHECK_RESULT $? "Mount ${lv_name} failed."
        mount_dir=`blkid -o "export" /dev/${VOLGROUP_NAME}/${lv_name} | grep "UUID"`
        CHECK_RESULT $? "Mount_dir ${lv_name} failed."
        echo "${mount_dir} /opt                    ext4   defaults,nodev       1 2" >> ${MOUNT_FILE}
    fi
}


function main()
{
    df | grep "/opt$"
    if [[ $? -eq 0 ]];then
        log_info "Not need allocate disk."
        return
    fi
    auto_vgextend_vg
    auto_resize_for_root
    auto_resize_for_opt
    auto_resize_for_log
    log_info "Allocate disk successfully."
}

main
exit 0
