#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source $(dirname ${cur_dir})/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
CHECK_FILE="/etc/rsyslog.d/rsyslog_docker.conf"

# ===============================add rsyslog=========================
add_rsyslog_conf()
{
    log_info "Begin to add rsyslogd configuration file..."

    local file_name="rsyslog_docker.conf"
    local conf_file="${cur_dir}/${file_name}"

    if [ ! -f ${conf_file} ];then
        log_error "File ${conf_file} doesn't exist."
        exit 1
    fi

    local backup_dir="${cur_dir}/rsyslog_conf_backup"
    rm -rf ${backup_dir}
    mkdir -p ${backup_dir}
    local back_file="${backup_dir}/${file_name}"
    rm -f ${back_file}

    dest_file="/etc/rsyslog.d/${file_name}"
    if [ -f ${dest_file} ];then
        cp ${dest_file} ${back_file}
        CHECK_RESULT $? "Backup file ${dest_file} failed."

        log_info "Remove old ${dest_file}."
        rm -f ${dest_file}
    fi

    cp -f ${conf_file} ${dest_file}
    CHECK_RESULT $? "Copy ${conf_file} to ${dest_file} failed."

    chmod 600 ${dest_file}
    CHECK_RESULT $? "Chanege permission of ${dest_file} failed."

    log_info "Begin to restart rsyslog..."
    systemctl stop sysmonitor
    service rsyslog restart
    systemctl start sysmonitor
    log_info "Restart rsyslog finished."

    log_info "Add rsyslogd configuration file finished."
}

# ===============================del_rsyslog_conf=======================
del_rsyslog_conf()
{
    log_info "Begin to delete rsyslogd configuration file..."
    local file_name="rsyslog_docker.conf"
    local conf_file="/etc/rsyslog.d/${file_name}"

    if [ ! -f ${conf_file} ];then
        log_info "File ${conf_file} doesn't exist, skip."
        exit 0
    fi

    rm -f ${conf_file}
    CHECK_RESULT $? "Remove ${conf_file} failed."

    local backup_dir="${cur_dir}/rsyslog_conf_backup"
    local back_file="${backup_dir}/${file_name}"
    if [ -f ${back_file} ];then
        mv ${back_file} ${conf_file}
        CHECK_RESULT $? "Move ${back_file} to ${conf_file} failed."
    fi

    log_info "Begin to restart rsyslog..."
    systemctl stop sysmonitor
    service rsyslog restart
    systemctl start sysmonitor
    CHECK_RESULT $? "Restart rsyslog failed."
    log_info "Restart rsyslog finished."

    log_info "Delete rsyslogd configuration file finished."
}

# ================================= install ====================================
function install()
{
    if [ -f ${CHECK_FILE} ];then
        log_info "Docker reinforcement has already done."
        exit 0
    fi
    log_info "Start reinforceing docker."

    add_rsyslog_conf
    CHECK_RESULT $? "Add docker log file failed."

    log_info "Enforce docker engine successfully."
}

# ================================= check ======================================
function check()
{
    if [ -f ${CHECK_FILE} ];then
        log_info "Docker reinforcement has already done."
        exit 0
    else
        log_error "Reinforce docker failed."
        exit 1
    fi
}

# ================================= rollback ===================================
function rollback()
{
    if [ ! -f ${CHECK_FILE} ];then
        log_info "Docker reinforcement Rollback has already done."
        exit 0
    fi

    del_rsyslog_conf
    CHECK_RESULT $? "Rollback add docker log file failed."
    log_info "Rollback enforce docker engine successfully."
}

# ================================= main =======================================
main()
{
    if [ $# -ne 1 ]; then
        log_error "Parameter error. Usage: bash enforce.sh [install|check|rollback]."
        exit 1
    fi

    case "$1" in
        install)
            install
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            log_error "Parameter error. Usage: bash enforce.sh [install|check|rollback]."
            exit 1
        ;;
    esac
}

main "$@"
exit 0